/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
public class TempFileProvider {
    private static final Logger logger = LoggerFactory.getLogger(TempFileProvider.class);
    @Autowired
    private ConfigurableEnvironment environment;

    public File getTempFile(String postFix, String extension) throws IOException {
        String nzbhydraTempFolder = (String)this.environment.getProperty("NZBHYDRA_TEMP_FOLDER", String.class);
        if (nzbhydraTempFolder != null) {
            logger.info("Using temp folder {} defined by property NZBHYDRA_TEMP_FOLDER", (Object)nzbhydraTempFolder);
            return new File(nzbhydraTempFolder, "nzbhydra" + RandomStringUtils.randomAlphanumeric((int)5) + extension);
        }
        return Files.createTempFile("nzbhydra-" + postFix, extension, new FileAttribute[0]).toFile();
    }
}

