/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.migration.configmapping;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListOrStringToStringDeserializer
extends JsonDeserializer<List<String>> {
    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object value = p.readValueAs(Object.class);
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String && Strings.isNullOrEmpty((String)((String)value))) {
            return new ArrayList<String>();
        }
        if (value instanceof String) {
            String string = (String)value;
            if (!Strings.isNullOrEmpty((String)((String)value))) {
                List<String> result = new ArrayList<String>();
                if (!string.contains(",")) {
                    result.add(string);
                } else {
                    result = Arrays.asList(string.replace(", ", ",").split(","));
                }
                return result;
            }
        }
        return new ArrayList<String>();
    }
}

