/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.mediainfo;

import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.mediainfo.InfoNotFoundException;
import org.nzbhydra.mediainfo.InfoProviderException;
import org.nzbhydra.mediainfo.TvMazeHandler;
import org.nzbhydra.mediainfo.TvMazeSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class TvMazeHandler {
    private static final Logger logger = LoggerFactory.getLogger(TvMazeHandler.class);
    @Autowired
    protected RestTemplate restTemplate;

    TvMazeSearchResult getInfos(String id, MediaIdType idType) throws InfoProviderException {
        ResponseEntity showLookupResponse;
        if (idType == MediaIdType.TVTITLE) {
            return this.fromTitle(id);
        }
        logger.info("Searching TVMaze for show with {} {}", (Object)idType, (Object)id);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://api.tvmaze.com/");
        builder = switch (2.$SwitchMap$org$nzbhydra$config$mediainfo$MediaIdType[idType.ordinal()]) {
            case 1 -> builder.pathSegment(new String[]{"lookup", "shows"}).queryParam("tvrage", new Object[]{id});
            case 2 -> builder.pathSegment(new String[]{"lookup", "shows"}).queryParam("thetvdb", new Object[]{id});
            case 3, 4 -> builder.pathSegment(new String[]{"lookup", "shows"}).queryParam("imdb", new Object[]{id.startsWith("tt") ? id : "tt" + id});
            case 5 -> builder.pathSegment(new String[]{"shows", id});
            default -> throw new InfoProviderException("Unable to handle " + String.valueOf(idType));
        };
        try {
            showLookupResponse = this.restTemplate.getForEntity(builder.build().encode().toUri(), TvmazeShow.class);
        }
        catch (HttpClientErrorException.NotFound e) {
            throw new InfoNotFoundException("TVMaze doesn't know " + idType.name() + " ID " + id);
        }
        catch (RestClientException e) {
            throw new InfoProviderException("Error while accessing TVMaze", (Throwable)e);
        }
        if (!showLookupResponse.getStatusCode().is2xxSuccessful()) {
            throw new InfoProviderException("TVMaze lookup returned wrong status: " + String.valueOf(showLookupResponse.getStatusCode()));
        }
        TvmazeShow show = (TvmazeShow)showLookupResponse.getBody();
        logger.info("TVMaze found show {}", (Object)show);
        return this.getSearchResultFromShow(show);
    }

    private TvMazeSearchResult fromTitle(String title) throws InfoProviderException {
        logger.info("Searching TVMaze for show with title '{}", (Object)title);
        List shows = this.searchByTitle(title);
        TvmazeShow show = ((TvmazeShowSearch)shows.get(0)).getShow();
        logger.info("TVMaze found {} shows for title '{}'. Using first show {} with a confidence level of {}", new Object[]{shows.size(), title, show, ((TvmazeShowSearch)shows.get(0)).getScore()});
        return this.getSearchResultFromShow(show);
    }

    private TvMazeSearchResult getSearchResultFromShow(TvmazeShow show) {
        Integer year = show.premiered != null ? Integer.valueOf(show.premiered.substring(0, 4)) : null;
        return new TvMazeSearchResult(String.valueOf(show.getId()), show.getExternals().getTvrage(), show.getExternals().getThetvdb(), show.getExternals().getImdb(), show.getName(), year, this.makePosterLinksSecure(show).getMediumPosterUrl());
    }

    List<TvMazeSearchResult> search(String title) throws InfoProviderException {
        logger.info("Searching TVMaze for shows with title '{}", (Object)title);
        List shows = this.searchByTitle(title);
        logger.info("TVMaze found {} shows for title '{}'", (Object)shows.size(), (Object)title);
        return shows.stream().map(showSearch -> this.getSearchResultFromShow(showSearch.getShow())).collect(Collectors.toList());
    }

    private List<TvmazeShowSearch> searchByTitle(String title) throws InfoProviderException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://api.tvmaze.com/search/shows").queryParam("q", new Object[]{title});
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity lookupResponse = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)typeRef);
        if (!lookupResponse.getStatusCode().is2xxSuccessful()) {
            throw new InfoProviderException("TVMaze lookup returned wrong status: " + String.valueOf(lookupResponse.getStatusCode()));
        }
        List shows = (List)lookupResponse.getBody();
        if (shows == null || shows.isEmpty()) {
            throw new InfoProviderException("TVMaze found no series with title " + title);
        }
        shows.forEach(x -> this.makePosterLinksSecure(x.getShow()));
        return shows;
    }

    private TvmazeShow makePosterLinksSecure(TvmazeShow show) {
        if (show.getImage() == null) {
            return show;
        }
        if (show.getImage().getMedium() != null && show.getImage().getMedium().startsWith("http://")) {
            show.getImage().setMedium(show.getImage().getMedium().replace("http://", "https://"));
        }
        if (show.getImage().getOriginal() != null && show.getImage().getOriginal().startsWith("http://")) {
            show.getImage().setOriginal(show.getImage().getOriginal().replace("http://", "https://"));
        }
        return show;
    }
}

