/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.Charsets;
import org.nzbhydra.logging.ReversedLinesFileReader;

public class ReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    @Deprecated
    public ReversedLinesFileReader(File file) throws IOException {
        this(file, 4096, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file, Charset charset) throws IOException {
        this(file, 4096, charset);
    }

    public ReversedLinesFileReader(File file, int blockSize, Charset encoding) throws IOException {
        long totalBlockCount;
        this.blockSize = blockSize;
        this.encoding = encoding;
        Charset charset = Charsets.toCharset((Charset)encoding);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        float maxBytesPerChar = charsetEncoder.maxBytesPerChar();
        if (maxBytesPerChar == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset == Charsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("Shift_JIS") || charset == Charset.forName("windows-31j") || charset == Charset.forName("x-windows-949") || charset == Charset.forName("gbk") || charset == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (charset == Charsets.UTF_16BE || charset == Charsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (charset == Charsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + String.valueOf(encoding) + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(encoding), "\n".getBytes(encoding), "\r".getBytes(encoding)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        long totalByteLength = this.randomAccessFile.length();
        int lastBlockLength = (int)(totalByteLength % (long)blockSize);
        if (lastBlockLength > 0) {
            totalBlockCount = totalByteLength / (long)blockSize + 1L;
        } else {
            totalBlockCount = totalByteLength / (long)blockSize;
            if (totalByteLength > 0L) {
                lastBlockLength = blockSize;
            }
        }
        this.currentFilePart = new FilePart(this, totalBlockCount, lastBlockLength, null);
    }

    public ReversedLinesFileReader(File file, int blockSize, String encoding) throws IOException {
        this(file, blockSize, Charsets.toCharset((String)encoding));
    }

    public String readLine() throws IOException {
        String line = null;
        try {
            line = this.currentFilePart.readLine();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        while (line == null) {
            this.currentFilePart = this.currentFilePart.rollOver();
            if (this.currentFilePart == null) break;
            line = this.currentFilePart.readLine();
        }
        if ("".equals(line) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            line = this.readLine();
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }
}

