/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.status;

import jakarta.persistence.EntityManager;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.status.IndexerLimit;
import org.nzbhydra.indexers.status.IndexerLimitRepository;
import org.nzbhydra.indexers.status.IndexerStatusesAndLimits;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.SearchModuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexerStatusesAndLimits {
    private static final Logger logger = LoggerFactory.getLogger(IndexerStatusesAndLimits.class);
    private static final DateTimeFormatter DATE_PATTERN = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH:mm:ss:SSS");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private IndexerLimitRepository indexerLimitRepository;
    @Autowired
    private SearchModuleProvider searchModuleProvider;

    public List<IndexerStatus> getSortedStatuses() {
        return this.configProvider.getBaseConfig().getIndexers().stream().sorted(Comparator.comparing(IndexerConfig::getState).thenComparing(o -> o.getName().toLowerCase())).map(arg_0 -> this.getIndexerStatus(arg_0)).collect(Collectors.toList());
    }

    private IndexerStatus getIndexerStatus(IndexerConfig x) {
        IndexerStatus indexerStatus = new IndexerStatus();
        indexerStatus.setIndexer(x.getName());
        indexerStatus.setState(x.getState().name());
        indexerStatus.setLevel(x.getDisabledLevel());
        indexerStatus.setDisabledUntil(x.getDisabledUntil() == null ? null : Instant.ofEpochMilli(x.getDisabledUntil()));
        indexerStatus.setVipExpirationDate(x.getVipExpirationDate());
        indexerStatus.setLastError(x.getLastError());
        this.setLimitRelatedValues(x, indexerStatus);
        x.getHitLimit().ifPresent(arg_0 -> ((IndexerStatus)indexerStatus).setApiHitLimit(arg_0));
        x.getDownloadLimit().ifPresent(arg_0 -> ((IndexerStatus)indexerStatus).setDownloadHitLimit(arg_0));
        return indexerStatus;
    }

    private void setLimitRelatedValues(IndexerConfig indexerConfig, IndexerStatus indexerStatus) {
        IndexerEntity indexerEntity = this.searchModuleProvider.getIndexerByName(indexerConfig.getName()).getIndexerEntity();
        IndexerLimit limitEntity = this.indexerLimitRepository.findByIndexer(indexerEntity);
        indexerStatus.setApiHitLimit(limitEntity.getApiHitLimit());
        indexerStatus.setDownloadHitLimit(limitEntity.getDownloadLimit());
        indexerStatus.setApiHits(limitEntity.getApiHits());
        indexerStatus.setDownloadHits(limitEntity.getDownloads());
        logger.debug(LoggingMarkers.LIMITS, "Found limits in database for indexer {}: {}", (Object)indexerConfig.getName(), (Object)limitEntity);
        if (limitEntity.getApiHits() == null || limitEntity.getDownloads() == null) {
            this.setFromApiShortTermStorage(indexerConfig, indexerStatus, indexerEntity);
        }
    }

    private void setFromApiShortTermStorage(IndexerConfig indexerConfig, IndexerStatus indexerStatus, IndexerEntity indexerEntity) {
        Instant nextResetTime;
        LimitsRetrieval limitsRetrieval = new LimitsRetrieval(this, indexerConfig, indexerEntity).invoke();
        logger.debug(LoggingMarkers.LIMITS, "Setting api limits from short term storage for indexer {}: {}", (Object)indexerConfig.getName(), (Object)limitsRetrieval);
        int countApiHits = limitsRetrieval.getCountApiHits();
        int countDownloads = limitsRetrieval.getCountDownloads();
        Instant earliestApiHit = limitsRetrieval.getEarliestApiHit();
        Instant earliestDownload = limitsRetrieval.getEarliestDownload();
        if (indexerStatus.getApiHits() == null) {
            indexerStatus.setApiHits(Integer.valueOf(countApiHits));
            if (indexerConfig.getHitLimit().isPresent() && countApiHits >= (Integer)indexerConfig.getHitLimit().get()) {
                if (indexerConfig.getHitLimitResetTime().isPresent()) {
                    nextResetTime = this.getResetTime(indexerConfig);
                    indexerStatus.setApiResetTime(nextResetTime);
                } else {
                    indexerStatus.setApiResetTime(earliestApiHit.plus(1L, ChronoUnit.DAYS));
                }
            }
        }
        if (indexerStatus.getDownloadHits() == null) {
            indexerStatus.setDownloadHits(Integer.valueOf(countDownloads));
            if (indexerConfig.getDownloadLimit().isPresent() && countDownloads >= (Integer)indexerConfig.getDownloadLimit().get()) {
                if (indexerConfig.getHitLimitResetTime().isPresent()) {
                    nextResetTime = this.getResetTime(indexerConfig);
                    indexerStatus.setDownloadResetTime(nextResetTime);
                } else {
                    indexerStatus.setDownloadResetTime(earliestDownload.plus(1L, ChronoUnit.DAYS));
                }
            }
        }
        logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Saving from API shot term storage: {}", (Object)indexerConfig.getName(), (Object)indexerStatus);
    }

    private Instant getResetTime(IndexerConfig indexerConfig) {
        if (indexerConfig.getHitLimitResetTime().isEmpty()) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
        LocalDateTime nextPossibleHit = now.truncatedTo(ChronoUnit.DAYS).with(ChronoField.HOUR_OF_DAY, ((Integer)indexerConfig.getHitLimitResetTime().get()).intValue());
        if (nextPossibleHit.isBefore(now)) {
            nextPossibleHit = nextPossibleHit.plus(1L, ChronoUnit.DAYS);
        }
        return nextPossibleHit.toInstant(ZoneOffset.UTC);
    }
}

