/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.capscheck;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.indexer.CapsCheckRequest;
import org.nzbhydra.config.indexer.CheckCapsResponse;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.indexers.capscheck.IndexerChecker;
import org.nzbhydra.indexers.capscheck.IndexerWeb;
import org.nzbhydra.indexers.capscheck.JacketConfigRetriever;
import org.nzbhydra.indexers.capscheck.SimpleConnectionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IndexerWeb {
    private static final Logger logger = LoggerFactory.getLogger(IndexerWeb.class);
    private static final Pattern JACKETT_INDEXER_PATTERM = Pattern.compile(".*/indexers/(.*)/results/torznab.*");
    @Autowired
    private IndexerChecker newznabChecker;
    @Autowired
    private SimpleConnectionChecker simpleConnectionChecker;
    @Autowired
    private JacketConfigRetriever jacketConfigRetriever;
    Multimap<String, String> multimap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/indexer/checkCaps"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public List<CheckCapsResponse> checkCaps(@RequestBody CapsCheckRequest capsCheckRequest) {
        this.multimap.clear();
        return this.newznabChecker.checkCaps(capsCheckRequest);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/indexer/checkCapsMessages/{indexerName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<String> getCheckerMessages(@PathVariable String indexerName) {
        return this.multimap.get((Object)indexerName);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/indexer/checkCapsMessages"}, method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, Collection<String>> getCheckerMessages() {
        return this.multimap.asMap();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/indexer/checkConnection"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public GenericResponse testConnection(@RequestBody IndexerConfig indexerConfig) {
        if (indexerConfig.getSearchModuleType() == SearchModuleType.NEWZNAB || indexerConfig.getSearchModuleType() == SearchModuleType.TORZNAB) {
            return this.newznabChecker.checkConnection(indexerConfig);
        }
        return this.simpleConnectionChecker.checkConnection(indexerConfig);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/indexer/readJackettConfig"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public JacketConfigReadResponse readJackettConfig(@RequestBody JacketConfigReadRequest configReadRequest) throws Exception {
        JacketConfigReadResponse response = new JacketConfigReadResponse();
        ArrayList<IndexerConfig> newConfigs = new ArrayList<IndexerConfig>(configReadRequest.existingIndexers);
        List foundJackettConfigs = this.jacketConfigRetriever.retrieveIndexers(configReadRequest.jackettConfig);
        int countUpdatedTrackers = 0;
        int countAddedTrackers = 0;
        for (IndexerConfig foundJackettConfig : foundJackettConfigs) {
            Optional<IndexerConfig> updatedIndexer = configReadRequest.existingIndexers.stream().filter(x -> this.isMatch(foundJackettConfig, x)).findFirst();
            if (updatedIndexer.isPresent()) {
                updatedIndexer.get().setHost(foundJackettConfig.getHost());
                updatedIndexer.get().setApiKey(foundJackettConfig.getApiKey());
                updatedIndexer.get().setSupportedSearchIds(foundJackettConfig.getSupportedSearchIds());
                updatedIndexer.get().setSupportedSearchTypes(foundJackettConfig.getSupportedSearchTypes());
                ++countUpdatedTrackers;
                continue;
            }
            newConfigs.add(foundJackettConfig);
            ++countAddedTrackers;
        }
        logger.info("Found {} new and {} updated trackers", (Object)countAddedTrackers, (Object)countUpdatedTrackers);
        response.setNewIndexersConfig(newConfigs);
        response.setUpdatedTrackers(countUpdatedTrackers);
        response.setAddedTrackers(countAddedTrackers);
        return response;
    }

    private boolean isMatch(IndexerConfig a, IndexerConfig b) {
        Matcher aMatcher = JACKETT_INDEXER_PATTERM.matcher(a.getHost().toLowerCase());
        if (!aMatcher.matches()) {
            return false;
        }
        Matcher bMatcher = JACKETT_INDEXER_PATTERM.matcher(b.getHost().toLowerCase());
        if (!bMatcher.matches()) {
            return false;
        }
        return aMatcher.group(1).equals(bMatcher.group(1));
    }

    @EventListener
    public void handleCheckerEvent(IndexerChecker.CheckerEvent event) {
        if (!this.multimap.get((Object)event.getIndexerName()).contains(event.getMessage())) {
            this.multimap.put((Object)event.getIndexerName(), (Object)event.getMessage());
        }
    }
}

