/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.capscheck;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.BackendType;
import org.nzbhydra.config.indexer.CapsCheckRequest;
import org.nzbhydra.config.indexer.CheckCapsResponse;
import org.nzbhydra.config.indexer.IndexerCategoryConfig;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.indexers.IndexerWebAccess;
import org.nzbhydra.indexers.capscheck.IndexerChecker;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.logging.MdcThreadPoolExecutor;
import org.nzbhydra.mapping.newznab.ActionAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlApilimits;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlError;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.mapping.newznab.xml.Xml;
import org.nzbhydra.mapping.newznab.xml.caps.CapsXmlCategory;
import org.nzbhydra.mapping.newznab.xml.caps.CapsXmlRoot;
import org.nzbhydra.searching.SearchModuleProvider;
import org.nzbhydra.webaccess.WebAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class IndexerChecker {
    private static final Logger logger = LoggerFactory.getLogger(IndexerChecker.class);
    static int PAUSE_BETWEEN_CALLS = 1000;
    public static final int MAX_CONNECTIONS = 2;
    public static final int ID_THRESHOLD_PERCENT = 60;
    private static final Set<CapsCheckLimit> CAPS_CHECK_LIMITS = Sets.newHashSet((Object[])new CapsCheckLimit[]{new CapsCheckLimit(1, 2000, "rarbg"), new CapsCheckLimit(1, 2500, "nzb.su"), new CapsCheckLimit(1, 2500, "nzb.life")});
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    protected IndexerWebAccess indexerWebAccess;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private SearchModuleProvider searchModuleProvider;

    public List<CheckCapsResponse> checkCaps(CapsCheckRequest request) {
        if (request.getCheckType() == CapsCheckRequest.CheckType.SINGLE) {
            return Collections.singletonList(this.checkCaps(request.getIndexerConfig()));
        }
        return this.checkCaps(request.getCheckType());
    }

    public GenericResponse checkConnection(IndexerConfig indexerConfig) {
        try {
            URI uri = IndexerChecker.getBaseUri((IndexerConfig)indexerConfig).queryParam("t", new Object[]{"search"}).queryParam("q", new Object[]{"mp3"}).build().toUri();
            Xml xmlResponse = (Xml)this.indexerWebAccess.get(uri, indexerConfig);
            logger.debug("Checking connection to indexer {} using URI {}", (Object)indexerConfig.getName(), (Object)uri);
            if (xmlResponse instanceof NewznabXmlError) {
                logger.warn("Connection check with indexer {} failed with message: {}", (Object)indexerConfig.getName(), (Object)((NewznabXmlError)xmlResponse).getDescription());
                return GenericResponse.notOk((String)("Indexer returned message: " + ((NewznabXmlError)xmlResponse).getDescription()));
            }
            NewznabXmlRoot rssRoot = (NewznabXmlRoot)xmlResponse;
            this.searchModuleProvider.registerApiHitLimits(indexerConfig.getName(), 1);
            if (!rssRoot.getRssChannel().getItems().isEmpty()) {
                if (indexerConfig.getSearchModuleType() == SearchModuleType.NEWZNAB && this.isTorznabResult(rssRoot) && !indexerConfig.getHost().contains("animetosho")) {
                    logger.error("Indexer added as newznab but returns torznab results");
                    return GenericResponse.notOk((String)"You added the indexer as newznab indexer but the results indicate a torznab indexer");
                }
                if (indexerConfig.getSearchModuleType() == SearchModuleType.TORZNAB && this.isNewznabResult(rssRoot) && !indexerConfig.getHost().contains("animetosho")) {
                    logger.error("Indexer added as torznab but returns newznab results");
                    return GenericResponse.notOk((String)"You added the indexer as torznab indexer but the results indicate a newznab indexer");
                }
                logger.info("Connection to indexer {} successful", (Object)indexerConfig.getName());
                return GenericResponse.ok();
            }
            logger.warn("Connection to indexer {} successful but search did not return any results", (Object)indexerConfig.getName());
            return GenericResponse.notOk((String)"Indexer did not return any results");
        }
        catch (IllegalArgumentException | IndexerAccessException e) {
            logger.warn("Connection check with indexer {} failed with message: {}", (Object)indexerConfig.getName(), (Object)e.getMessage());
            return GenericResponse.notOk((String)e.getMessage());
        }
    }

    public List<IndexerConfig> retrieveJackettIndexers() {
        ArrayList configs = new ArrayList();
        return null;
    }

    static UriComponentsBuilder getBaseUri(IndexerConfig indexerConfig) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)indexerConfig.getHost()).path(indexerConfig.getApiPath().orElse("/api"));
        if (!Strings.isNullOrEmpty((String)indexerConfig.getApiKey())) {
            builder.queryParam("apikey", new Object[]{indexerConfig.getApiKey()});
        }
        return builder;
    }

    protected boolean isTorznabResult(NewznabXmlRoot rssRoot) {
        return rssRoot.getRssChannel().getItems().stream().anyMatch(x -> x.getEnclosures().stream().anyMatch(enclosure -> "application/x-bittorrent".equals(enclosure.getType())) || !x.getTorznabAttributes().isEmpty());
    }

    protected boolean isNewznabResult(NewznabXmlRoot rssRoot) {
        return rssRoot.getRssChannel().getItems().stream().anyMatch(x -> x.getEnclosures().stream().anyMatch(enclosure -> "application/x-nzb".equals(enclosure.getType())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckCapsResponse checkCaps(IndexerConfig indexerConfig) {
        List<CheckCapsRequest> requests = Arrays.asList(new CheckCapsRequest(indexerConfig, "tvsearch", MediaIdType.TVDB, "tvdbid", "121361", Arrays.asList("Thrones", "GOT")), new CheckCapsRequest(indexerConfig, "tvsearch", MediaIdType.TVRAGE, "rid", "24493", Arrays.asList("Thrones", "GOT")), new CheckCapsRequest(indexerConfig, "tvsearch", MediaIdType.TVMAZE, "tvmazeid", "82", Arrays.asList("Thrones", "GOT")), new CheckCapsRequest(indexerConfig, "tvsearch", MediaIdType.TRAKT, "traktid", "1390", Arrays.asList("Thrones", "GOT")), new CheckCapsRequest(indexerConfig, "tvsearch", MediaIdType.TVIMDB, "imdbid", "0944947", Arrays.asList("Thrones", "GOT")), new CheckCapsRequest(indexerConfig, "movie", MediaIdType.TMDB, "tmdbid", "24428", Arrays.asList("Avengers", "Vengadores")), new CheckCapsRequest(indexerConfig, "movie", MediaIdType.IMDB, "imdbid", "0848228", Arrays.asList("Avengers", "Vengadores")));
        boolean allChecked = true;
        boolean configComplete = true;
        int timeout = indexerConfig.getTimeout().orElse(this.configProvider.getBaseConfig().getSearching().getTimeout()) + 1;
        CapsCheckLimit capsCheckLimit = CAPS_CHECK_LIMITS.stream().filter(x -> indexerConfig.getHost().toLowerCase().contains(x.urlContains)).findFirst().orElse(new CapsCheckLimit(2, PAUSE_BETWEEN_CALLS, null));
        ArrayList<Callable<SingleCheckCapsResponse>> callables = new ArrayList<Callable<SingleCheckCapsResponse>>();
        for (CheckCapsRequest request : requests) {
            callables.add(() -> {
                Thread.sleep(capsCheckLimit.delayInMiliseconds);
                return this.singleCheckCaps(request, indexerConfig);
            });
        }
        HashSet<SingleCheckCapsResponse> responses = new HashSet<SingleCheckCapsResponse>();
        String backend = null;
        MdcThreadPoolExecutor executor = MdcThreadPoolExecutor.newWithInheritedMdc((int)capsCheckLimit.maxConnections);
        try {
            logger.info("Will check capabilities of indexer {} using {} concurrent connections and a delay of {}ms", new Object[]{indexerConfig.getName(), capsCheckLimit.maxConnections, capsCheckLimit.delayInMiliseconds});
            List futures = executor.invokeAll(callables);
            Future<IndexerConfig.ForbiddenWordPrefix> forbiddenWordPrefixFuture = executor.submit(() -> {
                Thread.sleep(capsCheckLimit.delayInMiliseconds);
                return this.determineForbiddenWordPrefix(indexerConfig);
            });
            for (Future future : futures) {
                try {
                    SingleCheckCapsResponse response = (SingleCheckCapsResponse)future.get(timeout, TimeUnit.SECONDS);
                    if (response.getBackend() != null) {
                        backend = response.getBackend();
                    }
                    responses.add(response);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IndexerAccessException) {
                        logger.error("Error while communicating with indexer: {}", (Object)e.getMessage());
                    } else {
                        logger.error("Unexpected error while checking caps", (Throwable)e);
                    }
                    allChecked = false;
                }
                catch (TimeoutException e) {
                    logger.error("Indexer {} failed to answer in {} seconds", (Object)indexerConfig.getName(), (Object)timeout);
                    allChecked = false;
                }
            }
            try {
                IndexerConfig.ForbiddenWordPrefix prefix = forbiddenWordPrefixFuture.get();
                logger.info("Prefix for forbidden words: {}", (Object)prefix);
                indexerConfig.setForbiddenWordPrefix(prefix);
            }
            catch (ExecutionException e) {
                allChecked = false;
                logger.error("Error checking forbidden word prefix", (Throwable)e);
            }
            Set supportedIds = responses.stream().filter(SingleCheckCapsResponse::isSupported).map(SingleCheckCapsResponse::getIdType).collect(Collectors.toSet());
            Optional<SingleCheckCapsResponse> responseWithLimits = responses.stream().filter(x -> x.getApiMax() != null).findFirst();
            if (responseWithLimits.isPresent()) {
                logger.info("Determined an api hit limit of {} and a download limit of {}", (Object)responseWithLimits.get().apiMax, (Object)responseWithLimits.get().downloadsMax);
                if (indexerConfig.getHitLimit().isEmpty() && responseWithLimits.get().apiMax > -1) {
                    indexerConfig.setHitLimit(responseWithLimits.get().apiMax);
                }
                if (indexerConfig.getDownloadLimit().isEmpty() && responseWithLimits.get().downloadsMax > -1) {
                    indexerConfig.setDownloadLimit(responseWithLimits.get().downloadsMax);
                }
            }
            if (supportedIds.isEmpty()) {
                logger.info("Indexer {} does not support searching by any IDs", (Object)indexerConfig.getName());
            } else {
                logger.info("Indexer {} supports searching using the following IDs: {}", (Object)indexerConfig.getName(), (Object)supportedIds.stream().map(Enum::name).collect(Collectors.joining(", ")));
            }
            indexerConfig.setSupportedSearchIds(new ArrayList(supportedIds));
        }
        catch (InterruptedException e) {
            logger.error("Unexpected error while checking caps", (Throwable)e);
            allChecked = false;
        }
        finally {
            executor.shutdown();
        }
        try {
            this.setSupportedSearchTypesAndIndexerCategoryMapping(indexerConfig, timeout);
            if (indexerConfig.getSupportedSearchTypes().isEmpty()) {
                logger.info("Indexer {} does not support any special search types", (Object)indexerConfig.getName());
            } else {
                logger.info("Indexer {} supports the following search types: {}", (Object)indexerConfig.getName(), (Object)indexerConfig.getSupportedSearchTypes().stream().map(Enum::name).collect(Collectors.joining(", ")));
            }
        }
        catch (IndexerAccessException e) {
            logger.error("Error while accessing indexer: {}", (Object)e.getMessage());
            configComplete = false;
        }
        BackendType backendType = BackendType.NEWZNAB;
        if (backend == null && indexerConfig.getSearchModuleType() == SearchModuleType.NEWZNAB) {
            logger.info("Indexer {} didn't provide a backend type. Will use newznab.", (Object)indexerConfig.getName());
        } else if (backend != null) {
            try {
                backendType = BackendType.valueOf((String)backend.toUpperCase());
                logger.info("Indexer {} uses backend type {}", (Object)indexerConfig.getName(), (Object)backendType);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Indexer {} reported unknown backend type {}. Will use newznab for now. Please report this.", (Object)indexerConfig.getName(), (Object)backend);
            }
        }
        indexerConfig.setBackend(backendType);
        indexerConfig.setConfigComplete(configComplete);
        indexerConfig.setAllCapsChecked(allChecked);
        indexerConfig.setState(configComplete ? IndexerConfig.State.ENABLED : IndexerConfig.State.DISABLED_SYSTEM);
        return new CheckCapsResponse(indexerConfig, allChecked, configComplete);
    }

    public IndexerConfig.ForbiddenWordPrefix determineForbiddenWordPrefix(IndexerConfig indexerConfig) {
        NewznabXmlRoot root;
        URI uri = IndexerChecker.getBaseUri((IndexerConfig)indexerConfig).queryParam("t", new Object[]{"search"}).queryParam("q", new Object[]{"Avengers --1080p"}).build().toUri();
        try {
            root = (NewznabXmlRoot)this.indexerWebAccess.get(uri, indexerConfig, NewznabXmlRoot.class);
            if (!root.getRssChannel().getItems().isEmpty() && root.getRssChannel().getItems().stream().noneMatch(x -> x.getTitle().contains("1080p"))) {
                logger.info("Determined forbidden word prefix \"--\" for indexer {}", (Object)indexerConfig.getName());
                return IndexerConfig.ForbiddenWordPrefix.DOUBLE_DASH;
            }
        }
        catch (IndexerAccessException e) {
            logger.error("Error while determining forbidden word prefix", (Throwable)e);
            return IndexerConfig.ForbiddenWordPrefix.UNKNOWN;
        }
        uri = IndexerChecker.getBaseUri((IndexerConfig)indexerConfig).queryParam("t", new Object[]{"search"}).queryParam("q", new Object[]{"Avengers !1080p"}).build().toUri();
        try {
            root = (NewznabXmlRoot)this.indexerWebAccess.get(uri, indexerConfig, NewznabXmlRoot.class);
            if (!root.getRssChannel().getItems().isEmpty() && root.getRssChannel().getItems().stream().noneMatch(x -> x.getTitle().contains("1080p"))) {
                logger.info("Determined forbidden word prefix \"!\" for indexer {}", (Object)indexerConfig.getName());
                return IndexerConfig.ForbiddenWordPrefix.EXCLAMATION_MARK;
            }
        }
        catch (IndexerAccessException e) {
            logger.error("Error while determining forbidden word prefix", (Throwable)e);
            return IndexerConfig.ForbiddenWordPrefix.UNKNOWN;
        }
        return IndexerConfig.ForbiddenWordPrefix.UNSUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CheckCapsResponse> checkCaps(CapsCheckRequest.CheckType checkType) {
        Predicate<IndexerConfig> isToBeCheckedPredicate = x -> !(x.getState() != IndexerConfig.State.ENABLED || x.getSearchModuleType() != SearchModuleType.NEWZNAB && x.getSearchModuleType() != SearchModuleType.TORZNAB || !x.isConfigComplete() || checkType != CapsCheckRequest.CheckType.ALL && x.isAllCapsChecked());
        List<IndexerConfig> configsToCheck = this.configProvider.getBaseConfig().getIndexers().stream().filter(isToBeCheckedPredicate).toList();
        if (configsToCheck.isEmpty()) {
            logger.info("No indexers to check");
            return Collections.emptyList();
        }
        logger.info("Calling caps check for indexers {}", (Object)configsToCheck.stream().map(IndexerConfig::getName).collect(Collectors.joining(", ")));
        ExecutorService executor = Executors.newFixedThreadPool(configsToCheck.size());
        ArrayList<CheckCapsResponse> responses = new ArrayList<CheckCapsResponse>();
        try {
            List futures = executor.invokeAll(configsToCheck.stream().map(x -> () -> this.checkCaps(x)).collect(Collectors.toList()));
            for (Future future : futures) {
                try {
                    responses.add((CheckCapsResponse)future.get());
                }
                catch (ExecutionException e) {
                    logger.error("Error while calling caps check", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Error while calling caps check for all indexers", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
        return responses;
    }

    public void setSupportedSearchTypesAndIndexerCategoryMapping(IndexerConfig indexerConfig, int timeout) throws IndexerAccessException {
        URI uri = IndexerChecker.getBaseUri((IndexerConfig)indexerConfig).queryParam("t", new Object[]{"caps"}).build().toUri();
        Object response = this.indexerWebAccess.get(uri, indexerConfig);
        if (!(response instanceof CapsXmlRoot)) {
            NewznabXmlError error;
            if (response instanceof NewznabXmlRoot && (error = ((NewznabXmlRoot)response).getError()) != null) {
                throw new IndexerAccessException("Indexer reported error during caps check: " + String.valueOf(error));
            }
            throw new IndexerAccessException("Unexpected indexer response");
        }
        IndexerChecker.fillIndexerConfigFromXmlCapsResponse((IndexerConfig)indexerConfig, (CapsXmlRoot)((CapsXmlRoot)response));
    }

    static void fillIndexerConfigFromXmlCapsResponse(IndexerConfig indexerConfig, CapsXmlRoot response) {
        CapsXmlRoot capsRoot;
        List supportedSearchIds = indexerConfig.getSupportedSearchIds();
        ArrayList<ActionAttribute> supportedSearchTypes = new ArrayList<ActionAttribute>();
        if (supportedSearchIds.contains(MediaIdType.TVDB) || supportedSearchIds.contains(MediaIdType.TVRAGE) || supportedSearchIds.contains(MediaIdType.TVMAZE) || supportedSearchIds.contains(MediaIdType.TRAKT) || supportedSearchIds.contains(MediaIdType.TVIMDB)) {
            supportedSearchTypes.add(ActionAttribute.TVSEARCH);
        }
        if (supportedSearchIds.contains(MediaIdType.IMDB) || supportedSearchIds.contains(MediaIdType.TMDB)) {
            supportedSearchTypes.add(ActionAttribute.MOVIE);
        }
        if ((capsRoot = response).getSearching().getAudioSearch() != null && "yes".equals(capsRoot.getSearching().getAudioSearch().getAvailable())) {
            supportedSearchTypes.add(ActionAttribute.AUDIO);
        }
        if (capsRoot.getSearching().getBookSearch() != null && "yes".equals(capsRoot.getSearching().getBookSearch().getAvailable())) {
            supportedSearchTypes.add(ActionAttribute.BOOK);
        }
        indexerConfig.setSupportedSearchTypes(supportedSearchTypes);
        IndexerCategoryConfig categoryConfig = new IndexerCategoryConfig();
        List categories = IndexerChecker.readAndConvertCategories((IndexerCategoryConfig)categoryConfig, (List)capsRoot.getCategories().getCategories());
        IndexerChecker.setCategorySpecificMappings((IndexerCategoryConfig)categoryConfig, (List)categories);
        indexerConfig.setCategoryMapping(categoryConfig);
    }

    private static void setCategorySpecificMappings(IndexerCategoryConfig categoryConfig, List<CapsXmlCategory> categories) {
        Optional<CapsXmlCategory> anime = categories.stream().filter(x -> x.getName().toLowerCase().contains("anime") && x.getId() / 1000 != 6).findFirst();
        anime.ifPresent(capsCategory -> categoryConfig.setAnime(Integer.valueOf(capsCategory.getId())));
        Optional<CapsXmlCategory> audiobook = categories.stream().filter(x -> x.getName().toLowerCase().contains("audiobook")).findFirst();
        audiobook.ifPresent(capsCategory -> categoryConfig.setAudiobook(Integer.valueOf(capsCategory.getId())));
        Optional<CapsXmlCategory> comic = categories.stream().filter(x -> x.getName().toLowerCase().contains("comic")).findFirst();
        comic.ifPresent(capsCategory -> categoryConfig.setComic(Integer.valueOf(capsCategory.getId())));
        Optional<CapsXmlCategory> ebook = categories.stream().filter(x -> x.getName().toLowerCase().contains("ebook") || x.getName().toLowerCase().contains("e-book")).findFirst();
        ebook.ifPresent(capsCategory -> categoryConfig.setEbook(Integer.valueOf(capsCategory.getId())));
        Optional<CapsXmlCategory> magazine = categories.stream().filter(x -> x.getName().toLowerCase().contains("magazine") || x.getName().toLowerCase().contains("mags")).findFirst();
        magazine.ifPresent(capsCategory -> categoryConfig.setMagazine(Integer.valueOf(capsCategory.getId())));
    }

    private static List<CapsXmlCategory> readAndConvertCategories(IndexerCategoryConfig categoryConfig, List<CapsXmlCategory> capsXmlCategories) {
        ArrayList<CapsXmlCategory> categories = new ArrayList<CapsXmlCategory>(capsXmlCategories);
        ArrayList<IndexerCategoryConfig.MainCategory> configMainCategories = new ArrayList<IndexerCategoryConfig.MainCategory>();
        for (CapsXmlCategory category : capsXmlCategories) {
            List<Object> configSubcats = new ArrayList();
            if (category.getSubCategories() != null) {
                categories.addAll(category.getSubCategories());
                configSubcats = category.getSubCategories().stream().map(x -> new IndexerCategoryConfig.SubCategory(x.getId(), x.getName())).collect(Collectors.toList());
            }
            configMainCategories.add(new IndexerCategoryConfig.MainCategory(category.getId(), category.getName(), configSubcats));
        }
        categoryConfig.setCategories(configMainCategories);
        return categories;
    }

    private SingleCheckCapsResponse singleCheckCaps(CheckCapsRequest request, IndexerConfig indexerConfig) throws IndexerAccessException {
        URI uri = IndexerChecker.getBaseUri((IndexerConfig)request.getIndexerConfig()).queryParam("t", new Object[]{request.getTMode()}).queryParam(request.getKey(), new Object[]{request.getValue()}).build().toUri();
        logger.debug("Calling URL {}", (Object)uri);
        Xml response = null;
        try {
            response = (Xml)this.indexerWebAccess.get(uri, indexerConfig);
        }
        catch (IndexerAccessException e) {
            boolean notSupported = false;
            if (e.getCause() instanceof IndexerWebAccess.HydraUnmarshallingFailureException) {
                String indexerResponse = ((IndexerWebAccess.HydraUnmarshallingFailureException)e.getCause()).getResponse();
                if (indexerResponse != null && indexerResponse.toLowerCase().contains("function not available")) {
                    notSupported = true;
                }
            } else {
                Throwable indexerResponse = e.getCause();
                if (indexerResponse instanceof WebAccessException) {
                    WebAccessException webAccessException = (WebAccessException)indexerResponse;
                    boolean bl = notSupported = webAccessException.getBody() != null && webAccessException.getBody().toLowerCase().contains("function not available");
                }
            }
            if (e.getMessage() != null && e.getMessage().contains("Incorrect parameter")) {
                notSupported = true;
            }
            if (notSupported) {
                return new SingleCheckCapsResponse(request.getKey(), request.getIdType(), false, null, null, null);
            }
            throw e;
        }
        this.searchModuleProvider.registerApiHitLimits(indexerConfig.getName(), 1);
        if (response instanceof NewznabXmlError) {
            String errorDescription = ((NewznabXmlError)response).getDescription();
            if (errorDescription.toLowerCase().contains("function not available") || errorDescription.toLowerCase().contains("does not support the requested query")) {
                logger.error("Indexer {} reports that it doesn't support the ID type {}", (Object)request.indexerConfig.getName(), (Object)request.getIdType());
                this.eventPublisher.publishEvent((Object)new CheckerEvent(indexerConfig.getName(), "Doesn't support " + String.valueOf(request.getIdType())));
                return new SingleCheckCapsResponse(request.getKey(), request.getIdType(), false, null, null, null);
            }
            logger.debug("RSS error from indexer {}: {}", (Object)request.indexerConfig.getName(), (Object)errorDescription);
            this.eventPublisher.publishEvent((Object)new CheckerEvent(indexerConfig.getName(), "RSS error from indexer: " + errorDescription));
            throw new IndexerAccessException("RSS error from indexer: " + errorDescription);
        }
        NewznabXmlRoot rssRoot = (NewznabXmlRoot)response;
        if (rssRoot.getRssChannel().getItems().isEmpty()) {
            logger.info("Indexer {} probably doesn't support the ID type {}. It returned no results.", (Object)request.indexerConfig.getName(), (Object)request.getIdType());
            this.eventPublisher.publishEvent((Object)new CheckerEvent(indexerConfig.getName(), "Probably doesn't support " + String.valueOf(request.getIdType())));
            return new SingleCheckCapsResponse(request.getKey(), request.getIdType(), false, rssRoot.getRssChannel().getGenerator(), null, null);
        }
        long countCorrectResults = rssRoot.getRssChannel().getItems().stream().filter(x -> request.getTitleExpectedToContain().stream().anyMatch(y -> x.getTitle().toLowerCase().contains(y.toLowerCase()))).count();
        float percentCorrect = (float)(100L * countCorrectResults) / (float)rssRoot.getRssChannel().getItems().size();
        boolean supported = percentCorrect >= 60.0f;
        Integer maxApi = null;
        Integer maxDownloads = null;
        NewznabXmlApilimits apiLimits = rssRoot.getRssChannel().getApiLimits();
        if (apiLimits != null) {
            maxApi = apiLimits.getApiMax();
            maxDownloads = apiLimits.getGrabMax();
            this.eventPublisher.publishEvent((Object)new CheckerEvent(indexerConfig.getName(), "Determined API limit " + maxApi + " and download limit " + maxDownloads));
            logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Max API hits: {}. Max downloads: {}", new Object[]{indexerConfig.getName(), maxApi, maxDownloads});
        } else {
            logger.debug(LoggingMarkers.LIMITS, "Indexer {}. No limits provided in response.", (Object)indexerConfig.getName());
        }
        if (supported) {
            logger.info("Indexer {} probably supports the ID type {}. {}% of results were correct.", new Object[]{request.indexerConfig.getName(), request.getIdType(), Float.valueOf(percentCorrect)});
            this.eventPublisher.publishEvent((Object)new CheckerEvent(indexerConfig.getName(), "Probably supports " + String.valueOf(request.getIdType())));
            return new SingleCheckCapsResponse(request.getKey(), request.getIdType(), true, rssRoot.getRssChannel().getGenerator(), maxApi, maxDownloads);
        }
        logger.info("Indexer {} probably doesn't support the ID type {}. {}% of results were correct.", new Object[]{request.indexerConfig.getName(), request.getIdType(), Float.valueOf(percentCorrect)});
        this.eventPublisher.publishEvent((Object)new CheckerEvent(indexerConfig.getName(), "Probably doesn't support " + String.valueOf(request.getIdType())));
        return new SingleCheckCapsResponse(request.getKey(), request.getIdType(), false, rssRoot.getRssChannel().getGenerator(), maxApi, maxDownloads);
    }
}

