/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.Newznab;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlResponse;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.mapping.newznab.xml.Xml;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="wtfnzb")
@Scope(value="prototype")
public class WtfNzb
extends Newznab {
    private static final Logger logger = LoggerFactory.getLogger(WtfNzb.class);

    public IndexerSearchResult search(SearchRequest searchRequest, int offset, Integer limit) {
        if (searchRequest.getQuery().isEmpty() && searchRequest.getIdentifiers().isEmpty()) {
            return new IndexerSearchResult((Indexer)this, "Search without query and query generation not supported");
        }
        return super.search(searchRequest, offset, limit);
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.config.getHost()).path("/api_fast");
        String query = this.generateQueryIfApplicable(searchRequest, (String)searchRequest.getQuery().get());
        builder.queryParam("q", new Object[]{query}).queryParam("apikey", new Object[]{this.config.getApiKey()}).queryParam("r", new Object[]{this.config.getApiKey()}).queryParam("i", new Object[]{this.config.getUsername()});
        return builder;
    }

    protected void completeIndexerSearchResult(Xml response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        NewznabXmlResponse newznabResponse = ((NewznabXmlRoot)response).getRssChannel().getNewznabResponse();
        super.completeIndexerSearchResult(response, indexerSearchResult, acceptorResult, searchRequest, offset, limit);
        indexerSearchResult.setTotalResultsKnown(true);
        if (newznabResponse != null) {
            indexerSearchResult.setTotalResultsKnown(true);
            indexerSearchResult.setHasMoreResults(false);
            indexerSearchResult.setTotalResults(newznabResponse.getTotal().intValue());
            indexerSearchResult.setPageSize(newznabResponse.getTotal().intValue());
        } else {
            indexerSearchResult.setTotalResults(0);
            indexerSearchResult.setHasMoreResults(false);
            indexerSearchResult.setOffset(0);
            indexerSearchResult.setPageSize(0);
        }
    }

    protected boolean isSwitchToTSearchNeeded(SearchRequest request) {
        return true;
    }
}

