/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedSupplier;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerParsingException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.mapping.AgeToPubDateConverter;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="nzbking")
@Scope(value="prototype")
public class NzbKing
extends Indexer<String> {
    private static final Logger logger = LoggerFactory.getLogger(NzbKing.class);
    private static final Pattern TITLE_PATTERN = Pattern.compile("\"(.*)\\.(rar|nfo|mkv|mp3|mobi|avi|mp4|m3u|epub|txt|pdf|par2|001|nzb|url|jpg|zip|flac|m4a|m4b|sfv|7z|md5|r[0-9]{2})\"?", 2);
    private static final Pattern SIZE_PATTERN = Pattern.compile("(?<size>[0-9]+(\\.[0-9]+)?)(?<unit>(GB|MB|KB|B))", 2);
    private static final Pattern NFO_PATTERN = Pattern.compile("<pre>(?<nfo>.*)<\\/pre>", 34);
    private final RetryPolicy<Object> retry503policy = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(x -> x instanceof IndexerAccessException && Throwables.getStackTraceAsString((Throwable)x).contains("503"))).withDelay(Duration.ofMillis(500L)).withMaxRetries(2).build();

    protected void completeIndexerSearchResult(String response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        indexerSearchResult.setHasMoreResults(response.contains("next 50 posts"));
        indexerSearchResult.setTotalResultsKnown(false);
        indexerSearchResult.setPageSize(50);
        indexerSearchResult.setOffset(offset);
    }

    protected List<SearchResultItem> getSearchResultItems(String searchRequestResponse, SearchRequest searchRequest) throws IndexerParsingException {
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>();
        Document doc = Jsoup.parse((String)searchRequestResponse);
        if (doc.text().contains("Your search criteria did not match any documents")) {
            return Collections.emptyList();
        }
        Elements resultsTables = doc.select("div.search-results-group");
        if (resultsTables.isEmpty()) {
            throw new IndexerParsingException("Unable to find result table in NZBKing page. This happens sometimes ;-)");
        }
        Elements allRows = new Elements();
        boolean isFirstGroup = true;
        for (Element resultsTable : resultsTables) {
            int i;
            Elements rows = resultsTable.select("div.search-result");
            int n = i = isFirstGroup ? 1 : 0;
            while (i < rows.size()) {
                Element row = (Element)rows.get(i);
                allRows.add((Object)row);
                SearchResultItem item2 = this.parseRow(row);
                if (item2 != null) {
                    items.add(item2);
                }
                ++i;
            }
            isFirstGroup = false;
        }
        items.removeIf(item -> !searchRequest.getInternalData().getQueryWords().stream().allMatch(queryWord -> item.getTitle().toLowerCase().contains(queryWord.toLowerCase())));
        this.debug("Finished parsing {} of {} rows", new Object[]{items.size(), allRows.size()});
        return items;
    }

    private SearchResultItem parseRow(Element row) {
        Element nfoElement;
        String partsAndSize;
        Element posterElement;
        Matcher matcher;
        SearchResultItem item = new SearchResultItem();
        Element titleElement = this.getElementOrNone(row, "div.search-subject");
        if (titleElement == null) {
            this.debug("Table row does not have a title", new Object[0]);
            return null;
        }
        String title = titleElement.childNode(0).toString().trim();
        if (title.contains("password protect") || title.contains("passworded")) {
            item.setPassworded(true);
        }
        if (!(matcher = TITLE_PATTERN.matcher(title)).find()) {
            this.debug("Unable to find title in text {}", new Object[]{title});
            return null;
        }
        title = matcher.group(1);
        String filename = matcher.group(1) + "." + matcher.group(2);
        title = this.cleanUpTitle(title);
        item.setTitle(title);
        item.setAttributes(new HashMap<String, CallSite>(Map.of("filename", filename)));
        item.setIndexerGuid(this.getElementOrNone(row, "input[type=checkbox]").attr("value"));
        item.setLink("https://www.nzbking.com/nzb:" + item.getIndexerGuid());
        item.setDetails("https://www.nzbking.com/details:" + item.getIndexerGuid());
        Element groupElement = this.getElementOrNone(row, "div.search-groups");
        if (groupElement != null) {
            item.setGroup(groupElement.ownText());
        }
        if ((posterElement = this.getElementOrNone(row, "div.search-poster")) != null) {
            item.setPoster(posterElement.text());
        }
        if (!this.findSize(item, partsAndSize = ((Node)titleElement.childNodes().get(6)).outerHtml().trim())) {
            partsAndSize = ((Node)titleElement.childNodes().get(8)).outerHtml().trim();
            this.findSize(item, partsAndSize);
        }
        item.setHasNfo((nfoElement = this.getElementOrNone(titleElement, "a[href^=/nfo]")) != null ? SearchResultItem.HasNfo.YES : SearchResultItem.HasNfo.NO);
        Element ageElement = this.getElementOrNone(row, "div.search-age");
        if (ageElement != null) {
            String pubdateString = ageElement.text();
            Instant pubdate = AgeToPubDateConverter.convertToInstant((String)pubdateString);
            item.setPubDate(pubdate);
            item.setAgePrecise(false);
        } else {
            this.debug("Unable to find pubdate in row {}", new Object[]{row.text()});
        }
        item.setCategory(this.categoryProvider.getNotAvailable());
        item.setIndexer((Indexer)this);
        item.setDownloadType(DownloadType.NZB);
        item.setIndexerScore(Integer.valueOf(this.config.getScore()));
        return item;
    }

    private boolean findSize(SearchResultItem item, String partsAndSize) {
        Matcher sizeMatcher = SIZE_PATTERN.matcher(partsAndSize);
        if (sizeMatcher.find()) {
            String unit;
            Float size = Float.valueOf(Float.parseFloat(sizeMatcher.group("size")));
            switch (unit = sizeMatcher.group("unit")) {
                case "GB": {
                    size = Float.valueOf(size.floatValue() * 1024.0f * 1024.0f * 1024.0f);
                    break;
                }
                case "MB": {
                    size = Float.valueOf(size.floatValue() * 1024.0f * 1024.0f);
                    break;
                }
                case "KB": {
                    size = Float.valueOf(size.floatValue() * 1024.0f);
                }
            }
            item.setSize(Long.valueOf(size.longValue()));
            return true;
        }
        return false;
    }

    private Element getElementOrNone(Element parent, String selector) {
        Elements selectionResult = parent.select(selector);
        return selectionResult.isEmpty() ? null : (Element)selectionResult.get(0);
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        String query = super.generateQueryIfApplicable(searchRequest, "");
        if (Strings.isNullOrEmpty((String)(query = this.addRequiredWordsToQuery(searchRequest, query)))) {
            throw new IndexerSearchAbortedException("NZBKing cannot search without a query");
        }
        query = this.cleanupQuery(query);
        UriComponentsBuilder queryBuilder = UriComponentsBuilder.fromHttpUrl((String)"https://www.nzbking.com/search").queryParam("q", new Object[]{query});
        if (this.getConfig().isBinsearchOtherGroups()) {
            queryBuilder = queryBuilder.queryParam("server", new Object[]{"2"});
        }
        queryBuilder = queryBuilder.queryParam("o", new Object[]{offset});
        return queryBuilder;
    }

    private String addRequiredWordsToQuery(SearchRequest searchRequest, String query) {
        List requiredWords = searchRequest.getInternalData().getRequiredWords();
        requiredWords.addAll(this.configProvider.getBaseConfig().getSearching().getRequiredWords());
        requiredWords.addAll(searchRequest.getCategory().getRequiredWords());
        if (!requiredWords.isEmpty()) {
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + Joiner.on((String)" ").join((Iterable)requiredWords);
        }
        return query;
    }

    public NfoResult getNfo(String guid) {
        URI nfoUri = UriComponentsBuilder.fromHttpUrl((String)this.config.getHost()).pathSegment(new String[]{"viewNFO.php"}).queryParam("oid", new Object[]{guid}).build().toUri();
        try {
            String html = (String)this.getAndStoreResultToDatabase(nfoUri, String.class, IndexerApiAccessType.NFO);
            Matcher matcher = NFO_PATTERN.matcher(html);
            if (!matcher.find()) {
                return NfoResult.withoutNfo();
            }
            return NfoResult.withNfo((String)matcher.group("nfo"));
        }
        catch (IndexerAccessException e) {
            return NfoResult.unsuccessful((String)e.getMessage());
        }
    }

    protected String getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        return (String)Failsafe.with((Policy)this.retry503policy, (Policy[])new RetryPolicy[0]).onFailure(throwable -> logger.warn("Encountered 503 error. Will retry")).get((CheckedSupplier)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Logger getLogger() {
        return logger;
    }
}

