/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.indexer.IndexerCategoryConfig;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.CategoryProvider;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewznabCategoryComputer {
    private static final Logger log = LoggerFactory.getLogger(NewznabCategoryComputer.class);
    private final ConcurrentHashMap<Integer, Category> idToCategory = new ConcurrentHashMap();
    private final CategoryProvider categoryProvider;

    public NewznabCategoryComputer(CategoryProvider categoryProvider) {
        this.categoryProvider = categoryProvider;
    }

    public void computeCategory(SearchResultItem searchResultItem, List<Integer> newznabCategories, IndexerConfig config) {
        if (!newznabCategories.isEmpty()) {
            Category category;
            log.debug(LoggingMarkers.CATEGORY_MAPPING, config.getName() + ":Result {} has newznab categories {} and self-reported category {}", new Object[]{searchResultItem.getTitle(), newznabCategories, searchResultItem.getCategory()});
            Integer mostSpecific = (Integer)newznabCategories.stream().max(Integer::compareTo).get();
            IndexerCategoryConfig mapping = config.getCategoryMapping();
            if (mapping == null) {
                category = this.categoryProvider.fromSearchNewznabCategories(newznabCategories, this.categoryProvider.getNotAvailable());
                searchResultItem.setOriginalCategory(this.categoryProvider.getNotAvailable().getName());
                log.debug(LoggingMarkers.CATEGORY_MAPPING, config.getName() + ":No mapping available. Using original category N/A and new category {} for result {}", (Object)category, (Object)searchResultItem.getTitle());
            } else {
                category = this.idToCategory.computeIfAbsent(mostSpecific, x -> {
                    Optional categoryOptional = Optional.empty();
                    if (mapping.getAnime().isPresent() && Objects.equals(mapping.getAnime().get(), mostSpecific)) {
                        categoryOptional = this.categoryProvider.fromSubtype(Category.Subtype.ANIME);
                    } else if (mapping.getAudiobook().isPresent() && Objects.equals(mapping.getAudiobook().get(), mostSpecific)) {
                        categoryOptional = this.categoryProvider.fromSubtype(Category.Subtype.AUDIOBOOK);
                    } else if (mapping.getEbook().isPresent() && Objects.equals(mapping.getEbook().get(), mostSpecific)) {
                        categoryOptional = this.categoryProvider.fromSubtype(Category.Subtype.EBOOK);
                    } else if (mapping.getComic().isPresent() && Objects.equals(mapping.getComic().get(), mostSpecific)) {
                        categoryOptional = this.categoryProvider.fromSubtype(Category.Subtype.COMIC);
                    } else if (mapping.getMagazine().isPresent() && Objects.equals(mapping.getMagazine().get(), mostSpecific)) {
                        categoryOptional = this.categoryProvider.fromSubtype(Category.Subtype.MAGAZINE);
                    }
                    return categoryOptional.orElse(this.categoryProvider.fromResultNewznabCategories(newznabCategories));
                });
                searchResultItem.setOriginalCategory(mapping.getNameFromId(mostSpecific.intValue()));
            }
            if (category == null) {
                log.debug(LoggingMarkers.CATEGORY_MAPPING, config.getName() + ":No category found for {}. Using N/A", (Object)searchResultItem.getTitle());
                searchResultItem.setCategory(this.categoryProvider.getNotAvailable());
            } else {
                log.debug(LoggingMarkers.CATEGORY_MAPPING, config.getName() + ":Determined category {} for {}", (Object)category, (Object)searchResultItem.getTitle());
                searchResultItem.setCategory(category);
            }
        } else {
            log.debug(LoggingMarkers.CATEGORY_MAPPING, config.getName() + ":No newznab categories exist for {}. Using N/A ", (Object)searchResultItem.getTitle());
            searchResultItem.setCategory(this.categoryProvider.getNotAvailable());
        }
    }
}

