/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.nzbhydra.Jackson;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.indexers.IndexerWebAccess;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerProgramErrorException;
import org.nzbhydra.indexers.exceptions.IndexerUnreachableException;
import org.nzbhydra.indexers.torbox.mapping.TorboxSearchResponse;
import org.nzbhydra.logging.MdcThreadPoolExecutor;
import org.nzbhydra.mapping.nzbindex.NzbIndexRoot;
import org.nzbhydra.web.WebConfiguration;
import org.nzbhydra.webaccess.WebAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXParseException;

@Component
public class IndexerWebAccess {
    private static final Logger logger = LoggerFactory.getLogger(IndexerWebAccess.class);
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    protected WebAccess webAccess;
    protected Unmarshaller unmarshaller = new WebConfiguration().marshaller();

    public <T> T get(URI uri, IndexerConfig indexerConfig) throws IndexerAccessException {
        return (T)this.get(uri, indexerConfig, null);
    }

    public <T> T get(URI uri, IndexerConfig indexerConfig, Class responseType) throws IndexerAccessException {
        Future<Object> future;
        int timeout = indexerConfig.getTimeout().orElse(this.configProvider.getBaseConfig().getSearching().getTimeout());
        String userAgent = indexerConfig.getUserAgent().orElse(this.configProvider.getBaseConfig().getSearching().getUserAgent().orElse("NZBHydra2"));
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("User-Agent", userAgent);
        headers.put("Content-Type", "application/xml");
        headers.put("Accept", "application/xml");
        if (indexerConfig.getUsername().isPresent() && indexerConfig.getPassword().isPresent()) {
            headers.put("Authorization", "Basic " + BaseEncoding.base64().encode(((String)indexerConfig.getUsername().get() + ":" + (String)indexerConfig.getPassword().get()).getBytes()));
        }
        if (indexerConfig.getSearchModuleType() == SearchModuleType.TORBOX) {
            headers.put("Authorization", "Bearer " + indexerConfig.getApiKey());
        }
        MdcThreadPoolExecutor executorService = MdcThreadPoolExecutor.newWithInheritedMdc((int)1);
        try {
            future = executorService.submit(() -> {
                String response = this.webAccess.callUrl(uri.toString(), headers, timeout);
                if (responseType == String.class) {
                    return response;
                }
                if (responseType == NzbIndexRoot.class || responseType == TorboxSearchResponse.class) {
                    return Jackson.JSON_MAPPER.readValue(response, responseType);
                }
                return this.unmarshalXml(response);
            });
        }
        catch (RejectedExecutionException e) {
            logger.error("Unexpected execution exception while executing call for indexer {}. This will hopefully be fixed soon", (Object)indexerConfig.getName(), (Object)e);
            throw new IndexerProgramErrorException("Unexpected error in hydra code. Sorry...");
        }
        finally {
            executorService.shutdown();
        }
        try {
            return (T)future.get(timeout + 1, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new IndexerUnreachableException("Connection with indexer timed out with a time out of " + timeout + " seconds: " + e.getCause().getMessage());
            }
            if (e.getCause() instanceof HydraUnmarshallingFailureException) {
                throw new IndexerAccessException("Unable to parse indexer output: " + e.getCause().getMessage(), e.getCause());
            }
            logger.debug("Indexer communication error", e.getCause());
            throw new IndexerUnreachableException("Error while communicating with indexer " + indexerConfig.getName() + ". Server returned: " + e.getCause().getMessage(), e.getCause());
        }
        catch (TimeoutException e) {
            throw new IndexerUnreachableException("Indexer did not complete request within " + timeout + " seconds");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while accessing indexer", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private <T> T unmarshalXml(String response) throws IOException, HydraUnmarshallingFailureException {
        try (StringReader reader = new StringReader(response);){
            Object unmarshalled;
            StreamSource source = new StreamSource(reader);
            Object object = unmarshalled = this.unmarshaller.unmarshal((Source)source);
            return (T)object;
        }
        catch (UnmarshallingFailureException e) {
            if (response.toLowerCase().contains("function not available")) throw new HydraUnmarshallingFailureException(e.getMessage(), e, response);
            this.logParseException(response, e);
            throw new HydraUnmarshallingFailureException(e.getMessage(), e, response);
        }
    }

    protected void logParseException(String response, UnmarshallingFailureException e) {
        Optional<Throwable> saxParseExceptionOptional = Throwables.getCausalChain((Throwable)e).stream().filter(x -> x instanceof SAXParseException).findFirst();
        if (saxParseExceptionOptional.isPresent()) {
            int lineNumber = ((SAXParseException)saxParseExceptionOptional.get()).getLineNumber();
            int columnNumber = ((SAXParseException)saxParseExceptionOptional.get()).getColumnNumber();
            String message = saxParseExceptionOptional.get().getMessage();
            String[] lines = response.split("\\r?\\n");
            int from = Math.max(0, lineNumber - 5);
            int to = Math.min(lines.length, lineNumber + 5);
            String excerpt = String.join((CharSequence)"\r\n", Arrays.asList(lines).subList(from, to));
            logger.error("Unable to parse indexer output at line {} and column {} with error message: {}. Excerpt:\r\n{}", new Object[]{lineNumber, columnNumber, message, excerpt});
        } else {
            logger.debug("Unable to parse indexer output:\n {}", (Object)response, (Object)e);
        }
    }
}

