/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.searching.db.SearchEntity;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
@Entity
@Table(name="indexersearch", indexes={@Index(name="ISINDEX1", columnList="INDEXER_ENTITY_ID"), @Index(name="ISINDEX2", columnList="SEARCH_ENTITY_ID")})
public final class IndexerSearchEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(allocationSize=1, name="INDEXERSEARCH_SEQ")
    private int id;
    @ManyToOne
    @OnDelete(action=OnDeleteAction.CASCADE)
    private IndexerEntity indexerEntity;
    @ManyToOne
    @OnDelete(action=OnDeleteAction.CASCADE)
    private SearchEntity searchEntity;
    private Boolean successful;
    private Integer resultsCount;

    public IndexerSearchEntity() {
    }

    public IndexerSearchEntity(IndexerEntity indexerEntity, SearchEntity searchEntity, int id) {
        this.indexerEntity = indexerEntity;
        this.searchEntity = searchEntity;
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexerSearchEntity entity = (IndexerSearchEntity)o;
        return this.id == entity.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public int getId() {
        return this.id;
    }

    public IndexerEntity getIndexerEntity() {
        return this.indexerEntity;
    }

    public SearchEntity getSearchEntity() {
        return this.searchEntity;
    }

    public Boolean getSuccessful() {
        return this.successful;
    }

    public Integer getResultsCount() {
        return this.resultsCount;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setIndexerEntity(IndexerEntity indexerEntity) {
        this.indexerEntity = indexerEntity;
    }

    public void setSearchEntity(SearchEntity searchEntity) {
        this.searchEntity = searchEntity;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public void setResultsCount(Integer resultsCount) {
        this.resultsCount = resultsCount;
    }

    public String toString() {
        return "IndexerSearchEntity(id=" + this.getId() + ", indexerEntity=" + String.valueOf(this.getIndexerEntity()) + ", searchEntity=" + String.valueOf(this.getSearchEntity()) + ", successful=" + this.getSuccessful() + ", resultsCount=" + this.getResultsCount() + ")";
    }
}

