/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.indexers.Newznab;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlResponse;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.mapping.newznab.xml.Xml;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="dognzb")
@Scope(value="prototype")
public class DogNzb
extends Newznab {
    private static final Logger logger = LoggerFactory.getLogger(DogNzb.class);

    protected void completeIndexerSearchResult(Xml response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        NewznabXmlResponse newznabResponse = ((NewznabXmlRoot)response).getRssChannel().getNewznabResponse();
        super.completeIndexerSearchResult(response, indexerSearchResult, acceptorResult, searchRequest, offset, limit);
        indexerSearchResult.setTotalResultsKnown(false);
        if (newznabResponse != null) {
            if (newznabResponse.getTotal() == 100) {
                indexerSearchResult.setHasMoreResults(true);
                indexerSearchResult.setTotalResults(100);
            } else {
                indexerSearchResult.setTotalResultsKnown(true);
                indexerSearchResult.setHasMoreResults(false);
                indexerSearchResult.setTotalResults(searchRequest.getOffset() + newznabResponse.getTotal());
            }
            indexerSearchResult.setOffset(newznabResponse.getOffset().intValue());
            indexerSearchResult.setPageSize(100);
        } else {
            indexerSearchResult.setTotalResults(0);
            indexerSearchResult.setHasMoreResults(false);
            indexerSearchResult.setOffset(0);
            indexerSearchResult.setPageSize(0);
        }
    }

    protected boolean isSwitchToTSearchNeeded(SearchRequest request) {
        if ((request.getSearchType() == SearchType.MOVIE || request.getSearchType() == SearchType.TVSEARCH) && request.getQuery().isPresent()) {
            return true;
        }
        return super.isSwitchToTSearchNeeded(request);
    }
}

