/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.historystats;

import com.google.common.base.Stopwatch;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.historystats.StatsResponse;
import org.nzbhydra.historystats.stats.AverageResponseTime;
import org.nzbhydra.historystats.stats.CountPerDayOfWeek;
import org.nzbhydra.historystats.stats.CountPerHourOfDay;
import org.nzbhydra.historystats.stats.DownloadOrSearchSharePerUserOrIp;
import org.nzbhydra.historystats.stats.DownloadPerAge;
import org.nzbhydra.historystats.stats.DownloadPerAgeStats;
import org.nzbhydra.historystats.stats.IndexerApiAccessStatsEntry;
import org.nzbhydra.historystats.stats.IndexerDownloadShare;
import org.nzbhydra.historystats.stats.IndexerScore;
import org.nzbhydra.historystats.stats.StatsRequest;
import org.nzbhydra.historystats.stats.SuccessfulDownloadsPerIndexer;
import org.nzbhydra.historystats.stats.UserAgentShare;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerAccessResult;
import org.nzbhydra.indexers.IndexerApiAccessEntityShortRepository;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.IndexerRepository;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.SearchModuleProvider;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.searching.uniqueness.IndexerUniquenessScoreEntity;
import org.nzbhydra.searching.uniqueness.IndexerUniquenessScoreEntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Stats {
    private static final Logger logger = LoggerFactory.getLogger(Stats.class);
    private static final int TIMEOUT = 120;
    @Autowired
    private SearchModuleProvider searchModuleProvider;
    @Autowired
    private IndexerRepository indexerRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private IndexerApiAccessEntityShortRepository shortRepository;
    @Autowired
    private SearchResultRepository searchResultRepository;
    @Autowired
    private IndexerUniquenessScoreEntityRepository uniquenessScoreEntityRepository;

    @Transactional(readOnly=true)
    public StatsResponse getAllStats(StatsRequest statsRequest) throws InterruptedException {
        Long countDownloadsWithData;
        Long countSearchesWithData;
        logger.debug("Request for stats between {} and {}", (Object)statsRequest.getAfter(), (Object)statsRequest.getBefore());
        Stopwatch stopwatch = Stopwatch.createStarted();
        StatsResponse statsResponse = new StatsResponse();
        statsResponse.setAfter(statsRequest.getAfter());
        statsResponse.setBefore(statsRequest.getBefore());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        ArrayList futures = new ArrayList();
        if (statsRequest.isAvgResponseTimes()) {
            futures.add(executor.submit(() -> statsResponse.setAvgResponseTimes(this.averageResponseTimes(statsRequest))));
        }
        if (statsRequest.isIndexerApiAccessStats()) {
            futures.add(executor.submit(() -> statsResponse.setIndexerApiAccessStats(this.indexerApiAccesses(statsRequest))));
        }
        if (statsRequest.isAvgIndexerUniquenessScore()) {
            futures.add(executor.submit(() -> statsResponse.setIndexerScores(this.indexerScores(statsRequest))));
        }
        if (statsRequest.isSearchesPerDayOfWeek()) {
            futures.add(executor.submit(() -> statsResponse.setSearchesPerDayOfWeek(this.countPerDayOfWeek("SEARCH", statsRequest))));
        }
        if (statsRequest.isDownloadsPerDayOfWeek()) {
            futures.add(executor.submit(() -> statsResponse.setDownloadsPerDayOfWeek(this.countPerDayOfWeek("INDEXERNZBDOWNLOAD", statsRequest))));
        }
        if (statsRequest.isSearchesPerHourOfDay()) {
            futures.add(executor.submit(() -> statsResponse.setSearchesPerHourOfDay(this.countPerHourOfDay("SEARCH", statsRequest))));
        }
        if (statsRequest.isDownloadsPerHourOfDay()) {
            futures.add(executor.submit(() -> statsResponse.setDownloadsPerHourOfDay(this.countPerHourOfDay("INDEXERNZBDOWNLOAD", statsRequest))));
        }
        if (statsRequest.isIndexerDownloadShares()) {
            futures.add(executor.submit(() -> statsResponse.setIndexerDownloadShares(this.indexerDownloadShares(statsRequest))));
        }
        if (statsRequest.isDownloadsPerAgeStats()) {
            futures.add(executor.submit(() -> statsResponse.setDownloadsPerAgeStats(this.downloadsPerAgeStats())));
        }
        if (statsRequest.isSuccessfulDownloadsPerIndexer()) {
            futures.add(executor.submit(() -> statsResponse.setSuccessfulDownloadsPerIndexer(this.successfulDownloadsPerIndexer(statsRequest))));
        }
        if (statsRequest.isUserAgentSearchShares()) {
            futures.add(executor.submit(() -> statsResponse.setUserAgentSearchShares(this.userAgentSearchShares(statsRequest))));
        }
        if (statsRequest.isUserAgentDownloadShares()) {
            futures.add(executor.submit(() -> statsResponse.setUserAgentDownloadShares(this.userAgentDownloadShares(statsRequest))));
        }
        if (statsRequest.isSearchSharesPerUser() && (countSearchesWithData = (Long)this.entityManager.createNativeQuery("SELECT count(*) FROM SEARCH t WHERE t.USERNAME IS NOT NULL").getSingleResult()).intValue() > 0) {
            futures.add(executor.submit(() -> statsResponse.setSearchSharesPerUser(this.downloadsOrSearchesPerUserOrIp(statsRequest, "SEARCH", "USERNAME"))));
        }
        if (statsRequest.isDownloadSharesPerUser() && (countDownloadsWithData = (Long)this.entityManager.createNativeQuery("SELECT count(*) FROM INDEXERNZBDOWNLOAD t WHERE t.USERNAME IS NOT NULL").getSingleResult()) > 0L) {
            futures.add(executor.submit(() -> statsResponse.setDownloadSharesPerUser(this.downloadsOrSearchesPerUserOrIp(statsRequest, "INDEXERNZBDOWNLOAD", "USERNAME"))));
        }
        if (statsRequest.isSearchSharesPerIp() && (countSearchesWithData = (Long)this.entityManager.createNativeQuery("SELECT count(*) FROM SEARCH t WHERE t.IP IS NOT NULL").getSingleResult()) > 0L) {
            futures.add(executor.submit(() -> statsResponse.setSearchSharesPerIp(this.downloadsOrSearchesPerUserOrIp(statsRequest, "SEARCH", "IP"))));
        }
        if (statsRequest.isDownloadSharesPerIp() && (countDownloadsWithData = (Long)this.entityManager.createNativeQuery("SELECT count(*) FROM INDEXERNZBDOWNLOAD t WHERE t.IP IS NOT NULL").getSingleResult()) > 0L) {
            futures.add(executor.submit(() -> statsResponse.setDownloadSharesPerIp(this.downloadsOrSearchesPerUserOrIp(statsRequest, "INDEXERNZBDOWNLOAD", "IP"))));
        }
        executor.shutdown();
        boolean wasCompleted = executor.awaitTermination(120L, TimeUnit.SECONDS);
        if (!wasCompleted) {
            executor.shutdownNow();
            logger.error("Aborted stats generation because it took longer than {} seconds. Please restart", (Object)120);
        } else {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    logger.error("Error during calculation of stats", e.getCause());
                }
            }
        }
        statsResponse.setNumberOfConfiguredIndexers(this.searchModuleProvider.getIndexers().size());
        statsResponse.setNumberOfEnabledIndexers(this.searchModuleProvider.getEnabledIndexers().size());
        logger.info("Stats calculation took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return statsResponse;
    }

    List<IndexerDownloadShare> indexerDownloadShares(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating indexer download shares");
        if (this.searchModuleProvider.getEnabledIndexers().size() == 0 && !statsRequest.isIncludeDisabled()) {
            logger.warn("Unable to generate any stats without any enabled indexers");
            return Collections.emptyList();
        }
        ArrayList<IndexerDownloadShare> indexerDownloadShares = new ArrayList<IndexerDownloadShare>();
        String sqlQueryByIndexer = "SELECT\n  indexer.name,\n  count(*) AS total,\n  countall.countall\nFROM\n  indexernzbdownload dl LEFT JOIN SEARCHRESULT ON dl.SEARCH_RESULT_ID = SEARCHRESULT.ID\n  LEFT JOIN indexer ON SEARCHRESULT.INDEXER_ID = INDEXER.ID\n  ,\n  (SELECT count(*) AS countall\n   FROM\n     indexernzbdownload dl LEFT JOIN SEARCHRESULT ON dl.SEARCH_RESULT_ID = SEARCHRESULT.ID\n" + this.buildWhereFromStatsRequest(false, statsRequest) + ")\n  countall\n" + this.buildWhereFromStatsRequest(false, statsRequest) + "GROUP BY\n  INDEXER.NAME";
        Query query = this.entityManager.createNativeQuery(sqlQueryByIndexer);
        Set indexerNamesToInclude = this.searchModuleProvider.getIndexers().stream().filter(x -> x.getConfig().getState() == IndexerConfig.State.ENABLED || statsRequest.isIncludeDisabled()).map(Indexer::getName).collect(Collectors.toSet());
        List resultList = query.getResultList();
        for (Object result : resultList) {
            Object[] resultSet = (Object[])result;
            String indexerName = (String)resultSet[0];
            if (!indexerNamesToInclude.contains(indexerName)) continue;
            long total = (Long)resultSet[1];
            long countAll = (Long)resultSet[2];
            float share = total > 0L ? 100.0f / ((float)countAll / (float)total) : 0.0f;
            indexerDownloadShares.add(new IndexerDownloadShare(indexerName, total, share));
        }
        indexerDownloadShares.sort((a, b) -> Float.compare(b.getShare(), a.getShare()));
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated indexer download shares. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return indexerDownloadShares;
    }

    List<AverageResponseTime> averageResponseTimes(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating average response times for indexers");
        ArrayList<AverageResponseTime> averageResponseTimes = new ArrayList<AverageResponseTime>();
        String sql = "SELECT\n  NAME,\n  avg(RESPONSE_TIME) AS avg\nFROM INDEXERAPIACCESS\n  LEFT JOIN indexer i ON INDEXERAPIACCESS.INDEXER_ID = i.ID\n" + this.buildWhereFromStatsRequest(false, statsRequest) + "GROUP BY INDEXER_ID\nORDER BY avg ASC";
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        Set indexerNamesToInclude = this.searchModuleProvider.getIndexers().stream().filter(x -> x.getConfig().getState() == IndexerConfig.State.ENABLED || statsRequest.isIncludeDisabled()).map(Indexer::getName).collect(Collectors.toSet());
        OptionalDouble overallAverage = resultList.stream().filter(x -> ((Object[])x)[1] != null).mapToLong(x -> ((BigDecimal)((Object[])x)[1]).longValue()).average();
        for (Object result : resultList) {
            Object[] resultSet = (Object[])result;
            String indexerName = (String)resultSet[0];
            if (resultSet[0] == null || resultSet[1] == null || !indexerNamesToInclude.contains(indexerName)) continue;
            long averageResponseTime = ((BigDecimal)resultSet[1]).longValue();
            averageResponseTimes.add(new AverageResponseTime(indexerName, (double)averageResponseTime, (double)averageResponseTime - overallAverage.orElse(0.0)));
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated average response times for indexers. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return averageResponseTimes;
    }

    @Transactional(readOnly=true)
    public List<IndexerScore> indexerScores(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating indexer result uniqueness scores");
        List<SearchModuleType> typesToUse = Arrays.asList(SearchModuleType.NEWZNAB, SearchModuleType.TORZNAB, SearchModuleType.ANIZB);
        Set indexersToInclude = (statsRequest.isIncludeDisabled() ? this.searchModuleProvider.getIndexers() : this.searchModuleProvider.getEnabledIndexers().stream().filter(x -> typesToUse.contains(x.getConfig().getSearchModuleType())).toList()).stream().map(Indexer::getName).collect(Collectors.toSet());
        List indexerUniquenessScores = this.calculateIndexerScores(indexersToInclude, this.uniquenessScoreEntityRepository.findAll());
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated indexer result uniqueness scores. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return indexerUniquenessScores;
    }

    List<IndexerScore> calculateIndexerScores(Set<String> indexersToInclude, List<IndexerUniquenessScoreEntity> scoreEntities) {
        ArrayList<IndexerScore> scores = new ArrayList<IndexerScore>();
        Map<IndexerEntity, List<IndexerUniquenessScoreEntity>> entities = scoreEntities.stream().filter(x -> indexersToInclude.contains(x.getIndexer().getName())).filter(IndexerUniquenessScoreEntity::isHasResult).collect(Collectors.groupingBy(IndexerUniquenessScoreEntity::getIndexer));
        for (Map.Entry<IndexerEntity, List<IndexerUniquenessScoreEntity>> indexerEntityListEntry : entities.entrySet()) {
            Integer averageScore;
            if (!indexerEntityListEntry.getValue().isEmpty()) {
                OptionalDouble average = indexerEntityListEntry.getValue().stream().mapToDouble(x -> 100.0 * (double)x.getInvolved() / (double)x.getHave()).average();
                averageScore = (int)average.getAsDouble();
            } else {
                averageScore = null;
            }
            IndexerScore indexerScore = new IndexerScore();
            indexerScore.setIndexerName(indexerEntityListEntry.getKey().getName());
            indexerScore.setAverageUniquenessScore(averageScore);
            indexerScore.setInvolvedSearches((long)indexerEntityListEntry.getValue().size());
            long uniqueDownloads = indexerEntityListEntry.getValue().stream().filter(x -> x.getHave() == 1 && x.getInvolved() > 1).count();
            indexerScore.setUniqueDownloads(uniqueDownloads);
            scores.add(indexerScore);
        }
        scores.sort(Comparator.comparing(IndexerScore::getAverageUniquenessScore).reversed());
        return scores;
    }

    List<IndexerApiAccessStatsEntry> indexerApiAccesses(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating indexer API stats");
        Set indexerIdsToInclude = this.searchModuleProvider.getIndexers().stream().filter(x -> x.getConfig().getState() == IndexerConfig.State.ENABLED || statsRequest.isIncludeDisabled()).map(x -> x.getIndexerEntity().getId()).filter(id -> this.indexerRepository.findById(id) != null).collect(Collectors.toSet());
        String averageIndexerAccessesPerDay = "SELECT\n  indexer_id,\n  avg(count)\nFROM (\n  (SELECT\n     INDEXER_ID,\n     cast(count(INDEXER_ID) AS FLOAT) AS count   FROM INDEXERAPIACCESS\n" + this.buildWhereFromStatsRequest(false, statsRequest) + "   GROUP BY INDEXER_ID,\n     truncate(time)))\nGROUP BY INDEXER_ID";
        HashMap<Integer, Double> accessesPerDayCountMap = new HashMap<Integer, Double>();
        Query query = this.entityManager.createNativeQuery(averageIndexerAccessesPerDay);
        List results = query.getResultList();
        for (Object resultObject : results) {
            Object[] array = (Object[])resultObject;
            Integer indexerId = (Integer)array[0];
            if (!indexerIdsToInclude.contains(indexerId)) continue;
            Double avg = ((BigDecimal)array[1]).doubleValue();
            accessesPerDayCountMap.put(indexerId, avg);
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculating accesses per day took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset();
        stopwatch.start();
        String countByResultSql = "SELECT\n     INDEXER_ID,\n     RESULT,\n     count(result) AS count\n   FROM INDEXERAPIACCESS\n" + this.buildWhereFromStatsRequest(false, statsRequest) + "   GROUP BY INDEXER_ID, RESULT\n   ORDER BY INDEXER_ID, RESULT";
        HashMap<Integer, Integer> successCountMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> connectionErrorCountMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> allAccessesCountMap = new HashMap<Integer, Integer>();
        query = this.entityManager.createNativeQuery(countByResultSql);
        results = query.getResultList();
        for (Object resultObject : results) {
            Object[] array = (Object[])resultObject;
            Integer indexerId = (Integer)array[0];
            if (!indexerIdsToInclude.contains(indexerId)) continue;
            String result = (String)array[1];
            int count = ((Long)array[2]).intValue();
            if (result.equals(IndexerAccessResult.SUCCESSFUL.name())) {
                successCountMap.put(indexerId, count);
            } else if (result.equals(IndexerAccessResult.CONNECTION_ERROR.name())) {
                connectionErrorCountMap.put(indexerId, count);
            }
            if (allAccessesCountMap.containsKey(indexerId)) {
                allAccessesCountMap.put(indexerId, (Integer)allAccessesCountMap.get(indexerId) + count);
                continue;
            }
            allAccessesCountMap.put(indexerId, count);
        }
        ArrayList<IndexerApiAccessStatsEntry> indexerApiAccessStatsEntries = new ArrayList<IndexerApiAccessStatsEntry>();
        for (Integer id2 : indexerIdsToInclude) {
            IndexerApiAccessStatsEntry entry = new IndexerApiAccessStatsEntry();
            IndexerEntity indexerEntity = (IndexerEntity)this.indexerRepository.findById((Object)id2).get();
            entry.setIndexerName(indexerEntity.getName());
            if (allAccessesCountMap.containsKey(id2) && allAccessesCountMap.get(id2) != null) {
                if (successCountMap.get(id2) != null) {
                    Double percentSuccessFul = 100.0 / (((Integer)allAccessesCountMap.get(id2)).doubleValue() / ((Integer)successCountMap.get(id2)).doubleValue());
                    entry.setPercentSuccessful(percentSuccessFul);
                }
                if (connectionErrorCountMap.get(id2) != null) {
                    Double percentConnectionError = 100.0 / (((Integer)allAccessesCountMap.get(id2)).doubleValue() / ((Integer)connectionErrorCountMap.get(id2)).doubleValue());
                    entry.setPercentConnectionError(percentConnectionError);
                }
            }
            if (accessesPerDayCountMap.containsKey(id2) && accessesPerDayCountMap.get(id2) != null) {
                entry.setAverageAccessesPerDay((Double)accessesPerDayCountMap.get(id2));
            }
            indexerApiAccessStatsEntries.add(entry);
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculating success/failure stats took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return indexerApiAccessStatsEntries;
    }

    List<CountPerDayOfWeek> countPerDayOfWeek(String table, StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating count for day of week for table {}", (Object)table);
        String sql = "SELECT \n  DAYOFWEEK(time) AS dayofweek, \n  count(*)        AS counter \nFROM " + table + " \n" + this.buildWhereFromStatsRequest(false, statsRequest) + "GROUP BY DAYOFWEEK(time)";
        ArrayList<CountPerDayOfWeek> dayOfWeekCounts = new ArrayList<CountPerDayOfWeek>();
        for (int i = 0; i < 7; ++i) {
            dayOfWeekCounts.add(new CountPerDayOfWeek(i + 1, Integer.valueOf(0)));
        }
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        for (Object o : resultList) {
            Object[] resultSet = (Object[])o;
            Integer index = (Integer)resultSet[0];
            Long counter = (Long)resultSet[1];
            int indexInList = (index + 5) % 7;
            ((CountPerDayOfWeek)dayOfWeekCounts.get(indexInList)).setCount(Integer.valueOf(counter.intValue()));
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated count for day of week for table {}. Took {}ms", (Object)table, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return dayOfWeekCounts;
    }

    List<CountPerHourOfDay> countPerHourOfDay(String table, StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating count for hour of day for table {}", (Object)table);
        String sql = "SELECT \n  HOUR(time) AS hourofday, \n  count(*)        AS counter \nFROM " + table + " \n" + this.buildWhereFromStatsRequest(false, statsRequest) + "GROUP BY HOUR(time)";
        ArrayList<CountPerHourOfDay> hourOfDayCounts = new ArrayList<CountPerHourOfDay>();
        for (int i = 0; i < 24; ++i) {
            hourOfDayCounts.add(new CountPerHourOfDay(Integer.valueOf(i), Integer.valueOf(0)));
        }
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        for (Object o : resultList) {
            Object[] o2 = (Object[])o;
            Integer index = (Integer)o2[0];
            Long counter = (Long)o2[1];
            ((CountPerHourOfDay)hourOfDayCounts.get(index)).setCount(Integer.valueOf(counter.intValue()));
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated count for hour of day for table {}. Took {}ms", (Object)table, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return hourOfDayCounts;
    }

    List<SuccessfulDownloadsPerIndexer> successfulDownloadsPerIndexer(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String sql = "SELECT\n  name1,\n  count_all,\n  count_success,\n  count_error\nFROM\n  (SELECT\n     indexer.NAME AS name1,\n     count(*)   AS count_success\n   FROM INDEXERNZBDOWNLOAD\n     LEFT JOIN SEARCHRESULT ON INDEXERNZBDOWNLOAD.SEARCH_RESULT_ID = SEARCHRESULT.ID\n     LEFT JOIN indexer ON SEARCHRESULT.INDEXER_ID = INDEXER.ID\n   WHERE\n     status = 'CONTENT_DOWNLOAD_SUCCESSFUL'\n" + this.buildWhereFromStatsRequest(true, statsRequest) + "   GROUP BY name1)\n  LEFT JOIN\n  (SELECT\n     indexer.NAME AS name2,\n     count(*)   AS count_error\n   FROM INDEXERNZBDOWNLOAD\n     LEFT JOIN SEARCHRESULT ON INDEXERNZBDOWNLOAD.SEARCH_RESULT_ID = SEARCHRESULT.ID\n     LEFT JOIN indexer ON SEARCHRESULT.INDEXER_ID = INDEXER.ID\n   WHERE\n     status IN ('CONTENT_DOWNLOAD_ERROR', 'CONTENT_DOWNLOAD_WARNING')\n" + this.buildWhereFromStatsRequest(true, statsRequest) + "   GROUP BY name2) ON name1 = name2\n  LEFT JOIN\n  (SELECT\n     indexer.NAME AS name3,\n     count(*)   AS count_all\n   FROM INDEXERNZBDOWNLOAD\n     LEFT JOIN SEARCHRESULT ON INDEXERNZBDOWNLOAD.SEARCH_RESULT_ID = SEARCHRESULT.ID\n     LEFT JOIN indexer ON SEARCHRESULT.INDEXER_ID = INDEXER.ID\n" + this.buildWhereFromStatsRequest(false, statsRequest) + "   GROUP BY name3) ON name1 = name3;";
        Query query = this.entityManager.createNativeQuery(sql);
        Set indexerNamesToInclude = this.searchModuleProvider.getIndexers().stream().filter(x -> x.getConfig().getState() == IndexerConfig.State.ENABLED || statsRequest.isIncludeDisabled()).map(Indexer::getName).collect(Collectors.toSet());
        List resultList = query.getResultList();
        ArrayList<SuccessfulDownloadsPerIndexer> result = new ArrayList<SuccessfulDownloadsPerIndexer>();
        for (Object o : resultList) {
            Object[] o2 = (Object[])o;
            String indexerName = (String)o2[0];
            if (!indexerNamesToInclude.contains(indexerName)) continue;
            Long countAll = (Long)o2[1];
            Long countSuccess = (Long)o2[2];
            Long countError = (Long)o2[3];
            if (countAll == null) {
                countAll = 0L;
            }
            if (countSuccess == null) {
                countSuccess = 0L;
            }
            if (countError == null) {
                countError = 0L;
            }
            Float percentSuccessful = countSuccess.intValue() > 0 ? Float.valueOf(100.0f / ((countSuccess.floatValue() + countError.floatValue()) / countSuccess.floatValue())) : (countAll.intValue() > 0 ? Float.valueOf(0.0f) : null);
            result.add(new SuccessfulDownloadsPerIndexer(indexerName, countAll.intValue(), countSuccess.intValue(), countError.intValue(), percentSuccessful));
        }
        result.sort(Comparator.comparingDouble(SuccessfulDownloadsPerIndexer::getPercentSuccessful).reversed());
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated successful download percentages for indexers. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    List<DownloadOrSearchSharePerUserOrIp> downloadsOrSearchesPerUserOrIp(StatsRequest statsRequest, String tablename, String column) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating download or search shares for table {} and column {}", (Object)tablename, (Object)column);
        String sql = "SELECT\n  " + column + ",\n  count(*) AS peruser,\n  (SELECT count(*)\n   FROM " + tablename + "\n   WHERE " + column + " IS NOT NULL AND " + column + " != ''" + this.buildWhereFromStatsRequest(true, statsRequest) + ") AS countall\nFROM " + tablename + "\n WHERE " + column + " IS NOT NULL AND " + column + " != ''\n" + this.buildWhereFromStatsRequest(true, statsRequest) + "GROUP BY " + column;
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        ArrayList<DownloadOrSearchSharePerUserOrIp> result = new ArrayList<DownloadOrSearchSharePerUserOrIp>();
        for (Object o : resultList) {
            Object[] o2 = (Object[])o;
            String usernameOrIp = (String)o2[0];
            int countForUser = ((Long)o2[1]).intValue();
            float percentSuccessful = 100.0f / (((Long)o2[2]).floatValue() / ((Long)o2[1]).floatValue());
            result.add(new DownloadOrSearchSharePerUserOrIp(usernameOrIp, countForUser, percentSuccessful));
        }
        result.sort(Comparator.comparingDouble(DownloadOrSearchSharePerUserOrIp::getPercentage).reversed());
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated download or search shares for table {} and column {}. Took {}ms", new Object[]{tablename, column, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return result;
    }

    List<UserAgentShare> userAgentSearchShares(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating user agent search shares");
        String sql = "SELECT\n  user_agent,\n  count(*)\nFROM SEARCH\nWHERE user_agent IS NOT NULL\nAND SOURCE = 'API'" + this.buildWhereFromStatsRequest(true, statsRequest) + "GROUP BY user_agent";
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        ArrayList<UserAgentShare> result = new ArrayList<UserAgentShare>();
        int countAll = 0;
        for (Object o : resultList) {
            Object[] o2 = (Object[])o;
            String userAgent = (String)o2[0];
            int countForUserAgent = ((Long)o2[1]).intValue();
            countAll += countForUserAgent;
            result.add(new UserAgentShare(userAgent, countForUserAgent));
        }
        for (UserAgentShare userAgentShare : result) {
            userAgentShare.setPercentage(100.0f / ((float)countAll / (float)userAgentShare.getCount()));
        }
        result.sort(Comparator.comparingDouble(UserAgentShare::getPercentage).reversed());
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated user agent search shares. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    List<UserAgentShare> userAgentDownloadShares(StatsRequest statsRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating user agent download shares");
        String sql = "SELECT\n  user_agent,\n  count(*)\nFROM INDEXERNZBDOWNLOAD\nWHERE user_agent IS NOT NULL\nand ACCESS_SOURCE = 'API' \n" + this.buildWhereFromStatsRequest(true, statsRequest) + "GROUP BY user_agent";
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        ArrayList<UserAgentShare> result = new ArrayList<UserAgentShare>();
        int countAll = 0;
        for (Object o : resultList) {
            Object[] o2 = (Object[])o;
            String userAgent = (String)o2[0];
            int countForUserAgent = ((Long)o2[1]).intValue();
            countAll += countForUserAgent;
            result.add(new UserAgentShare(userAgent, countForUserAgent));
        }
        for (UserAgentShare userAgentShare : result) {
            userAgentShare.setPercentage(100.0f / ((float)countAll / (float)userAgentShare.getCount()));
        }
        result.sort(Comparator.comparingDouble(UserAgentShare::getPercentage).reversed());
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated user agent download shares. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    List<DownloadPerAge> downloadsPerAge() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating downloads per age");
        String sql = "SELECT\n  steps,\n  count(*)\nFROM\n  (SELECT age / 100 AS steps\n   FROM INDEXERNZBDOWNLOAD\n   WHERE age IS NOT NULL)\nGROUP BY steps\nORDER BY steps ASC";
        Query query = this.entityManager.createNativeQuery(sql);
        List resultList = query.getResultList();
        ArrayList<DownloadPerAge> results = new ArrayList<DownloadPerAge>();
        HashMap<Integer, Integer> agesAndCountsMap = new HashMap<Integer, Integer>();
        for (Object o : resultList) {
            Object[] o2 = (Object[])o;
            int ageStep = (Integer)o2[0];
            int count = ((Long)o2[1]).intValue();
            agesAndCountsMap.put(ageStep, count);
        }
        for (int i = 0; i <= 34; ++i) {
            if (agesAndCountsMap.containsKey(i)) continue;
            agesAndCountsMap.put(i, 0);
        }
        for (Map.Entry entry : agesAndCountsMap.entrySet()) {
            results.add(new DownloadPerAge(Integer.valueOf((Integer)entry.getKey() * 100), (Integer)entry.getValue()));
        }
        results.sort(Comparator.comparingInt(DownloadPerAge::getAge));
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated downloads per age. Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return results;
    }

    DownloadPerAgeStats downloadsPerAgeStats() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Calculating downloads per age percentages");
        DownloadPerAgeStats result = new DownloadPerAgeStats();
        String percentage = "SELECT CASE\n       WHEN (SELECT CAST(COUNT(*) AS FLOAT) AS COUNT\n             FROM INDEXERNZBDOWNLOAD\n             WHERE AGE > %d) > 0\n         THEN SELECT CAST(100 AS FLOAT) / (CAST(COUNT(i.*) AS FLOAT)/ x.COUNT)\nFROM INDEXERNZBDOWNLOAD i,\n( SELECT COUNT(*) AS COUNT\nFROM INDEXERNZBDOWNLOAD\nWHERE AGE > %d) AS x\nELSE 0 END";
        result.setPercentOlder1000(Integer.valueOf(((BigDecimal)this.entityManager.createNativeQuery(String.format(percentage, 1000, 1000)).getResultList().get(0)).intValue()));
        result.setPercentOlder2000(Integer.valueOf(((BigDecimal)this.entityManager.createNativeQuery(String.format(percentage, 2000, 2000)).getResultList().get(0)).intValue()));
        result.setPercentOlder3000(Integer.valueOf(((BigDecimal)this.entityManager.createNativeQuery(String.format(percentage, 3000, 3000)).getResultList().get(0)).intValue()));
        Double averageAge = (Double)this.entityManager.createNativeQuery("SELECT AVG(AGE) FROM INDEXERNZBDOWNLOAD").getResultList().get(0);
        result.setAverageAge(Integer.valueOf(averageAge == null ? 0 : averageAge.intValue()));
        logger.debug(LoggingMarkers.PERFORMANCE, "Calculated downloads per age percentages . Took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        result.setDownloadsPerAge(this.downloadsPerAge());
        return result;
    }

    private String buildWhereFromStatsRequest(boolean useAnd, StatsRequest statsRequest) {
        if (statsRequest.getAfter() == null && statsRequest.getBefore() == null) {
            return " ";
        }
        return (useAnd ? " AND " : " WHERE ") + (String)(statsRequest.getAfter() != null ? " TIME > DATEADD('SECOND', " + statsRequest.getAfter().getEpochSecond() + ", DATE '1970-01-01') " : "") + (statsRequest.getBefore() != null && statsRequest.getAfter() != null ? " AND " : " ") + (String)(statsRequest.getBefore() != null ? " TIME < DATEADD('SECOND', " + statsRequest.getBefore().getEpochSecond() + ", DATE '1970-01-01') " : "");
    }
}

