/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.historystats;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Hibernate;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.historystats.FilterDefinition;
import org.nzbhydra.historystats.History;
import org.nzbhydra.historystats.SortModel;
import org.nzbhydra.historystats.stats.HistoryRequest;
import org.nzbhydra.indexers.IndexerSearchEntity;
import org.nzbhydra.indexers.IndexerSearchRepository;
import org.nzbhydra.searching.db.SearchEntity;
import org.nzbhydra.searching.db.SearchRepository;
import org.nzbhydra.web.SessionStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class History {
    public static final String DOWNLOAD_TABLE = "INDEXERNZBDOWNLOAD x left join SEARCHRESULT s on x.SEARCH_RESULT_ID = s.ID LEFT JOIN INDEXER i ON s.INDEXER_ID = i.ID";
    public static final String SEARCH_TABLE = "SEARCH x";
    public static final String NOTIFICATION_TABLE = "NOTIFICATION x";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SearchRepository searchRepository;
    @Autowired
    private IndexerSearchRepository indexerSearchRepository;
    @Autowired
    private ConfigProvider configProvider;

    @Transactional
    public <T> Page<T> getHistory(HistoryRequest requestData, String tableName, Class<T> resultClass) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<String> wheres = new ArrayList<String>();
        Object sort = "";
        for (Map.Entry columnAndFilterDefinition : requestData.getFilterModel().entrySet()) {
            Object filterValue = ((FilterDefinition)columnAndFilterDefinition.getValue()).getFilterValue();
            Object filterType = ((FilterDefinition)columnAndFilterDefinition.getValue()).getFilterType();
            String columnName = (String)columnAndFilterDefinition.getKey();
            if (filterType.equals("freetext")) {
                wheres.add(String.format("LOWER(%s) LIKE :%s", columnName, columnName));
                parameters.put(columnName, "%" + filterValue.toString().toLowerCase() + "%");
                continue;
            }
            if (filterType.equals("text")) {
                wheres.add(String.format("LOWER(%s) = :%s", columnName, columnName));
                parameters.put(columnName, filterValue.toString().toLowerCase());
                continue;
            }
            if (filterType.equals("checkboxes")) {
                wheres.add(String.format("%s IN :%s", columnName, columnName));
                parameters.put(columnName, filterValue);
                continue;
            }
            if (filterType.equals("boolean") && !"all".equals(filterValue)) {
                wheres.add(String.format("%s = :%s", columnName, columnName));
                parameters.put(columnName, filterValue);
                continue;
            }
            if (filterType.equals("numberRange")) {
                Map map = (Map)filterValue;
                if (map.containsKey("min")) {
                    wheres.add(String.format("%s > %s", columnName, map.get("min")));
                }
                if (!map.containsKey("max")) continue;
                wheres.add(String.format("%s < %s", columnName, map.get("max")));
                continue;
            }
            if (!filterType.equals("time")) continue;
            Map beforeAndAfter = (Map)((FilterDefinition)columnAndFilterDefinition.getValue()).getFilterValue();
            if (beforeAndAfter.get("before") != null) {
                wheres.add(String.format("%s <= PARSEDATETIME('%s', 'yyyy-MM-ddHH:mm:ss.SSS')", columnName, ((String)beforeAndAfter.get("before")).replace("T", "").replace("Z", "")));
            }
            if (beforeAndAfter.get("after") == null) continue;
            wheres.add(String.format("%s >= PARSEDATETIME('%s', 'yyyy-MM-ddHH:mm:ss.SSS')", columnName, ((String)beforeAndAfter.get("after")).replace("T", "").replace("Z", "")));
        }
        SortModel sortModel = requestData.getSortModel();
        boolean useNullsLast = true;
        boolean useLower = true;
        if (sortModel != null) {
            Object column = sortModel.getColumn();
            if ("time".equalsIgnoreCase((String)column) || "age".equalsIgnoreCase((String)column)) {
                useNullsLast = false;
                useLower = false;
            }
            if (useLower) {
                column = "lower(" + (String)column + ")";
            }
            sort = String.format(" order by %s %s %s ", column, sortModel.getSortMode() == 1 ? "ASC" : "DESC", useNullsLast ? "nulls last" : "");
        }
        if (!"time".equalsIgnoreCase(sortModel.getColumn())) {
            sort = (String)sort + ", time desc";
        }
        Object whereConditions = "";
        if (!wheres.isEmpty()) {
            whereConditions = " WHERE " + String.join((CharSequence)" AND ", wheres);
        }
        String paging = String.format(" LIMIT %d OFFSET %d", requestData.getLimit(), (requestData.getPage() - 1) * requestData.getLimit());
        String selectQuerySql = "SELECT x.* FROM " + tableName + (String)whereConditions + (String)sort + paging;
        String countQuerySql = "SELECT COUNT(x.*) FROM " + tableName + (String)whereConditions;
        Query selectQuery = this.entityManager.createNativeQuery(selectQuerySql, resultClass);
        Query countQuery = this.entityManager.createNativeQuery(countQuerySql);
        for (Map.Entry entry : parameters.entrySet()) {
            selectQuery.setParameter((String)entry.getKey(), entry.getValue());
            countQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        List resultList = selectQuery.getResultList();
        PageRequest pageable = sortModel == null ? PageRequest.of((int)(requestData.getPage() - 1), (int)requestData.getLimit()) : PageRequest.of((int)(requestData.getPage() - 1), (int)requestData.getLimit(), (Sort.Direction)(sortModel.getSortMode() == 1 ? Sort.Direction.ASC : Sort.Direction.DESC), (String[])new String[]{sortModel.getColumn()});
        Long count = (Long)countQuery.getSingleResult();
        if (resultClass == SearchEntity.class) {
            resultList.forEach(x -> Hibernate.initialize((Object)((SearchEntity)x).getIdentifiers()));
        } else if (resultClass == FileDownloadEntity.class) {
            Hibernate.initialize((Object)resultList);
            resultList.forEach(x -> Hibernate.initialize((Object)((FileDownloadEntity)x).getSearchResult()));
        }
        return new PageImpl(resultList, (Pageable)pageable, count.longValue());
    }

    public List<SearchEntity> getHistoryForSearching() {
        String currentUserName = (String)SessionStorage.username.get();
        Page history = currentUserName == null ? this.searchRepository.findForUserSearchHistory((Pageable)PageRequest.of((int)0, (int)100)) : this.searchRepository.findForUserSearchHistory(currentUserName, (Pageable)PageRequest.of((int)0, (int)100));
        ArrayList<SearchEntity> entities = new ArrayList<SearchEntity>();
        HashSet<Integer> contained = new HashSet<Integer>();
        for (SearchEntity searchEntity : history.getContent()) {
            int hash = searchEntity.getComparingHash();
            if (contained.contains(hash)) continue;
            contained.add(hash);
            entities.add(searchEntity);
            if (entities.size() != this.configProvider.getBaseConfig().getSearching().getHistoryForSearching()) continue;
            break;
        }
        return entities;
    }

    public SearchDetails getSearchDetails(int searchId) {
        Optional searchOptional = this.searchRepository.findById((Object)searchId);
        SearchEntity search = (SearchEntity)searchOptional.get();
        Collection entities = this.indexerSearchRepository.findBySearchEntity(search);
        ArrayList<IndexerSearchTO> details = new ArrayList<IndexerSearchTO>();
        for (IndexerSearchEntity entity : entities) {
            details.add(new IndexerSearchTO(entity.getIndexerEntity().getName(), entity.getSuccessful().booleanValue(), entity.getResultsCount().intValue()));
        }
        return new SearchDetails(search.getUsername(), search.getIp(), search.getUserAgent(), search.getSource().name(), details);
    }
}

