/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.genericstorage;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.nzbhydra.Jackson;
import org.nzbhydra.config.BaseConfigHandler;
import org.nzbhydra.config.ConfigProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenericStorage {
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private BaseConfigHandler baseConfigHandler;

    public <T extends Serializable> void save(String key, T value) {
        Map genericStorage = this.configProvider.getBaseConfig().getGenericStorage();
        try {
            genericStorage.put(key, Jackson.JSON_MAPPER.writeValueAsString(value));
            this.baseConfigHandler.save(true);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing data as JSON", e);
        }
    }

    public <T extends Serializable> void setNoSave(String key, T value) {
        try {
            this.configProvider.getBaseConfig().getGenericStorage().put(key, Jackson.JSON_MAPPER.writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing data as JSON", e);
        }
    }

    public <T extends Serializable> void remove(String key) {
        this.configProvider.getBaseConfig().getGenericStorage().remove(key);
        this.baseConfigHandler.save(true);
    }

    public <T> Optional<T> get(String key, Class<T> clazz) {
        if (this.configProvider.getBaseConfig().getGenericStorage().containsKey(key)) {
            String json = (String)this.configProvider.getBaseConfig().getGenericStorage().get(key);
            try {
                return Optional.of(Jackson.JSON_MAPPER.readValue(json, clazz));
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading data from " + json, e);
            }
        }
        return Optional.empty();
    }
}

