/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.externaltools;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.ExternalToolConfig;
import org.nzbhydra.config.ExternalToolsConfig;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.externaltools.AddRequest;
import org.nzbhydra.externaltools.ExternalTools;
import org.nzbhydra.externaltools.ExternalToolsSyncService;
import org.nzbhydra.notifications.ExternalToolConfigResultEvent;
import org.nzbhydra.notifications.NotificationEvent;
import org.nzbhydra.notifications.NotificationHandler;
import org.nzbhydra.notifications.NotificationRepository;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalToolsSyncService {
    private static final Logger logger = LoggerFactory.getLogger(ExternalToolsSyncService.class);
    @Autowired
    private ExternalTools externalTools;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private NotificationHandler notificationHandler;

    public SyncResult syncAllTools() {
        return this.syncTools(null);
    }

    public SyncResult syncTools(Set<String> changedIndexers) {
        ExternalToolsConfig config = this.configProvider.getBaseConfig().getExternalTools();
        if (!config.isSyncOnConfigChange()) {
            logger.debug("External tools sync is disabled");
            return new SyncResult(0, 0, new ArrayList());
        }
        List<ExternalToolConfig> enabledTools = config.getExternalTools().stream().filter(ExternalToolConfig::isEnabled).toList();
        if (enabledTools.isEmpty()) {
            logger.debug("No enabled external tools configured");
            return new SyncResult(0, 0, new ArrayList());
        }
        logger.info("Starting sync to {} external tools", (Object)enabledTools.size());
        int successCount = 0;
        int failureCount = 0;
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (ExternalToolConfig tool : enabledTools) {
            try {
                boolean success = this.syncToTool(tool, changedIndexers);
                if (success) {
                    ++successCount;
                    messages.add((CallSite)((Object)("Successfully synced to " + tool.getName())));
                    continue;
                }
                ++failureCount;
                messages.addAll(this.externalTools.getMessages());
            }
            catch (Exception e) {
                ++failureCount;
                logger.error("Failed to sync to {}: {}", new Object[]{tool.getName(), e.getMessage(), e});
                messages.add((CallSite)((Object)("Failed to sync to " + tool.getName() + ": " + e.getMessage())));
            }
        }
        this.createNotification(successCount, failureCount, messages);
        return new SyncResult(successCount, failureCount, messages);
    }

    private boolean syncToTool(ExternalToolConfig tool, Set<String> changedIndexers) throws IOException {
        logger.info("Syncing to {} ({})", (Object)tool.getName(), (Object)tool.getType());
        AddRequest request = this.buildAddRequest(tool, changedIndexers);
        boolean success = this.externalTools.addNzbhydraAsIndexer(request);
        if (success) {
            logger.info("Successfully synced to {}", (Object)tool.getName());
        } else {
            logger.warn("Failed to sync to {}", (Object)tool.getName());
        }
        return success;
    }

    private AddRequest buildAddRequest(ExternalToolConfig tool, Set<String> changedIndexers) {
        AddRequest request = new AddRequest();
        AddRequest.ExternalTool externalToolType = switch (1.$SwitchMap$org$nzbhydra$config$ExternalToolConfig$ExternalToolType[tool.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> AddRequest.ExternalTool.Sonarr;
            case 2 -> AddRequest.ExternalTool.Radarr;
            case 3 -> AddRequest.ExternalTool.Lidarr;
            case 4 -> AddRequest.ExternalTool.Readarr;
        };
        request.setExternalTool(externalToolType);
        request.setXdarrHost(tool.getHost());
        request.setXdarrApiKey(tool.getApiKey());
        request.setNzbhydraHost(tool.getNzbhydraHost());
        request.setNzbhydraName(tool.getNzbhydraName());
        AddRequest.AddType addType = tool.getSyncType() == ExternalToolConfig.SyncType.SINGLE ? AddRequest.AddType.SINGLE : AddRequest.AddType.PER_INDEXER;
        request.setAddType(addType);
        if (addType == AddRequest.AddType.PER_INDEXER && changedIndexers != null && !changedIndexers.isEmpty()) {
            request.setAdditionalParameters("indexers=" + String.join((CharSequence)",", changedIndexers));
        }
        request.setConfigureForUsenet(tool.isConfigureForUsenet());
        request.setConfigureForTorrents(tool.isConfigureForTorrents());
        request.setAddDisabledIndexers(tool.isAddDisabledIndexers());
        request.setUseHydraPriorities(tool.isUseHydraPriorities());
        request.setPriority(tool.getPriority());
        request.setEnableRss(tool.isEnableRss());
        request.setEnableAutomaticSearch(tool.isEnableAutomaticSearch());
        request.setEnableInteractiveSearch(tool.isEnableInteractiveSearch());
        request.setCategories(tool.getCategories());
        request.setAnimeCategories(tool.getAnimeCategories());
        request.setAdditionalParameters(tool.getAdditionalParameters());
        request.setMinimumSeeders(tool.getMinimumSeeders());
        request.setSeedRatio(tool.getSeedRatio());
        request.setSeedTime(tool.getSeedTime());
        request.setSeasonPackSeedTime(tool.getSeasonPackSeedTime());
        request.setDiscographySeedTime(tool.getDiscographySeedTime());
        request.setEarlyDownloadLimit(tool.getEarlyDownloadLimit());
        request.setRemoveYearFromSearchString(tool.isRemoveYearFromSearchString());
        return request;
    }

    private void createNotification(int successCount, int failureCount, List<String> messages) {
        String title = "External Tools Sync";
        String body = failureCount == 0 && successCount > 0 ? String.format("Successfully synced to %d external tool(s)", successCount) : (successCount == 0 && failureCount > 0 ? String.format("Failed to sync to %d external tool(s). Check logs for details.", failureCount) : String.format("Synced to %d tool(s), %d failed. Check logs for details.", successCount, failureCount));
        this.notificationHandler.handleNotification((NotificationEvent)new ExternalToolConfigResultEvent(body));
    }

    public Set<String> detectChangedIndexers(List<IndexerConfig> oldIndexers, List<IndexerConfig> newIndexers) {
        HashSet<String> changed = new HashSet<String>();
        for (IndexerConfig newIndexer : newIndexers) {
            IndexerConfig oldIndexer = oldIndexers.stream().filter(i -> i.getName().equals(newIndexer.getName())).findFirst().orElse(null);
            if (oldIndexer == null) {
                changed.add(newIndexer.getName());
                continue;
            }
            if (IndexerConfig.isIndexerEquals((IndexerConfig)oldIndexer, (IndexerConfig)newIndexer)) continue;
            changed.add(newIndexer.getName());
        }
        for (IndexerConfig oldIndexer : oldIndexers) {
            boolean exists = newIndexers.stream().anyMatch(i -> i.getName().equals(oldIndexer.getName()));
            if (exists) continue;
            changed.add(oldIndexer.getName());
        }
        return changed;
    }
}

