/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.externaltools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import okhttp3.MediaType;
import org.apache.catalina.util.URLEncoder;
import org.nzbhydra.Jackson;
import org.nzbhydra.api.ExternalApi;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.externaltools.AddRequest;
import org.nzbhydra.externaltools.ExternalTools;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.web.UrlCalculator;
import org.nzbhydra.webaccess.WebAccess;
import org.nzbhydra.webaccess.WebAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalTools {
    private static final TypeReference<List<Map>> LIST_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Logger logger = LoggerFactory.getLogger(ExternalTools.class);
    @Autowired
    private WebAccess webAccess;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UrlCalculator urlCalculator;
    private final List<String> messages = new ArrayList();
    private final Map<IndexerConfig, Integer> indexerPrioritiesMapped = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNzbhydraAsIndexer(AddRequest addRequest) throws IOException {
        try {
            boolean anyUsenetIndexerEnabled;
            logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Received request: {}", (Object)addRequest);
            this.messages.clear();
            this.indexerPrioritiesMapped.clear();
            if (this.failOnUnknownVersion(addRequest)) {
                boolean bl = false;
                return bl;
            }
            if (addRequest.isConfigureForUsenet() && !(anyUsenetIndexerEnabled = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> SearchSource.API.meets(x.getEnabledForSearchSource())).filter(x -> x.getState() == IndexerConfig.State.ENABLED).anyMatch(x -> x.getSearchModuleType() != SearchModuleType.TORZNAB))) {
                this.messages.add("You selected to add NZBHydra as a usenet indexer but no usenet indexers are enabled (for API access)");
                boolean bl = false;
                return bl;
            }
            if (this.deleteIndexers(addRequest)) {
                anyUsenetIndexerEnabled = false;
                return anyUsenetIndexerEnabled;
            }
            logger.info("Enabling mocking mode for external tool configuration. Any search requests made now will return mocked resuls; no indexers will be searched");
            ExternalApi.setInMockingMode((boolean)true);
            logger.info("Received request to configure {} at URL {} with add type {} for usenet: {} and torrents: {}", new Object[]{addRequest.getExternalTool(), addRequest.getXdarrHost(), addRequest.getAddType(), addRequest.isConfigureForUsenet(), addRequest.isConfigureForTorrents()});
            List<IndexerConfig> availableIndexers = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> (x.getState() == IndexerConfig.State.ENABLED || addRequest.isAddDisabledIndexers()) && x.isConfigComplete() && x.isAllCapsChecked()).filter(x -> SearchSource.API.meets(x.getEnabledForSearchSource())).toList();
            Optional<Integer> maxPriority = availableIndexers.stream().map(IndexerConfig::getScore).max(Comparator.naturalOrder());
            if (addRequest.getAddType() == AddRequest.AddType.PER_INDEXER && addRequest.isUseHydraPriorities() && maxPriority.isPresent() && maxPriority.get() > 51) {
                logger.info("Detected indexer with a priority higher than 51 which cannot not supported by {}. Will try to adapt priorities", (Object)addRequest.getExternalTool());
                float ratio = 50.0f / (float)maxPriority.get().intValue();
                availableIndexers.forEach(indexerConfig -> {
                    int arrPriority = (int)(50.0f - (float)indexerConfig.getScore() * ratio);
                    arrPriority = Math.max(arrPriority, 1);
                    logger.debug("Calculated *arr priority for {} to be {}. NZBHydra priority: {}", new Object[]{indexerConfig.getName(), arrPriority, indexerConfig.getScore()});
                    this.indexerPrioritiesMapped.put(indexerConfig, arrPriority);
                });
            }
            if (addRequest.isConfigureForUsenet()) {
                if (addRequest.getAddType() == AddRequest.AddType.SINGLE) {
                    this.executeConfigurationRequest(addRequest, BackendType.Newznab, null);
                } else {
                    List<IndexerConfig> availableTorznabIndexers = availableIndexers.stream().filter(x -> x.getSearchModuleType() != SearchModuleType.TORZNAB).toList();
                    for (IndexerConfig indexer : availableTorznabIndexers) {
                        this.executeConfigurationRequest(addRequest, BackendType.Newznab, indexer);
                    }
                }
            }
            if (addRequest.isConfigureForTorrents()) {
                if (addRequest.getAddType() == AddRequest.AddType.SINGLE) {
                    this.executeConfigurationRequest(addRequest, BackendType.Torznab, null);
                } else {
                    List<IndexerConfig> availableUsenetIndexers = availableIndexers.stream().filter(x -> x.getSearchModuleType() == SearchModuleType.TORZNAB).toList();
                    for (IndexerConfig indexer : availableUsenetIndexers) {
                        this.executeConfigurationRequest(addRequest, BackendType.Torznab, indexer);
                    }
                }
            }
            this.messages.add("Configuration of " + String.valueOf(addRequest.getExternalTool()) + " finished successfully");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.messages.add("Unexpected error: " + e.getMessage());
            logger.error("Unexpected error during configuration of " + addRequest.getExternalTool().name(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("Disabling mocking mode");
            ExternalApi.setInMockingMode((boolean)false);
        }
    }

    private boolean deleteIndexers(AddRequest addRequest) throws IOException {
        List configuredNzbhydraIndexers;
        try {
            configuredNzbhydraIndexers = this.getConfiguredNzbhydraIndexers(addRequest);
        }
        catch (WebAccessException e) {
            this.handleXdarrError(addRequest, e);
            return true;
        }
        logger.info("Found {} configured NZBHydra indexer entries", (Object)configuredNzbhydraIndexers.size());
        for (XdarrIndexer indexer : configuredNzbhydraIndexers) {
            logger.debug("Deleting indexer entry {}", (Object)indexer.getName());
            try {
                this.webAccess.deleteToUrl(this.getExternalToolUrl(addRequest) + "/indexer/" + indexer.getId(), (Map)this.getAuthHeaders(addRequest), 10);
            }
            catch (WebAccessException e) {
                this.handleXdarrError(addRequest, e);
            }
            this.messages.add("Deleted existing entry \"" + indexer.getName() + "\"");
        }
        if (addRequest.getAddType() == AddRequest.AddType.DELETE_ONLY && configuredNzbhydraIndexers.isEmpty()) {
            this.messages.add("No NZBHydra entries found");
        }
        return addRequest.getAddType() == AddRequest.AddType.DELETE_ONLY;
    }

    private boolean failOnUnknownVersion(AddRequest addRequest) throws IOException {
        String body;
        try {
            String url = this.getExternalToolUrl(addRequest) + "/system/status";
            body = this.webAccess.callUrl(url, (Map)this.getAuthHeaders(addRequest));
            logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Received response body: {}", (Object)body);
        }
        catch (WebAccessException e) {
            if (e.getCode() == 404) {
                this.messages.add("Error: API endpoint not found. Make sure URL is correct and you used the correct version");
                throw new IOException("Error: API endpoint not found. Make sure URL is correct and you used the correct version");
            }
            this.handleXdarrError(addRequest, e);
            return true;
        }
        Map statusMap = (Map)Jackson.JSON_MAPPER.readValue(body, Map.class);
        if (!statusMap.containsKey("version")) {
            this.messages.add("Error: no version found in external tool response");
            throw new IOException("Error: no version found in external tool response");
        }
        String version = (String)statusMap.get("version");
        if (addRequest.getExternalTool() == AddRequest.ExternalTool.Sonarr) {
            if (version == null || !version.startsWith("3") && !version.startsWith("4")) {
                this.messages.add("Error: unsupported Sonarr version " + version);
                throw new IOException("Error: unsupported Sonarr version " + version);
            }
        } else if (!(addRequest.getExternalTool() != AddRequest.ExternalTool.Radarr || version != null && (version.startsWith("3") || version.startsWith("4") || version.startsWith("5") || version.startsWith("6") || version.startsWith("7") || version.startsWith("10")))) {
            this.messages.add("Error: unsupported Radarr version " + version);
            throw new IOException("Error: unsupported Radarr version " + version);
        }
        return false;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    private void executeConfigurationRequest(AddRequest addRequest, BackendType backendType, IndexerConfig indexer) throws IOException {
        String body;
        XdarrIndexer xdarrAddRequest = new XdarrIndexer();
        AddRequest.ExternalTool externalTool = addRequest.getExternalTool();
        xdarrAddRequest.setConfigContract(backendType == BackendType.Newznab ? "NewznabSettings" : "TorznabSettings");
        xdarrAddRequest.setEnableAutomaticSearch(Boolean.valueOf(addRequest.isEnableAutomaticSearch()));
        if (externalTool == AddRequest.ExternalTool.Radarr) {
            xdarrAddRequest.setEnableSearch(Boolean.valueOf(addRequest.isEnableAutomaticSearch()));
        }
        xdarrAddRequest.setEnableInteractiveSearch(Boolean.valueOf(addRequest.isEnableInteractiveSearch()));
        xdarrAddRequest.setEnableRss(Boolean.valueOf(addRequest.isEnableRss()));
        xdarrAddRequest.setImplementation(backendType == BackendType.Newznab ? "Newznab" : "Torznab");
        xdarrAddRequest.setImplementationName(backendType == BackendType.Newznab ? "Newznab" : "Torznab");
        xdarrAddRequest.setInfoLink("https://wiki.servarr.com/Sonarr_Supported_Indexers");
        Object nameInXdarr = addRequest.getNzbhydraName();
        if (addRequest.getAddType() == AddRequest.AddType.SINGLE && addRequest.isConfigureForTorrents() && addRequest.isConfigureForUsenet()) {
            nameInXdarr = (String)nameInXdarr + " (" + backendType.name() + ")";
        } else if (indexer != null) {
            nameInXdarr = (String)nameInXdarr + " (" + indexer.getName() + ")";
        }
        xdarrAddRequest.setName((String)nameInXdarr);
        xdarrAddRequest.setProtocol(backendType == BackendType.Newznab ? "usenet" : "torrent");
        xdarrAddRequest.setSupportsRss(Boolean.valueOf(true));
        xdarrAddRequest.setSupportsSearch(Boolean.valueOf(true));
        xdarrAddRequest.getFields().add(new XdarrAddRequestField("apiKey", (Object)this.configProvider.getBaseConfig().getMain().getApiKey()));
        xdarrAddRequest.getFields().add(new XdarrAddRequestField("categories", this.mapCategories(addRequest.getCategories(), addRequest)));
        xdarrAddRequest.getFields().add(new XdarrAddRequestField("additionalParameters", (Object)this.getAdditionalParameters(addRequest, indexer == null ? null : indexer.getName())));
        if (externalTool == AddRequest.ExternalTool.Sonarr) {
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("animeCategories", addRequest.getAnimeCategories() == null ? Collections.emptyList() : addRequest.getAnimeCategories()));
            xdarrAddRequest.setDownloadClientId(0);
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("animeStandardFormatSearch", (Object)false));
        }
        if (externalTool == AddRequest.ExternalTool.Lidarr || externalTool == AddRequest.ExternalTool.Readarr) {
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("earlyReleaseLimit", (Object)addRequest.getEarlyDownloadLimit()));
        }
        if (backendType == BackendType.Torznab) {
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("seedCriteria.seedRatio", (Object)addRequest.getSeedRatio()));
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("seedCriteria.seedTime", (Object)addRequest.getSeedTime()));
            if (externalTool == AddRequest.ExternalTool.Sonarr) {
                xdarrAddRequest.getFields().add(new XdarrAddRequestField("seedCriteria.seasonPackSeedTime", (Object)addRequest.getSeasonPackSeedTime()));
            }
            if (externalTool == AddRequest.ExternalTool.Lidarr || externalTool == AddRequest.ExternalTool.Readarr) {
                xdarrAddRequest.getFields().add(new XdarrAddRequestField("seedCriteria.discographySeedTime", (Object)addRequest.getDiscographySeedTime()));
            }
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("baseUrl", (Object)(addRequest.getNzbhydraHost() + "/torznab")));
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("minimumSeeders", (Object)(addRequest.getMinimumSeeders() != null ? Integer.parseInt(addRequest.getMinimumSeeders()) : 1)));
        } else {
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("baseUrl", (Object)addRequest.getNzbhydraHost()));
        }
        xdarrAddRequest.setPriority(25);
        if (addRequest.getAddType() == AddRequest.AddType.SINGLE && addRequest.getPriority() != null && addRequest.getPriority() != 0) {
            xdarrAddRequest.setPriority(addRequest.getPriority().intValue());
        } else if (addRequest.isUseHydraPriorities() && indexer != null) {
            if (!this.indexerPrioritiesMapped.isEmpty()) {
                xdarrAddRequest.setPriority(((Integer)this.indexerPrioritiesMapped.get(indexer)).intValue());
            } else {
                int arrPriority = 50 - indexer.getScore();
                arrPriority = Math.max(arrPriority, 1);
                logger.debug("Calculated *arr priority for {} to be {}. NZBHydra priority: {}", new Object[]{indexer.getName(), arrPriority, indexer.getScore()});
                xdarrAddRequest.setPriority(arrPriority);
            }
        }
        if (externalTool.isRadarr()) {
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("removeYear", (Object)addRequest.isRemoveYearFromSearchString()));
            xdarrAddRequest.getFields().add(new XdarrAddRequestField("multiLanguages", Collections.emptyList()));
            if (backendType == BackendType.Torznab) {
                xdarrAddRequest.getFields().add(new XdarrAddRequestField("requiredFlags", Collections.emptyList()));
            }
        }
        xdarrAddRequest.getFields().add(new XdarrAddRequestField("apiPath", (Object)"/api"));
        try {
            body = Jackson.JSON_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)xdarrAddRequest);
            logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Built request body: {}", (Object)body);
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to write request", (Throwable)e);
            throw new IOException("Unable to write request", e);
        }
        try {
            String url = this.getExternalToolUrl(addRequest) + "/indexer";
            logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Calling URL {} with data\n{} and body\n{}", new Object[]{url, xdarrAddRequest, body});
            String response = this.webAccess.postToUrl(url, MediaType.get((String)"application/json"), body, (Map)this.getAuthHeaders(addRequest), 10);
            logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Received response body: {}", (Object)response);
            if (response == null) {
                throw new WebAccessException("No response available from tool");
            }
            if (response.startsWith("[")) {
                throw new WebAccessException("If you configured " + addRequest.getExternalTool().name() + " to use an URL base make sure to add it in the URL.");
            }
            Map requestResponse = (Map)Jackson.JSON_MAPPER.readValue(response, Map.class);
            this.messages.add("Configured \"" + (String)nameInXdarr + "\"");
        }
        catch (WebAccessException e) {
            this.handleXdarrError(addRequest, e);
        }
    }

    private Object mapCategories(String categoriesString, AddRequest addRequest) {
        if (Strings.isNullOrEmpty((String)categoriesString)) {
            return Collections.emptyList();
        }
        return Stream.of(addRequest.getCategories().split(",")).map(Integer::parseInt).collect(Collectors.toList());
    }

    private List<XdarrIndexer> getConfiguredNzbhydraIndexers(AddRequest addRequest) throws IOException {
        String url = this.getExternalToolUrl(addRequest) + "/indexer";
        logger.debug("Getting configured indexers using URL {}", (Object)url);
        String response = this.webAccess.callUrl(url, (Map)this.getAuthHeaders(addRequest));
        logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Received response body: {}", (Object)response);
        List requestResponse = (List)Jackson.JSON_MAPPER.readValue(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List<XdarrIndexer> nzbhydraIndexers = requestResponse.stream().filter(x -> x.getName().contains(addRequest.getNzbhydraName())).collect(Collectors.toList());
        return nzbhydraIndexers;
    }

    private void handleXdarrError(AddRequest addRequest, WebAccessException e) throws IOException {
        logger.debug(LoggingMarkers.EXTERNAL_TOOLS, "Received error response: {}", (Object)e.getBody());
        if (e.getBody() != null && e.getBody().trim().startsWith("[")) {
            List requestResponse = (List)Jackson.JSON_MAPPER.readValue(e.getBody(), LIST_TYPE_REFERENCE);
            if (!requestResponse.isEmpty() && ((Map)requestResponse.get(0)).containsKey("errorMessage")) {
                String errorMessage = (String)((Map)requestResponse.get(0)).get("errorMessage");
                this.messages.add("Error: " + errorMessage);
                throw new IOException(addRequest.getExternalTool().name() + " returned error message: " + errorMessage);
            }
        } else {
            if (e.getBody() != null && e.getBody().trim().startsWith("{")) {
                String errorMessage = (String)((Map)Jackson.JSON_MAPPER.readValue(e.getBody(), Map.class)).get("error");
                if (Strings.isNullOrEmpty((String)errorMessage)) {
                    errorMessage = (String)((Map)Jackson.JSON_MAPPER.readValue(e.getBody(), Map.class)).get("message");
                }
                this.messages.add("Error: " + errorMessage);
                throw new IOException(addRequest.getExternalTool().name() + " returned error message: " + errorMessage);
            }
            this.messages.add(e.getMessage());
            throw e;
        }
    }

    private HashMap<String, String> getAuthHeaders(AddRequest addRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (addRequest.getXdarrApiKey() != null) {
            headers.put("X-Api-Key", addRequest.getXdarrApiKey());
        }
        return headers;
    }

    private String getExternalToolUrl(AddRequest addRequest) {
        String url = addRequest.getExternalTool() == AddRequest.ExternalTool.Sonarr || addRequest.getExternalTool() == AddRequest.ExternalTool.Radarr ? addRequest.getXdarrHost() + "/api/v3" : (addRequest.getExternalTool() == AddRequest.ExternalTool.Lidarr || addRequest.getExternalTool() == AddRequest.ExternalTool.Readarr ? addRequest.getXdarrHost() + "/api/v1" : addRequest.getXdarrHost() + "/api");
        return url;
    }

    private String getAdditionalParameters(AddRequest addRequest, String indexerName) {
        String parametersString = addRequest.getAdditionalParameters();
        Map parameterMap = this.parseParameters(parametersString);
        parameterMap.remove("indexers");
        if (indexerName != null) {
            parameterMap.put("indexers", URLEncoder.QUERY.encode(indexerName, StandardCharsets.UTF_8));
        }
        return parameterMap.isEmpty() ? null : "&" + parameterMap.entrySet().stream().map(x -> (String)x.getKey() + "=" + (String)x.getValue()).collect(Collectors.joining("&"));
    }

    private Map<String, String> parseParameters(String parametersString) {
        if (parametersString == null) {
            return new HashMap<String, String>();
        }
        Set<String> parameters = Stream.of(parametersString.split("&")).filter(x -> !Strings.isNullOrEmpty((String)x)).collect(Collectors.toSet());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameters.forEach(x -> {
            String[] split = x.split("=");
            parameterMap.put(split[0], split[1]);
        });
        return parameterMap;
    }
}

