/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.torrents;

import com.google.common.io.Files;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.downloading.FileDownloadAccessType;
import org.nzbhydra.downloading.DownloadResult;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.InvalidSearchResultIdException;
import org.nzbhydra.downloading.MagnetLinkRedirectException;
import org.nzbhydra.downloading.SaveOrSendResultsResponse;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import uriSchemeHandler.CouldNotOpenUriSchemeHandler;
import uriSchemeHandler.URISchemeHandler;

@Component
public class TorrentFileHandler {
    private static final Logger logger = LoggerFactory.getLogger(TorrentFileHandler.class);
    @Autowired
    private FileHandler fileHandler;
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    private SearchResultRepository searchResultRepository;

    @Transactional
    public DownloadResult getTorrentByGuid(long guid, FileDownloadAccessType accessType, SearchSource accessSource) throws InvalidSearchResultIdException {
        Optional optionalResult = this.searchResultRepository.findById((Object)guid);
        if (optionalResult.isEmpty()) {
            logger.error("Download request with invalid/outdated GUID {}", (Object)guid);
            throw new InvalidSearchResultIdException(guid, accessSource == SearchSource.INTERNAL);
        }
        SearchResultEntity result = (SearchResultEntity)optionalResult.get();
        logger.info("Download request for \"{}\" from indexer {}", (Object)result.getTitle(), (Object)result.getIndexer().getName());
        if (result.getLink().startsWith("magnet") || accessType == FileDownloadAccessType.REDIRECT) {
            return this.fileHandler.handleRedirect(accessSource, result, null);
        }
        try {
            return this.fileHandler.handleContentDownload(accessSource, result);
        }
        catch (MagnetLinkRedirectException e) {
            return this.fileHandler.handleRedirect(accessSource, result, e.getMagnetLink());
        }
    }

    public SaveOrSendResultsResponse saveOrSendTorrents(Set<Long> guids) {
        ArrayList<Long> successfulIds = new ArrayList<Long>();
        ArrayList<Long> failedIds = new ArrayList<Long>();
        for (Long guid : guids) {
            DownloadResult result;
            boolean successful = false;
            try {
                result = this.getTorrentByGuid(guid.longValue(), FileDownloadAccessType.PROXY, SearchSource.INTERNAL);
            }
            catch (InvalidSearchResultIdException e) {
                logger.error("Unable to find result with ID {}", (Object)guid);
                failedIds.add(guid);
                continue;
            }
            try {
                if (result.isSuccessful()) {
                    successful = result.getContent() != null ? this.saveToBlackHole(result, null) : this.handleMagnetLink(result);
                }
            }
            catch (Exception e) {
                logger.error("Error while handling " + String.valueOf(result), (Throwable)e);
                failedIds.add(guid);
            }
            if (successful) {
                successfulIds.add(guid);
                continue;
            }
            failedIds.add(guid);
        }
        String message = failedIds.isEmpty() ? "All torrents successfully handled" : failedIds.size() + " torrents could not be handled";
        return new SaveOrSendResultsResponse(!successfulIds.isEmpty(), message, successfulIds, failedIds);
    }

    private boolean handleMagnetLink(DownloadResult result) {
        URI magnetLinkUri;
        try {
            magnetLinkUri = new URI(result.getCleanedUrl());
        }
        catch (URISyntaxException e) {
            logger.error("Unable to encode magnet URI {}", (Object)result.getUrl());
            return false;
        }
        if (this.configProvider.getBaseConfig().getDownloading().getSaveTorrentsTo().isPresent()) {
            return this.saveToBlackHole(result, magnetLinkUri);
        }
        logger.error("Torrent black hole folder not set");
        URISchemeHandler uriSchemeHandler = new URISchemeHandler();
        try {
            uriSchemeHandler.open(magnetLinkUri);
            return true;
        }
        catch (CouldNotOpenUriSchemeHandler e) {
            logger.error("Unable to add magnet link for {}: {}", (Object)result.getTitle(), (Object)e.getMessage());
            return false;
        }
        catch (RuntimeException e) {
            logger.error("No handler registered for magnet links. Unable to add link for {}", (Object)result.getTitle());
            return false;
        }
    }

    private boolean saveToBlackHole(DownloadResult result, URI magnetLinkUri) {
        byte[] content;
        if (this.configProvider.getBaseConfig().getDownloading().getSaveTorrentsTo().isEmpty()) {
            logger.error("Torrent black hole folder not set");
            return false;
        }
        if (magnetLinkUri != null) {
            String UriContent = magnetLinkUri.toString();
            content = UriContent.getBytes();
        } else {
            content = result.getContent();
        }
        File torrentFileName = this.getTargetFile(result, magnetLinkUri);
        if (torrentFileName == null) {
            return false;
        }
        try {
            Files.write((byte[])content, (File)torrentFileName);
            logger.info("Saved torrent file to {}", (Object)torrentFileName.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            logger.error("Error saving torrent file", (Throwable)e);
            return false;
        }
    }

    protected File getTargetFile(DownloadResult result, URI magnetLinkUri) {
        String sanitizedTitle = result.getTitle().replaceAll("[\\\\/:*?\"<>|]", "_");
        if (!Objects.equals(sanitizedTitle, result.getTitle())) {
            logger.info("Sanitized torrent title from '{}' to '{}'", (Object)result.getTitle(), (Object)sanitizedTitle);
        }
        File torrentFileName = magnetLinkUri != null ? new File((String)this.configProvider.getBaseConfig().getDownloading().getSaveTorrentsTo().get(), sanitizedTitle + ".magnet") : new File((String)this.configProvider.getBaseConfig().getDownloading().getSaveTorrentsTo().get(), sanitizedTitle + ".torrent");
        String torrentFileNameAbsolutePath = torrentFileName.getAbsolutePath();
        if (torrentFileName.exists()) {
            logger.info("File {} already exists and will be skipped", (Object)torrentFileNameAbsolutePath);
            return null;
        }
        if (torrentFileNameAbsolutePath.length() > 220) {
            int maxFilenameLength = 220 - torrentFileName.getParentFile().getAbsolutePath().length() - FilenameUtils.getExtension((String)torrentFileNameAbsolutePath).length() - "/".length() - ".".length();
            torrentFileName = new File(torrentFileName.getParent(), StringUtils.truncate((String)FilenameUtils.removeExtension((String)torrentFileName.getName()), (int)maxFilenameLength) + "." + FilenameUtils.getExtension((String)torrentFileNameAbsolutePath));
            logger.info("Shortened file name to '{}'", (Object)torrentFileName);
        }
        return torrentFileName;
    }
}

