/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders;

import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.ShutdownEvent;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.nzbhydra.downloading.downloaders.DownloaderStatusRetrieval;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.stereotype.Controller;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@Controller
public class DownloaderWebSocket {
    private static final Logger logger = LoggerFactory.getLogger(DownloaderWebSocket.class);
    private static final int INTERVAL = 1000;
    private static final String TOPIC = "/topic/downloaderStatus";
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private DownloaderStatusRetrieval downloaderStatusRetrieval;
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> scheduledFuture;
    private DownloaderStatus lastSentStatus;
    private final Set<String> connectedSessionIds = new HashSet();

    @MessageMapping(value={"/connectDownloaderStatus"})
    @SendTo(value={"/topic/downloaderStatus"})
    public DownloaderStatus connect() {
        return this.lastSentStatus;
    }

    private void scheduleDownloadStatusSending() {
        this.scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            DownloaderStatus newStatus = this.downloaderStatusRetrieval.getStatus();
            if (newStatus.getState() == DownloaderStatus.State.DOWNLOADING) {
                logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Sending new downloading status data. Status: {}. In queue: {}. Remaining time: {}. Download rate: {}", new Object[]{newStatus.getState(), newStatus.getElementsInQueue(), newStatus.getRemainingTimeFormatted(), newStatus.getDownloadRateFormatted()});
                this.messagingTemplate.convertAndSend((Object)TOPIC, (Object)newStatus);
                this.lastSentStatus = newStatus;
            } else if (!newStatus.equals((Object)this.lastSentStatus)) {
                logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Sending new status data because it's different from the last sent. Status: {}. In queue: {}. Remaining time: {}. Download rate: {}", new Object[]{newStatus.getState(), newStatus.getElementsInQueue(), newStatus.getRemainingTimeFormatted(), newStatus.getDownloadRateFormatted()});
                this.messagingTemplate.convertAndSend((Object)TOPIC, (Object)newStatus);
                this.lastSentStatus = newStatus;
            } else if (!this.lastSentStatus.isLastUpdateForNow()) {
                logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "New status data is the same as the old. Informing the frontend this is the last update for now. Status: {}. In queue: {}. Remaining time: {}. Download rate: {}", new Object[]{newStatus.getState(), newStatus.getElementsInQueue(), newStatus.getRemainingTimeFormatted(), newStatus.getDownloadRateFormatted()});
                newStatus.setLastUpdateForNow(true);
                this.messagingTemplate.convertAndSend((Object)TOPIC, (Object)newStatus);
                this.lastSentStatus = newStatus;
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @EventListener
    public void onClientSubscribe(SessionSubscribeEvent event) {
        String simpDestination = (String)event.getMessage().getHeaders().get((Object)"simpDestination");
        if (TOPIC.equals(simpDestination)) {
            String simpSessionId = (String)event.getMessage().getHeaders().get((Object)"simpSessionId");
            logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Registered new connection with session ID {}", (Object)simpSessionId);
            if (this.connectedSessionIds.isEmpty()) {
                logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Scheduling downloader status update {}", (Object)simpSessionId);
                this.scheduleDownloadStatusSending();
            }
            this.connectedSessionIds.add(simpSessionId);
        }
    }

    @EventListener
    public void onClientDisconnect(SessionDisconnectEvent event) {
        String simpSessionId = (String)event.getMessage().getHeaders().get((Object)"simpSessionId");
        if (this.connectedSessionIds.contains(simpSessionId)) {
            logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Registered disconnect with session ID {}", (Object)simpSessionId);
            this.connectedSessionIds.remove(simpSessionId);
            if (this.connectedSessionIds.isEmpty()) {
                if (this.scheduledFuture != null) {
                    logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Cancelling update schedule because no connections left");
                    this.scheduledFuture.cancel(true);
                    this.scheduledFuture = null;
                } else {
                    logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "No connections found but update was also not scheduled");
                }
            } else {
                logger.debug(LoggingMarkers.DOWNLOADER_STATUS_UPDATE, "Not cancelling schedule because still connections left");
            }
        }
    }

    @EventListener
    public void handleNewConfig(ConfigChangedEvent configChangedEvent) {
        if (this.scheduledFuture != null && !configChangedEvent.getNewConfig().getDownloading().isShowDownloaderStatus()) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        } else if (this.scheduledFuture == null && configChangedEvent.getNewConfig().getDownloading().isShowDownloaderStatus()) {
            this.scheduleDownloadStatusSending();
        }
    }

    @EventListener
    public void handleShutdown(ShutdownEvent shutdownEvent) {
        this.onShutdown();
    }

    @PreDestroy
    public void onShutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.scheduler.shutdown();
    }
}

