/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.springnative.ReflectionMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

@ReflectionMarker
public class DownloadResult {
    private static final Logger logger = LoggerFactory.getLogger(DownloadResult.class);
    private byte[] content;
    private String url;
    private String title;
    private boolean successful;
    private String error;
    private FileDownloadEntity downloadEntity;
    private HttpStatus statusCode;
    private static final Pattern URL_PARAM_PATTERN = Pattern.compile("dn=([^&$]+)");

    protected DownloadResult(String title, byte[] content, String url, boolean successful, String error, FileDownloadEntity downloadEntity) {
        this.content = content;
        this.title = title;
        this.url = url;
        this.successful = successful;
        this.error = error;
        this.downloadEntity = downloadEntity;
        this.statusCode = HttpStatus.OK;
    }

    protected DownloadResult(String title, byte[] content, String url, boolean successful, String error, HttpStatus statusCode, FileDownloadEntity downloadEntity) {
        this(title, content, url, successful, error, downloadEntity);
        this.statusCode = statusCode;
    }

    public boolean isRedirect() {
        return this.url != null;
    }

    protected String getFileName() {
        Object filename = this.title;
        filename = this.downloadEntity.getSearchResult().getDownloadType() == DownloadType.NZB ? (String)filename + ".nzb" : (String)filename + ".torrent";
        return filename;
    }

    public ResponseEntity<Object> getAsResponseEntity() {
        ResponseEntity response;
        if (this.statusCode != HttpStatus.OK) {
            if (this.statusCode == HttpStatus.TOO_MANY_REQUESTS || this.statusCode == HttpStatus.INTERNAL_SERVER_ERROR) {
                HttpHeaders headers = new HttpHeaders();
                String headerValue = String.valueOf(14400);
                headers.add("Retry-After", headerValue);
                response = new ResponseEntity((Object)this.error, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS);
                logger.warn("Download not OK. Status: {}. Adding RetryAfter header with value {}", (Object)this.statusCode, (Object)headerValue);
            } else {
                response = new ResponseEntity((Object)this.error, (HttpStatusCode)this.statusCode);
            }
        } else if (this.isRedirect()) {
            HttpHeaders headers = new HttpHeaders();
            String url = this.getCleanedUrl();
            headers.setLocation(URI.create(url));
            response = new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)HttpStatus.FOUND);
        } else {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=\"" + this.getFileName().replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
            if (this.downloadEntity.getSearchResult().getDownloadType() == DownloadType.TORRENT) {
                headers.add("Content-Type", "application/x-bittorrent");
            } else if (this.downloadEntity.getSearchResult().getDownloadType() == DownloadType.NZB) {
                headers.add("Content-Type", "application/x-nzb");
            }
            response = new ResponseEntity((Object)this.getContent(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return response;
    }

    public String getCleanedUrl() {
        if (this.url.startsWith("magnet%3A")) {
            this.url = URLDecoder.decode(this.url, StandardCharsets.UTF_8);
        }
        if (!this.url.contains("magnet:")) {
            return this.url;
        }
        Matcher matcher = URL_PARAM_PATTERN.matcher(this.url);
        if (!matcher.find()) {
            return this.url;
        }
        String dn = matcher.group(1);
        this.url = this.url.replace("dn=" + dn, "dn=" + URLEncoder.encode(dn)).replace(" ", "%20");
        return this.url;
    }

    public static DownloadResult createSuccessfulDownloadResult(String title, byte[] content, FileDownloadEntity entity) {
        return new DownloadResult(title, content, null, true, null, entity);
    }

    public static DownloadResult createSuccessfulRedirectResult(String title, String url, FileDownloadEntity entity) {
        return new DownloadResult(title, null, url, true, null, entity);
    }

    public static DownloadResult createErrorResult(String error, FileDownloadEntity entity) {
        return new DownloadResult(null, null, null, false, error, entity);
    }

    public static DownloadResult createErrorResult(String error) {
        return new DownloadResult(null, null, null, false, error, null);
    }

    public static DownloadResult createErrorResult(String error, HttpStatus httpStatus, FileDownloadEntity entity) {
        return new DownloadResult(null, null, null, false, error, httpStatus, entity);
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getError() {
        return this.error;
    }

    public FileDownloadEntity getDownloadEntity() {
        return this.downloadEntity;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setDownloadEntity(FileDownloadEntity downloadEntity) {
        this.downloadEntity = downloadEntity;
    }

    public void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadResult)) {
            return false;
        }
        DownloadResult other = (DownloadResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        FileDownloadEntity this$downloadEntity = this.getDownloadEntity();
        FileDownloadEntity other$downloadEntity = other.getDownloadEntity();
        if (this$downloadEntity == null ? other$downloadEntity != null : !this$downloadEntity.equals(other$downloadEntity)) {
            return false;
        }
        HttpStatus this$statusCode = this.getStatusCode();
        HttpStatus other$statusCode = other.getStatusCode();
        return !(this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getContent());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        FileDownloadEntity $downloadEntity = this.getDownloadEntity();
        result = result * 59 + ($downloadEntity == null ? 43 : $downloadEntity.hashCode());
        HttpStatus $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        return result;
    }

    public String toString() {
        return "DownloadResult(content=" + Arrays.toString(this.getContent()) + ", url=" + this.getUrl() + ", title=" + this.getTitle() + ", successful=" + this.isSuccessful() + ", error=" + this.getError() + ", downloadEntity=" + String.valueOf(this.getDownloadEntity()) + ", statusCode=" + String.valueOf(this.getStatusCode()) + ")";
    }
}

