/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.debuginfos;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.nzbhydra.Jackson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileIoUploader {
    private static final Logger logger = LoggerFactory.getLogger(FileIoUploader.class);

    public static String upload(File file) throws IOException {
        OkHttpClient httpClient = new OkHttpClient();
        logger.info("Starting upload of debug infos file {}", (Object)file);
        String json = FileIoUploader.uploadFile((File)file, (OkHttpClient)httpClient);
        String url = URLDecoder.decode((String)((Map)Jackson.JSON_MAPPER.readValue(json, Map.class)).get("link"), StandardCharsets.UTF_8);
        logger.info("Uploaded debug infos to {}", (Object)url);
        return url;
    }

    private static String uploadFile(File file, OkHttpClient httpClient) throws IOException {
        String url = "https://file.io/";
        logger.debug("Sending upload POST to {}", (Object)"https://file.io/");
        Response post = httpClient.newCall(new Request.Builder().url("https://file.io/").method("POST", (RequestBody)new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("chunk_index", "1").addFormDataPart("autoDelete", "true").addFormDataPart("file", "nzbhydra2-debug-infos.zip", RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream"))).build()).build()).execute();
        if (!post.isSuccessful()) {
            throw new IOException(FileIoUploader.createErrorFromResponse((Response)post, (ResponseBody)post.body(), (String)"Error uploading chunk. Status: "));
        }
        logger.debug("Successfully uploaded file");
        return post.body().string();
    }

    private static String createErrorFromResponse(Response post, ResponseBody body, String prefix) throws IOException {
        String message = prefix + post.code();
        if (Strings.isNotEmpty((CharSequence)post.message())) {
            message = message + ". Message: " + post.message();
        }
        if (post.body() != null) {
            String bodyString = post.body().string();
            if (Strings.isNotEmpty((CharSequence)bodyString)) {
                message = message + ". Body:\n" + StringUtils.abbreviate((String)bodyString, (int)500);
            }
            post.body().close();
        }
        logger.error(message);
        return message;
    }
}

