/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.auth.UserAuthConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.springframework.stereotype.Component;

@Component
public class UserAuthConfigValidator
implements ConfigValidator<UserAuthConfig> {
    public boolean doesValidate(Class<?> clazz) {
        return clazz == UserAuthConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, UserAuthConfig newConfig) {
        return new ConfigValidationResult();
    }

    public UserAuthConfig prepareForSaving(BaseConfig oldBaseConfig, UserAuthConfig newConfig) {
        if (newConfig.getPassword() != null && !newConfig.getPassword().startsWith("{noop}")) {
            newConfig.setPassword("{noop}" + newConfig.getPassword());
        }
        return newConfig;
    }

    public UserAuthConfig updateAfterLoading(UserAuthConfig newConfig) {
        if (newConfig.getPassword() != null && newConfig.getPassword().startsWith("{noop}")) {
            newConfig.setPassword(newConfig.getPassword().substring(6));
        }
        return newConfig;
    }
}

