/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.nzbhydra.config.RestartRequired;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValidationTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigValidationTools.class);

    static void checkRegex(List<String> errorMessages, String regex, String errorMessage) {
        if (!Strings.isNullOrEmpty((String)regex)) {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                errorMessages.add(errorMessage);
            }
        }
    }

    public static boolean isRestartNeeded(Object oldConfig, Object newConfig) {
        for (Field field : oldConfig.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(RestartRequired.class)) continue;
            try {
                String getterName = (field.getType() == Boolean.class || field.getType() == Boolean.TYPE ? "is" : "get") + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                Method method = oldConfig.getClass().getDeclaredMethod(getterName, new Class[0]);
                Object oldValue = method.invoke(oldConfig, new Object[0]);
                Object newValue = method.invoke(newConfig, new Object[0]);
                if (Objects.equals(oldValue, newValue)) continue;
                logger.debug("Restart needed because field {} has changed", (Object)field.getName());
                return true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("Unable to determine if field '{}' in class {} was changed", (Object)field.getName(), (Object)oldConfig.getClass().getName());
            }
        }
        return false;
    }
}

