/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.SearchSourceRestriction;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.validation.AuthConfigValidator;
import org.nzbhydra.config.validation.CategoriesConfigValidator;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.config.validation.DownloadingConfigValidator;
import org.nzbhydra.config.validation.IndexerConfigValidator;
import org.nzbhydra.config.validation.MainConfigValidator;
import org.nzbhydra.config.validation.SearchingConfigValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaseConfigValidator
implements ConfigValidator<BaseConfig> {
    private static final Logger logger = LoggerFactory.getLogger(BaseConfigValidator.class);
    @Autowired
    private CategoriesConfigValidator categoriesConfigValidator;
    @Autowired
    private DownloadingConfigValidator downloadingConfigValidator;
    @Autowired
    private SearchingConfigValidator searchingConfigValidator;
    @Autowired
    private MainConfigValidator mainConfigValidator;
    @Autowired
    private AuthConfigValidator authConfigValidator;
    @Autowired
    private IndexerConfigValidator indexerConfigValidator;
    @Autowired
    private List<ConfigValidator> configValidatorList;

    public boolean doesValidate(Class<?> clazz) {
        return clazz == BaseConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, BaseConfig newConfig) {
        ConfigValidationResult configValidationResult = new ConfigValidationResult();
        ArrayList<Object> configs = new ArrayList<Object>(Arrays.asList(newBaseConfig.getMain(), newBaseConfig.getSearching(), newBaseConfig.getDownloading(), newBaseConfig.getCategoriesConfig(), newBaseConfig.getAuth()));
        configs.addAll(newConfig.getIndexers());
        for (Object e : configs) {
            ConfigValidator validator = this.configValidatorList.stream().filter(x -> x.doesValidate(config.getClass())).findFirst().orElseThrow();
            ConfigValidationResult result = validator.validateConfig(oldBaseConfig, newBaseConfig, e);
            configValidationResult.getErrorMessages().addAll(result.getErrorMessages());
            configValidationResult.getWarningMessages().addAll(result.getWarningMessages());
            configValidationResult.setRestartNeeded(configValidationResult.isRestartNeeded() || result.isRestartNeeded());
        }
        this.validateIndexers(newConfig, configValidationResult);
        if (!configValidationResult.getErrorMessages().isEmpty()) {
            logger.warn("Config validation returned errors:\n" + Joiner.on((String)"\n").join((Iterable)configValidationResult.getErrorMessages()));
        }
        if (!configValidationResult.getWarningMessages().isEmpty()) {
            logger.warn("Config validation returned warnings:\n" + Joiner.on((String)"\n").join((Iterable)configValidationResult.getWarningMessages()));
        }
        if (configValidationResult.isRestartNeeded()) {
            logger.warn("Settings were changed that require a restart to become effective");
        }
        configValidationResult.setOk(configValidationResult.getErrorMessages().isEmpty());
        return configValidationResult;
    }

    private void validateIndexers(BaseConfig newConfig, ConfigValidationResult configValidationResult) {
        if (!newConfig.getIndexers().isEmpty()) {
            if (newConfig.getIndexers().stream().noneMatch(x -> x.getState() == IndexerConfig.State.ENABLED)) {
                configValidationResult.getWarningMessages().add("No indexers enabled. Searches will return empty results");
            } else if (newConfig.getIndexers().stream().allMatch(x -> x.getSupportedSearchIds().isEmpty())) {
                if (newConfig.getSearching().getGenerateQueries() == SearchSourceRestriction.NONE) {
                    configValidationResult.getWarningMessages().add("No indexer found that supports search IDs. Without query generation searches using search IDs will return empty results.");
                } else if (newConfig.getSearching().getGenerateQueries() != SearchSourceRestriction.BOTH) {
                    String name = newConfig.getSearching().getGenerateQueries() == SearchSourceRestriction.API ? "internal" : "API";
                    configValidationResult.getWarningMessages().add("No indexer found that supports search IDs. Without query generation " + name + " searches using search IDs will return empty results.");
                }
            }
            HashSet<String> indexerNames = new HashSet<String>();
            HashSet<String> duplicateIndexerNames = new HashSet<String>();
            for (IndexerConfig indexer : newConfig.getIndexers()) {
                if (indexerNames.add(indexer.getName())) continue;
                duplicateIndexerNames.add(indexer.getName());
            }
            if (!duplicateIndexerNames.isEmpty()) {
                configValidationResult.getErrorMessages().add("Duplicate indexer names found: " + Joiner.on((String)", ").join(duplicateIndexerNames));
            }
            HashSet indexersSameHostAndApikey = new HashSet();
            for (IndexerConfig indexer : newConfig.getIndexers()) {
                Set otherIndexersSameHostAndApiKey = newConfig.getIndexers().stream().filter(x -> x != indexer).filter(x -> IndexerConfig.isIndexerEquals((IndexerConfig)x, (IndexerConfig)indexer)).map(IndexerConfig::getName).collect(Collectors.toSet());
                if (otherIndexersSameHostAndApiKey.isEmpty()) continue;
                otherIndexersSameHostAndApiKey.add(indexer.getName());
                if (!indexersSameHostAndApikey.stream().noneMatch(x -> x.contains(indexer.getName()))) continue;
                indexersSameHostAndApikey.add(otherIndexersSameHostAndApiKey);
                String message = "Found multiple indexers with same host and API key: " + Joiner.on((String)", ").join(otherIndexersSameHostAndApiKey);
                logger.warn(message);
                configValidationResult.getWarningMessages().add(message);
            }
        } else {
            configValidationResult.getWarningMessages().add("No indexers configured. You won't get any results");
        }
    }

    public BaseConfig prepareForSaving(BaseConfig oldBaseConfig, BaseConfig newConfig) {
        this.categoriesConfigValidator.prepareForSaving(oldBaseConfig, (Object)newConfig.getCategoriesConfig());
        this.downloadingConfigValidator.prepareForSaving(oldBaseConfig, (Object)newConfig.getDownloading());
        this.searchingConfigValidator.prepareForSaving(oldBaseConfig, newConfig.getSearching());
        this.mainConfigValidator.prepareForSaving(oldBaseConfig, newConfig.getMain());
        this.authConfigValidator.prepareForSaving(oldBaseConfig, newConfig.getAuth());
        newConfig.getIndexers().removeIf(Objects::isNull);
        newConfig.getIndexers().forEach(x -> this.indexerConfigValidator.prepareForSaving(oldBaseConfig, x));
        return newConfig;
    }

    public BaseConfig updateAfterLoading(BaseConfig newConfig) {
        this.authConfigValidator.updateAfterLoading(newConfig.getAuth());
        return newConfig;
    }

    public BaseConfig initializeNewConfig(BaseConfig newConfig) {
        this.categoriesConfigValidator.initializeNewConfig((Object)newConfig.getCategoriesConfig());
        this.downloadingConfigValidator.initializeNewConfig((Object)newConfig.getDownloading());
        this.searchingConfigValidator.initializeNewConfig((Object)newConfig.getSearching());
        this.mainConfigValidator.initializeNewConfig(newConfig.getMain());
        this.authConfigValidator.initializeNewConfig((Object)newConfig.getAuth());
        return newConfig;
    }
}

