/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.auth.AuthConfig;
import org.nzbhydra.config.auth.AuthType;
import org.nzbhydra.config.auth.UserAuthConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidationTools;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.config.validation.UserAuthConfigValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthConfigValidator
implements ConfigValidator<AuthConfig> {
    @Autowired
    private UserAuthConfigValidator userAuthConfigValidator;

    public boolean doesValidate(Class<?> clazz) {
        return clazz == AuthConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, AuthConfig newConfig) {
        ArrayList<Object> errors = new ArrayList<Object>();
        ArrayList warnings = new ArrayList();
        if (newConfig.getAuthType() != AuthType.NONE && newConfig.getUsers().isEmpty()) {
            errors.add("You've enabled security but not defined any users");
        } else if (newConfig.getAuthType() != AuthType.NONE && newConfig.isRestrictAdmin() && newConfig.getUsers().stream().noneMatch(UserAuthConfig::isMaySeeAdmin)) {
            errors.add("You've restricted admin access but no user has admin rights");
        } else if (newConfig.getAuthType() != AuthType.NONE && !newConfig.isRestrictSearch() && !newConfig.isRestrictAdmin()) {
            errors.add("You haven't enabled any access restrictions. Auth will not take any effect");
        }
        HashSet<String> usernames = new HashSet<String>();
        ArrayList<String> duplicateUsernames = new ArrayList<String>();
        for (UserAuthConfig user : newConfig.getUsers()) {
            if (usernames.contains(user.getUsername())) {
                duplicateUsernames.add(user.getUsername());
            }
            usernames.add(user.getUsername());
        }
        if (!duplicateUsernames.isEmpty()) {
            errors.add("The following user names are not unique: " + Joiner.on((String)", ").join(duplicateUsernames));
        }
        if (!newConfig.getAuthHeaderIpRanges().isEmpty()) {
            newConfig.getAuthHeaderIpRanges().forEach(x -> {
                Matcher matcher = Pattern.compile("^(\\*|(?:(?:\\d{1,3}\\.){3}\\d{1,3}(?:\\/\\d{1,2})?|(?:[0-9a-fA-F]{0,4}:){2,7}[0-9a-fA-F]{0,4}(?:\\/\\d{1,3})?)(-(?:(?:\\d{1,3}\\.){3}\\d{1,3}|(?:[0-9a-fA-F]{0,4}:){2,7}[0-9a-fA-F]{0,4}))?,?)+$").matcher((CharSequence)x);
                if (!matcher.matches()) {
                    errors.add("IP range " + x + " is invalid");
                }
            });
        }
        return new ConfigValidationResult(errors.isEmpty(), ConfigValidationTools.isRestartNeeded((Object)oldBaseConfig.getAuth(), (Object)newConfig), errors, warnings);
    }

    public AuthConfig prepareForSaving(BaseConfig oldBaseConfig, AuthConfig newAuthConfig) {
        newAuthConfig.getUsers().forEach(userAuthConfig -> this.userAuthConfigValidator.prepareForSaving(oldBaseConfig, userAuthConfig));
        return new AuthConfig();
    }

    public AuthConfig updateAfterLoading(AuthConfig newAuthConfig) {
        newAuthConfig.getUsers().forEach(userAuthConfig -> this.userAuthConfigValidator.updateAfterLoading(userAuthConfig));
        return newAuthConfig;
    }
}

