/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import org.nzbhydra.config.downloading.DownloaderConfig;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class SafeDownloaderConfig {
    private String defaultCategory;
    private String downloadType;
    private boolean enabled = true;
    private String iconCssClass;
    private String name;
    private String downloaderType;

    public SafeDownloaderConfig(DownloaderConfig downloaderConfig) {
        this.defaultCategory = downloaderConfig.getDefaultCategory();
        this.downloadType = downloaderConfig.getDownloadType().name();
        this.enabled = downloaderConfig.isEnabled();
        this.iconCssClass = downloaderConfig.getIconCssClass();
        this.name = downloaderConfig.getName();
        this.downloaderType = downloaderConfig.getDownloaderType().name();
    }

    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    public String getDownloadType() {
        return this.downloadType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getIconCssClass() {
        return this.iconCssClass;
    }

    public String getName() {
        return this.name;
    }

    public String getDownloaderType() {
        return this.downloaderType;
    }

    public void setDefaultCategory(String defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    public void setDownloadType(String downloadType) {
        this.downloadType = downloadType;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIconCssClass(String iconCssClass) {
        this.iconCssClass = iconCssClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDownloaderType(String downloaderType) {
        this.downloaderType = downloaderType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SafeDownloaderConfig)) {
            return false;
        }
        SafeDownloaderConfig other = (SafeDownloaderConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$defaultCategory = this.getDefaultCategory();
        String other$defaultCategory = other.getDefaultCategory();
        if (this$defaultCategory == null ? other$defaultCategory != null : !this$defaultCategory.equals(other$defaultCategory)) {
            return false;
        }
        String this$downloadType = this.getDownloadType();
        String other$downloadType = other.getDownloadType();
        if (this$downloadType == null ? other$downloadType != null : !this$downloadType.equals(other$downloadType)) {
            return false;
        }
        String this$iconCssClass = this.getIconCssClass();
        String other$iconCssClass = other.getIconCssClass();
        if (this$iconCssClass == null ? other$iconCssClass != null : !this$iconCssClass.equals(other$iconCssClass)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$downloaderType = this.getDownloaderType();
        String other$downloaderType = other.getDownloaderType();
        return !(this$downloaderType == null ? other$downloaderType != null : !this$downloaderType.equals(other$downloaderType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SafeDownloaderConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $defaultCategory = this.getDefaultCategory();
        result = result * 59 + ($defaultCategory == null ? 43 : $defaultCategory.hashCode());
        String $downloadType = this.getDownloadType();
        result = result * 59 + ($downloadType == null ? 43 : $downloadType.hashCode());
        String $iconCssClass = this.getIconCssClass();
        result = result * 59 + ($iconCssClass == null ? 43 : $iconCssClass.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $downloaderType = this.getDownloaderType();
        result = result * 59 + ($downloaderType == null ? 43 : $downloaderType.hashCode());
        return result;
    }

    public String toString() {
        return "SafeDownloaderConfig(defaultCategory=" + this.getDefaultCategory() + ", downloadType=" + this.getDownloadType() + ", enabled=" + this.isEnabled() + ", iconCssClass=" + this.getIconCssClass() + ", name=" + this.getName() + ", downloaderType=" + this.getDownloaderType() + ")";
    }
}

