/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.auth.AuthType;
import org.nzbhydra.config.safeconfig.SafeCategoriesConfig;
import org.nzbhydra.config.safeconfig.SafeDownloadingConfig;
import org.nzbhydra.config.safeconfig.SafeEmbyConfig;
import org.nzbhydra.config.safeconfig.SafeIndexerConfig;
import org.nzbhydra.config.safeconfig.SafeLoggingConfig;
import org.nzbhydra.config.safeconfig.SafeNotificationConfig;
import org.nzbhydra.config.safeconfig.SafeSearchingConfig;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class SafeConfig {
    private SafeCategoriesConfig categoriesConfig;
    private AuthType authType;
    private String dereferer;
    private SafeSearchingConfig searching;
    private SafeDownloadingConfig downloading;
    private SafeLoggingConfig logging;
    private SafeNotificationConfig notificationConfig;
    private SafeEmbyConfig emby;
    private boolean showNews;
    private boolean keepHistory;
    private List<SafeIndexerConfig> indexers;

    public SafeConfig(BaseConfig baseConfig) {
        this.authType = baseConfig.getAuth().getAuthType();
        this.dereferer = baseConfig.getMain().getDereferer().orElse("");
        this.searching = new SafeSearchingConfig(baseConfig.getSearching());
        this.downloading = new SafeDownloadingConfig(baseConfig.getDownloading());
        this.logging = new SafeLoggingConfig(baseConfig.getMain().getLogging());
        this.indexers = baseConfig.getIndexers().stream().map(indexerConfig -> new SafeIndexerConfig(indexerConfig, baseConfig)).collect(Collectors.toList());
        this.categoriesConfig = new SafeCategoriesConfig(baseConfig.getCategoriesConfig());
        this.notificationConfig = new SafeNotificationConfig(baseConfig.getNotificationConfig());
        this.emby = new SafeEmbyConfig(baseConfig.getEmby());
        this.showNews = baseConfig.getMain().isShowNews();
        this.keepHistory = baseConfig.getMain().isKeepHistory();
    }

    public String getAuthType() {
        return this.authType.name();
    }

    public SafeCategoriesConfig getCategoriesConfig() {
        return this.categoriesConfig;
    }

    public String getDereferer() {
        return this.dereferer;
    }

    public SafeSearchingConfig getSearching() {
        return this.searching;
    }

    public SafeDownloadingConfig getDownloading() {
        return this.downloading;
    }

    public SafeLoggingConfig getLogging() {
        return this.logging;
    }

    public SafeNotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public SafeEmbyConfig getEmby() {
        return this.emby;
    }

    public boolean isShowNews() {
        return this.showNews;
    }

    public boolean isKeepHistory() {
        return this.keepHistory;
    }

    public List<SafeIndexerConfig> getIndexers() {
        return this.indexers;
    }

    public void setCategoriesConfig(SafeCategoriesConfig categoriesConfig) {
        this.categoriesConfig = categoriesConfig;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public void setDereferer(String dereferer) {
        this.dereferer = dereferer;
    }

    public void setSearching(SafeSearchingConfig searching) {
        this.searching = searching;
    }

    public void setDownloading(SafeDownloadingConfig downloading) {
        this.downloading = downloading;
    }

    public void setLogging(SafeLoggingConfig logging) {
        this.logging = logging;
    }

    public void setNotificationConfig(SafeNotificationConfig notificationConfig) {
        this.notificationConfig = notificationConfig;
    }

    public void setEmby(SafeEmbyConfig emby) {
        this.emby = emby;
    }

    public void setShowNews(boolean showNews) {
        this.showNews = showNews;
    }

    public void setKeepHistory(boolean keepHistory) {
        this.keepHistory = keepHistory;
    }

    public void setIndexers(List<SafeIndexerConfig> indexers) {
        this.indexers = indexers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SafeConfig)) {
            return false;
        }
        SafeConfig other = (SafeConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShowNews() != other.isShowNews()) {
            return false;
        }
        if (this.isKeepHistory() != other.isKeepHistory()) {
            return false;
        }
        SafeCategoriesConfig this$categoriesConfig = this.getCategoriesConfig();
        SafeCategoriesConfig other$categoriesConfig = other.getCategoriesConfig();
        if (this$categoriesConfig == null ? other$categoriesConfig != null : !this$categoriesConfig.equals(other$categoriesConfig)) {
            return false;
        }
        String this$authType = this.getAuthType();
        String other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
            return false;
        }
        String this$dereferer = this.getDereferer();
        String other$dereferer = other.getDereferer();
        if (this$dereferer == null ? other$dereferer != null : !this$dereferer.equals(other$dereferer)) {
            return false;
        }
        SafeSearchingConfig this$searching = this.getSearching();
        SafeSearchingConfig other$searching = other.getSearching();
        if (this$searching == null ? other$searching != null : !this$searching.equals(other$searching)) {
            return false;
        }
        SafeDownloadingConfig this$downloading = this.getDownloading();
        SafeDownloadingConfig other$downloading = other.getDownloading();
        if (this$downloading == null ? other$downloading != null : !this$downloading.equals(other$downloading)) {
            return false;
        }
        SafeLoggingConfig this$logging = this.getLogging();
        SafeLoggingConfig other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        SafeNotificationConfig this$notificationConfig = this.getNotificationConfig();
        SafeNotificationConfig other$notificationConfig = other.getNotificationConfig();
        if (this$notificationConfig == null ? other$notificationConfig != null : !this$notificationConfig.equals(other$notificationConfig)) {
            return false;
        }
        SafeEmbyConfig this$emby = this.getEmby();
        SafeEmbyConfig other$emby = other.getEmby();
        if (this$emby == null ? other$emby != null : !this$emby.equals(other$emby)) {
            return false;
        }
        List this$indexers = this.getIndexers();
        List other$indexers = other.getIndexers();
        return !(this$indexers == null ? other$indexers != null : !((Object)this$indexers).equals(other$indexers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SafeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowNews() ? 79 : 97);
        result = result * 59 + (this.isKeepHistory() ? 79 : 97);
        SafeCategoriesConfig $categoriesConfig = this.getCategoriesConfig();
        result = result * 59 + ($categoriesConfig == null ? 43 : $categoriesConfig.hashCode());
        String $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
        String $dereferer = this.getDereferer();
        result = result * 59 + ($dereferer == null ? 43 : $dereferer.hashCode());
        SafeSearchingConfig $searching = this.getSearching();
        result = result * 59 + ($searching == null ? 43 : $searching.hashCode());
        SafeDownloadingConfig $downloading = this.getDownloading();
        result = result * 59 + ($downloading == null ? 43 : $downloading.hashCode());
        SafeLoggingConfig $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        SafeNotificationConfig $notificationConfig = this.getNotificationConfig();
        result = result * 59 + ($notificationConfig == null ? 43 : $notificationConfig.hashCode());
        SafeEmbyConfig $emby = this.getEmby();
        result = result * 59 + ($emby == null ? 43 : $emby.hashCode());
        List $indexers = this.getIndexers();
        result = result * 59 + ($indexers == null ? 43 : ((Object)$indexers).hashCode());
        return result;
    }

    public String toString() {
        return "SafeConfig(categoriesConfig=" + String.valueOf(this.getCategoriesConfig()) + ", authType=" + this.getAuthType() + ", dereferer=" + this.getDereferer() + ", searching=" + String.valueOf(this.getSearching()) + ", downloading=" + String.valueOf(this.getDownloading()) + ", logging=" + String.valueOf(this.getLogging()) + ", notificationConfig=" + String.valueOf(this.getNotificationConfig()) + ", emby=" + String.valueOf(this.getEmby()) + ", showNews=" + this.isShowNews() + ", keepHistory=" + this.isKeepHistory() + ", indexers=" + String.valueOf(this.getIndexers()) + ")";
    }
}

