/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.config.category.CategoriesConfig;
import org.nzbhydra.config.safeconfig.SafeCategory;

public class SafeCategoriesConfig {
    private boolean enableCategorySizes = true;
    private List<SafeCategory> categories;
    private String defaultCategory = "All";

    public SafeCategoriesConfig(CategoriesConfig categoriesConfig) {
        this.categories = categoriesConfig.getCategories().stream().map(SafeCategory::new).collect(Collectors.toList());
        this.enableCategorySizes = categoriesConfig.isEnableCategorySizes();
        this.defaultCategory = categoriesConfig.getDefaultCategory();
        this.categories.add(0, new SafeCategory(CategoriesConfig.allCategory));
    }

    public boolean isEnableCategorySizes() {
        return this.enableCategorySizes;
    }

    public List<SafeCategory> getCategories() {
        return this.categories;
    }

    public String getDefaultCategory() {
        return this.defaultCategory;
    }
}

