/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.migration;

import java.util.Map;
import org.nzbhydra.config.migration.ConfigMigration;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMigrationStep016to017
implements ConfigMigrationStep {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMigration.class);

    public int forVersion() {
        return 16;
    }

    public Map<String, Object> migrate(Map<String, Object> toMigrate) {
        try {
            Map notificationConfig = (Map)toMigrate.get("notificationConfig");
            if (notificationConfig == null) {
                logger.debug("No notification config to migrate");
                return toMigrate;
            }
            if (notificationConfig.get("appriseApiUrl") != null) {
                notificationConfig.put("appriseType", "API");
            } else {
                notificationConfig.put("appriseType", "NONE");
            }
            logger.info("Setting appriseType to {}", notificationConfig.get("appriseType"));
            toMigrate.put("notificationConfig", notificationConfig);
        }
        catch (Exception e) {
            logger.error("Error while migrating config", (Throwable)e);
        }
        return toMigrate;
    }
}

