/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.migration;

import java.util.Map;
import org.nzbhydra.config.migration.ConfigMigration;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMigrationStep011to012
implements ConfigMigrationStep {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMigration.class);

    public int forVersion() {
        return 11;
    }

    public Map<String, Object> migrate(Map<String, Object> toMigrate) {
        Map searching = this.getFromMap(toMigrate, "searching");
        try {
            int keepSearchResultsForDays = (Integer)searching.get("keepSearchResultsForDays");
            if (keepSearchResultsForDays == 14) {
                logger.info("Setting keepSearchResultsForDays to 3");
                searching.put("keepSearchResultsForDays", 3);
            } else {
                logger.debug("Keeping keepSearchResultsForDays at {}", (Object)keepSearchResultsForDays);
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to reduce keepSearchResultsForDays", (Throwable)e);
        }
        try {
            Map main = this.getFromMap(toMigrate, "main");
            main.put("keepHistoryForWeeks", searching.get("keepHistoryForWeeks"));
            searching.remove("keepHistoryForWeeks");
            logger.info("Moved setting keepHistoryForWeeks from searching to main");
        }
        catch (Exception e) {
            logger.error("Error while trying to move keepHistoryForWeeks to main config", (Throwable)e);
        }
        return toMigrate;
    }
}

