/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config;

import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.BaseConfigHandler;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.ConfigReaderWriter;
import org.nzbhydra.config.ConfigWeb;
import org.nzbhydra.config.FileSystemBrowser;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.safeconfig.SafeConfig;
import org.nzbhydra.config.validation.BaseConfigValidator;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.externaltools.ExternalToolsSyncService;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.IndexerRepository;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class ConfigWeb {
    private static final Logger logger = LoggerFactory.getLogger(ConfigWeb.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private FileSystemBrowser fileSystemBrowser;
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private IndexerRepository indexerRepository;
    @Autowired
    private BaseConfigValidator baseConfigValidator;
    @Autowired
    private BaseConfigHandler baseConfigHandler;
    @Autowired
    private ExternalToolsSyncService externalToolsSyncService;
    private final ConfigReaderWriter configReaderWriter = new ConfigReaderWriter();

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/config"}, method={RequestMethod.GET}, produces={"application/json"})
    public BaseConfig getConfig(HttpSession session) throws IOException {
        BaseConfig baseConfig = this.configReaderWriter.loadSavedConfig();
        return this.baseConfigValidator.updateAfterLoading(baseConfig);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/config"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public ConfigValidationResult setConfig(@RequestBody BaseConfig newConfig) throws IOException {
        for (PropertySource source : this.environment.getPropertySources()) {
            boolean contains;
            Set<Object> propertyNames = new HashSet();
            if (source.getSource() instanceof Properties) {
                propertyNames = ((Properties)source.getSource()).stringPropertyNames();
            } else if (source.getSource() instanceof LinkedHashMap) {
                propertyNames = ((LinkedHashMap)source.getSource()).keySet();
            }
            if (!(contains = propertyNames.contains("main.externalUrl"))) continue;
            logger.info(source.toString());
        }
        logger.info("Received new config");
        BaseConfig oldConfig = this.configProvider.getBaseConfig();
        newConfig = this.baseConfigValidator.prepareForSaving(oldConfig, newConfig);
        ConfigValidationResult result = this.baseConfigValidator.validateConfig(oldConfig, newConfig, newConfig);
        if (result.isOk()) {
            this.handleRenamedIndexers(newConfig);
            Set changedIndexers = this.externalToolsSyncService.detectChangedIndexers(oldConfig.getIndexers(), newConfig.getIndexers());
            this.baseConfigHandler.replace(newConfig);
            this.baseConfigHandler.save(true);
            result.setNewConfig(this.configProvider.getBaseConfig());
            if (this.configProvider.getBaseConfig().getExternalTools().isSyncOnConfigChange() && !changedIndexers.isEmpty()) {
                logger.info("Indexers changed, syncing to external tools");
                try {
                    ExternalToolsSyncService.SyncResult syncResult = this.externalToolsSyncService.syncTools(changedIndexers);
                    logger.info("External tools sync completed: {} successful, {} failed", (Object)syncResult.getSuccessCount(), (Object)syncResult.getFailureCount());
                }
                catch (Exception e) {
                    logger.error("Error syncing to external tools", (Throwable)e);
                }
            }
        }
        return result;
    }

    private void handleRenamedIndexers(@RequestBody BaseConfig newConfig) {
        HashSet loggedSameNameAndApiKey = new HashSet();
        for (IndexerConfig newIndexer : newConfig.getIndexers()) {
            Optional<IndexerConfig> sameOldIndexer;
            boolean alreadyExistedBefore = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> x != newIndexer).anyMatch(x -> x.getName().equals(newIndexer.getName()));
            if (alreadyExistedBefore || !(sameOldIndexer = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> !x.getName().equals(newIndexer.getName())).filter(x -> IndexerConfig.isIndexerEquals((IndexerConfig)newIndexer, (IndexerConfig)x)).findFirst()).isPresent()) continue;
            logger.info("Indexer was renamed from {} to {}", (Object)sameOldIndexer.get().getName(), (Object)newIndexer.getName());
            try {
                IndexerEntity indexerEntity = this.indexerRepository.findByName(sameOldIndexer.get().getName());
                indexerEntity.setName(newIndexer.getName());
                this.indexerRepository.save(indexerEntity);
            }
            catch (Exception e) {
                logger.error("Error while renaming indexer", (Throwable)e);
            }
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/config/reload"}, method={RequestMethod.GET})
    public GenericResponse reloadConfig() throws IOException {
        logger.info("Reloading config from file");
        try {
            this.baseConfigHandler.load();
        }
        catch (IOException e) {
            return new GenericResponse(false, e.getMessage());
        }
        return GenericResponse.ok();
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/config/safe"}, method={RequestMethod.GET}, produces={"application/json"})
    public SafeConfig getSafeConfig() {
        return new SafeConfig(this.configProvider.getBaseConfig());
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/config/folderlisting"}, method={RequestMethod.POST}, produces={"application/json"})
    public FileSystemBrowser.FileSystemEntry getDirectoryListing(@RequestBody FileSystemBrowser.DirectoryListingRequest request) {
        return this.fileSystemBrowser.getDirectoryListing(request);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/config/apiHelp"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiHelpResponse getApiHelp(HttpSession session) throws IOException {
        UriComponentsBuilder requestBasedUriBuilder = this.urlCalculator.getRequestBasedUriBuilder();
        String newznabApi = requestBasedUriBuilder.cloneBuilder().toUriString();
        String torznabApi = requestBasedUriBuilder.cloneBuilder().path("/torznab").toUriString();
        String apikey = this.configProvider.getBaseConfig().getMain().getApiKey();
        return new ApiHelpResponse(newznabApi, torznabApi, apikey);
    }
}

