/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.backup;

import java.io.File;
import java.util.List;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.backup.BackupAndRestore;
import org.nzbhydra.backup.BackupEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class BackupWeb {
    @Autowired
    private BackupAndRestore backup;
    private static final Logger logger = LoggerFactory.getLogger(BackupWeb.class);

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/backup/backup"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    @Transactional
    public Object backupAndDownload() throws Exception {
        try {
            File backupFile = this.backup.backup(true);
            logger.debug("Sending contents of file {}", (Object)backupFile.getAbsolutePath());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + backupFile.getName()})).contentLength(backupFile.length()).body((Object)new FileSystemResource(backupFile));
        }
        catch (Exception e) {
            logger.error("Error while creating backup", (Throwable)e);
            return GenericResponse.notOk((String)e.getMessage());
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/backup/backuponly"}, method={RequestMethod.GET})
    @Transactional
    public GenericResponse backupOnly() throws Exception {
        try {
            this.backup.backup(true);
            return GenericResponse.ok();
        }
        catch (Exception e) {
            logger.error("Error while creating backup", (Throwable)e);
            return GenericResponse.notOk((String)e.getMessage());
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/backup/list"}, method={RequestMethod.GET})
    public List<BackupEntry> listBackups() throws Exception {
        return this.backup.getExistingBackups();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/backup/restore"}, method={RequestMethod.GET})
    public GenericResponse restore(@RequestParam String filename) throws Exception {
        return this.backup.restore(filename);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/backup/restorefile"}, method={RequestMethod.POST})
    public GenericResponse restoreFromUpload(@RequestParam(value="file") MultipartFile file) throws Exception {
        return this.backup.restoreFromFile(file.getInputStream());
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/backup/download"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public FileSystemResource getFile(@RequestParam(value="filename") String filename) throws Exception {
        FileSystemResource resource = new FileSystemResource(new File(this.backup.getBackupFolder(), filename));
        return resource;
    }
}

