/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.auth.AuthConfig;
import org.nzbhydra.config.auth.AuthType;
import org.nzbhydra.config.auth.UserAuthConfig;
import org.nzbhydra.web.BootstrappedDataTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserInfosProvider {
    @Autowired
    private ConfigProvider configProvider;

    public BootstrappedDataTO getUserInfos(Principal principal) {
        String username;
        boolean showIndexerSelection;
        boolean maySeeDetailsDl;
        boolean maySeeStats;
        boolean maySeeAdmin;
        Optional user;
        BootstrappedDataTO bootstrappedData = new BootstrappedDataTO();
        AuthConfig auth = this.configProvider.getBaseConfig().getAuth();
        boolean authConfigured = auth.getAuthType() != AuthType.NONE && !auth.getUsers().isEmpty();
        boolean adminRestricted = auth.isRestrictAdmin() && authConfigured;
        boolean statsRestricted = auth.isRestrictStats() && authConfigured;
        boolean searchRestricted = auth.isRestrictSearch() && authConfigured;
        boolean detailsDlRestricted = auth.isRestrictDetailsDl() && authConfigured;
        boolean indexerSelectionRestricted = auth.isRestrictIndexerSelection() && authConfigured;
        Optional<Object> optional = user = principal == null ? Optional.empty() : auth.getUsers().stream().filter(x -> Objects.equals(x.getUsername(), principal.getName())).findFirst();
        if (user.isPresent()) {
            maySeeAdmin = ((UserAuthConfig)user.get()).isMaySeeAdmin();
            maySeeStats = ((UserAuthConfig)user.get()).isMaySeeStats() || ((UserAuthConfig)user.get()).isMaySeeAdmin();
            maySeeDetailsDl = ((UserAuthConfig)user.get()).isMaySeeDetailsDl() || !detailsDlRestricted || maySeeAdmin;
            showIndexerSelection = ((UserAuthConfig)user.get()).isShowIndexerSelection() || !indexerSelectionRestricted || maySeeAdmin;
            username = ((UserAuthConfig)user.get()).getUsername();
        } else if (!authConfigured) {
            maySeeAdmin = true;
            maySeeStats = true;
            maySeeDetailsDl = true;
            showIndexerSelection = true;
            username = null;
        } else {
            maySeeAdmin = false;
            maySeeStats = false;
            maySeeDetailsDl = !detailsDlRestricted;
            showIndexerSelection = !indexerSelectionRestricted;
            username = null;
        }
        bootstrappedData.setAuthType(auth.getAuthType().name());
        bootstrappedData.setAuthConfigured(Boolean.valueOf(authConfigured));
        bootstrappedData.setAdminRestricted(Boolean.valueOf(adminRestricted));
        bootstrappedData.setSearchRestricted(Boolean.valueOf(searchRestricted));
        bootstrappedData.setStatsRestricted(Boolean.valueOf(statsRestricted));
        bootstrappedData.setShowIndexerSelection(Boolean.valueOf(showIndexerSelection));
        bootstrappedData.setMaySeeAdmin(Boolean.valueOf(maySeeAdmin));
        bootstrappedData.setMaySeeStats(Boolean.valueOf(maySeeStats));
        bootstrappedData.setMaySeeDetailsDl(Boolean.valueOf(maySeeDetailsDl));
        bootstrappedData.setMaySeeSearch(Boolean.valueOf(!auth.isRestrictSearch() || !authConfigured || user.isPresent()));
        bootstrappedData.setUsername(username);
        return bootstrappedData;
    }
}

