/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import jakarta.servlet.Filter;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.auth.AsyncSupportFilter;
import org.nzbhydra.auth.AuthAndAccessEventHandler;
import org.nzbhydra.auth.ForwardedForRecognizingFilter;
import org.nzbhydra.auth.HeaderAuthenticationFilter;
import org.nzbhydra.auth.HydraAnonymousAuthenticationFilter;
import org.nzbhydra.auth.HydraUserDetailsManager;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.auth.AuthType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Configuration(proxyBeanMethods=false)
@Order
@EnableWebSecurity
public class SecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfig.class);
    private static final int SECONDS_PER_DAY = 86400;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private HydraAnonymousAuthenticationFilter hydraAnonymousAuthenticationFilter;
    @Autowired
    private HydraUserDetailsManager hydraUserDetailsManager;
    @Autowired
    private AuthAndAccessEventHandler authAndAccessEventHandler;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AsyncSupportFilter asyncSupportFilter;
    private HeaderAuthenticationFilter headerAuthenticationFilter;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, AuthenticationManager authenticationManager) throws Exception {
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        boolean useCsrf = Boolean.parseBoolean(System.getProperty("main.useCsrf"));
        if (this.configProvider.getBaseConfig().getMain().isUseCsrf() && useCsrf) {
            CookieCsrfTokenRepository csrfTokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
            csrfTokenRepository.setCookieName("HYDRA-XSRF-TOKEN");
            CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
            requestHandler.setCsrfRequestAttributeName(null);
            http.csrf().csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler);
        } else {
            logger.info("CSRF is disabled");
            http.csrf().disable();
        }
        http.headers().httpStrictTransportSecurity().disable().frameOptions().disable();
        if (baseConfig.getAuth().getAuthType() == AuthType.BASIC || NzbHydra.isNativeBuild()) {
            http = (HttpSecurity)http.httpBasic().authenticationDetailsSource((AuthenticationDetailsSource)new /* Unavailable Anonymous Inner Class!! */).and();
        } else if (baseConfig.getAuth().getAuthType() == AuthType.FORM) {
            http = (HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage("/login").loginProcessingUrl("/login")).defaultSuccessUrl("/")).permitAll()).authenticationDetailsSource((AuthenticationDetailsSource)new /* Unavailable Anonymous Inner Class!! */)).and();
        }
        if (baseConfig.getAuth().isAuthConfigured() || NzbHydra.isNativeBuild()) {
            http = (HttpSecurity)((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(new String[]{"/actuator/health/ping"})).permitAll().requestMatchers(new String[]{"/internalapi/"})).authenticated().requestMatchers(new String[]{"/websocket/"})).authenticated().requestMatchers(new String[]{"/actuator/**"})).hasRole("ADMIN").requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/static/**")})).permitAll().anyRequest()).hasAnyRole(new String[]{"ADMIN", "ANONYMOUS", "USER"}).and()).logout().permitAll().logoutUrl("/logout").logoutSuccessUrl("/").deleteCookies(new String[]{"remember-me"}).invalidateHttpSession(true).clearAuthentication(true).and();
            this.enableAnonymousAccessIfConfigured(http);
            if (baseConfig.getAuth().isRememberUsers()) {
                int rememberMeValidityDays = this.configProvider.getBaseConfig().getAuth().getRememberMeValidityDays();
                if (rememberMeValidityDays == 0) {
                    rememberMeValidityDays = 1000;
                }
                http = (HttpSecurity)http.rememberMe().alwaysRemember(true).tokenValiditySeconds(rememberMeValidityDays * 86400).userDetailsService(this.userDetailsService).and();
            }
            this.headerAuthenticationFilter = new HeaderAuthenticationFilter(authenticationManager, this.hydraUserDetailsManager, this.configProvider.getBaseConfig().getAuth());
            http.addFilterAfter((Filter)this.headerAuthenticationFilter, BasicAuthenticationFilter.class);
            http.addFilterAfter((Filter)this.asyncSupportFilter, BasicAuthenticationFilter.class);
        } else {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().anyRequest()).permitAll();
        }
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.authAndAccessEventHandler);
        http.addFilterBefore((Filter)new ForwardedForRecognizingFilter(), ChannelProcessingFilter.class);
        http.addFilterAfter((Filter)new ForwardedHeaderFilter(), ForwardedForRecognizingFilter.class);
        return (SecurityFilterChain)http.build();
    }

    private void enableAnonymousAccessIfConfigured(HttpSecurity http) {
        try {
            if (!this.hydraAnonymousAuthenticationFilter.getAuthorities().isEmpty()) {
                http.anonymous().authenticationFilter((AnonymousAuthenticationFilter)this.hydraAnonymousAuthenticationFilter);
                this.hydraAnonymousAuthenticationFilter.enable();
            }
        }
        catch (Exception e) {
            logger.error("Unable to configure anonymous access", (Throwable)e);
        }
    }

    @EventListener
    public void handleNewConfig(ConfigChangedEvent configChangedEvent) {
        if (this.headerAuthenticationFilter != null) {
            this.headerAuthenticationFilter.loadNewConfig(configChangedEvent.getNewConfig().getAuth());
        }
    }

    @Bean
    public DefaultHttpFirewall defaultHttpFirewall() {
        return new DefaultHttpFirewall();
    }

    @Bean
    public AuthenticationManager authManager(HttpSecurity http) throws Exception {
        return (AuthenticationManager)((AuthenticationManagerBuilder)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).userDetailsService((UserDetailsService)this.hydraUserDetailsManager).and()).build();
    }
}

