/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import com.google.common.net.InetAddresses;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Objects;
import org.nzbhydra.auth.HydraUserDetailsManager;
import org.nzbhydra.auth.HydraWebAuthenticationDetails;
import org.nzbhydra.config.auth.AuthConfig;
import org.nzbhydra.web.SessionStorage;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class HeaderAuthenticationFilter
extends BasicAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(HeaderAuthenticationFilter.class);
    private final HydraUserDetailsManager userDetailsManager;
    private AuthConfig authConfig;
    private final String internalApiKey;

    public HeaderAuthenticationFilter(AuthenticationManager authenticationManager, HydraUserDetailsManager userDetailsManager, AuthConfig authConfig) {
        super(authenticationManager);
        this.userDetailsManager = userDetailsManager;
        this.authConfig = authConfig;
        this.internalApiKey = System.getProperty("internalApiKey");
        if (this.internalApiKey != null) {
            logger.info("Using internal API key");
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String sentInternalApiKey;
        String string = sentInternalApiKey = request.getParameterValues("internalApiKey") == null ? null : request.getParameterValues("internalApiKey")[0];
        if (sentInternalApiKey != null) {
            if (Objects.equals(sentInternalApiKey, this.internalApiKey)) {
                AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", (Object)"internalApi", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ADMIN"}));
                token.setDetails((Object)new HydraWebAuthenticationDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                this.onSuccessfulAuthentication(request, response, (Authentication)token);
                logger.debug("Authorized access to {} via internal API key", (Object)request.getRequestURI());
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            logger.warn("Invalid internal API key provided");
        }
        if (this.authConfig.getAuthHeader() == null || this.authConfig.getAuthHeaderIpRanges().isEmpty()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String header = request.getHeader(this.authConfig.getAuthHeader());
        if (header == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String ip = (String)SessionStorage.originalIp.get();
        long ipAsLong = HydraOkHttp3ClientHttpRequestFactory.ipToLong((InetAddress)InetAddresses.forString((String)ip));
        boolean isInSecureRange = this.authConfig.getAuthHeaderIpRanges().stream().anyMatch(x -> {
            if (x.equals("*")) {
                return true;
            }
            if (x.contains("/")) {
                return new IpAddressMatcher(x).matches(ip);
            }
            if (x.contains("-")) {
                String[] split = x.split("-");
                long ipLow = HydraOkHttp3ClientHttpRequestFactory.ipToLong((InetAddress)InetAddresses.forString((String)split[0]));
                long ipHigh = HydraOkHttp3ClientHttpRequestFactory.ipToLong((InetAddress)InetAddresses.forString((String)split[1]));
                return ipLow <= ipAsLong && ipAsLong <= ipHigh;
            }
            return x.equals(ip);
        });
        if (!isInSecureRange) {
            this.handleInvalidAuth(request, response, "Auth header sent in request from insecure IP " + ip);
            return;
        }
        String username = header.trim();
        try {
            UserDetails userDetails = this.userDetailsManager.loadUserByUsername(username);
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            auth.setDetails((Object)new HydraWebAuthenticationDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            this.onSuccessfulAuthentication(request, response, (Authentication)auth);
        }
        catch (UsernameNotFoundException e) {
            this.handleInvalidAuth(request, response, "Invalid username provided with auth header");
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void loadNewConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    private void handleInvalidAuth(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        SecurityContextHolder.clearContext();
        BadCredentialsException badCredentialsException = new BadCredentialsException(msg);
        this.onUnsuccessfulAuthentication(request, response, (AuthenticationException)badCredentialsException);
        response.sendError(401, msg);
        logger.warn(msg);
    }
}

