/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilder;
import org.nzbhydra.mapping.newznab.NewznabResponse;
import org.nzbhydra.mapping.newznab.xml.NewznabAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlChannel;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlEnclosure;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlGuid;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlItem;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlResponse;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewznabXmlTransformer {
    private static final String APPLICATION_TYPE_NZB = "application/x-nzb";
    private static final String APPLICATION_TYPE_TORRENT = "application/x-bittorrent";
    @Autowired
    protected FileHandler nzbHandler;
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    private DownloadUrlBuilder downloadUrlBuilder;

    NewznabXmlRoot getRssRoot(List<SearchResultItem> searchResultItems, Integer offset, int total, boolean isNzb) {
        NewznabXmlRoot rssRoot = new NewznabXmlRoot();
        NewznabXmlChannel rssChannel = new NewznabXmlChannel();
        rssChannel.setTitle("NZBHydra 2");
        rssChannel.setLink("https://www.github.com/theotherp/nzbhydra2");
        rssChannel.setWebMaster("theotherp@posteo.net");
        if (isNzb) {
            rssChannel.setNewznabResponse(new NewznabXmlResponse(Integer.valueOf(offset == null ? 0 : offset), Integer.valueOf(total)));
            rssRoot.setSearchType(NewznabResponse.SearchType.NEWZNAB);
        } else {
            rssRoot.setSearchType(NewznabResponse.SearchType.TORZNAB);
        }
        rssChannel.setGenerator("NZBHydra2");
        rssRoot.setRssChannel(rssChannel);
        ArrayList<NewznabXmlItem> items = new ArrayList<NewznabXmlItem>();
        for (SearchResultItem searchResultItem : searchResultItems) {
            NewznabXmlItem rssItem = this.buildRssItem(searchResultItem, isNzb);
            items.add(rssItem);
        }
        rssChannel.setItems(items);
        return rssRoot;
    }

    NewznabXmlItem buildRssItem(SearchResultItem searchResultItem, boolean isNzb) {
        String resultType;
        NewznabXmlItem rssItem = new NewznabXmlItem();
        String link = this.downloadUrlBuilder.getDownloadLinkForResults(searchResultItem.getSearchResultId(), false, isNzb ? DownloadType.NZB : DownloadType.TORRENT);
        rssItem.setLink(link);
        rssItem.setTitle(searchResultItem.getTitle());
        rssItem.setRssGuid(new NewznabXmlGuid(String.valueOf(searchResultItem.getGuid()), false));
        rssItem.setSize(searchResultItem.getSize());
        if (searchResultItem.getPubDate() != null) {
            rssItem.setPubDate(searchResultItem.getPubDate());
        } else {
            rssItem.setPubDate(searchResultItem.getBestDate());
        }
        searchResultItem.getAttributes().put("guid", String.valueOf(searchResultItem.getSearchResultId()));
        List newznabAttributes = searchResultItem.getAttributes().entrySet().stream().map(attribute -> new NewznabAttribute((String)attribute.getKey(), (String)attribute.getValue())).sorted(Comparator.comparing(NewznabAttribute::getName)).collect(Collectors.toList());
        if (searchResultItem.getIndexer() != null) {
            newznabAttributes.add(new NewznabAttribute("hydraIndexerScore", String.valueOf(searchResultItem.getIndexer().getConfig().getScore())));
            newznabAttributes.add(new NewznabAttribute("hydraIndexerHost", this.getIndexerHost(searchResultItem)));
            newznabAttributes.add(new NewznabAttribute("hydraIndexerName", String.valueOf(searchResultItem.getIndexer().getName())));
        }
        if (isNzb) {
            rssItem.setNewznabAttributes(newznabAttributes);
            resultType = APPLICATION_TYPE_NZB;
        } else {
            rssItem.setTorznabAttributes(newznabAttributes);
            resultType = APPLICATION_TYPE_TORRENT;
        }
        rssItem.setEnclosure(new NewznabXmlEnclosure(link, searchResultItem.getSize(), resultType));
        rssItem.setComments(searchResultItem.getCommentsLink());
        rssItem.setDescription(searchResultItem.getDescription());
        rssItem.setCategory(this.configProvider.getBaseConfig().getSearching().isUseOriginalCategories() ? searchResultItem.getOriginalCategory() : searchResultItem.getCategory().getName());
        return rssItem;
    }

    private String getIndexerHost(SearchResultItem searchResultItem) {
        try {
            return String.valueOf(new URI(searchResultItem.getIndexer().getConfig().getHost()).getHost());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

