/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.api;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.catalina.connector.ClientAbortException;
import org.nzbhydra.api.CapsGenerator;
import org.nzbhydra.api.ExternalApi;
import org.nzbhydra.api.ExternalApiException;
import org.nzbhydra.api.MissingParameterException;
import org.nzbhydra.api.MockSearch;
import org.nzbhydra.api.NewznabJsonTransformer;
import org.nzbhydra.api.NewznabXmlTransformer;
import org.nzbhydra.api.UnknownErrorException;
import org.nzbhydra.api.WrongApiKeyException;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.category.CategoriesConfig;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.downloading.DownloadResult;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.InvalidSearchResultIdException;
import org.nzbhydra.indexers.DetailsResult;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.mapping.newznab.ActionAttribute;
import org.nzbhydra.mapping.newznab.NewznabParameters;
import org.nzbhydra.mapping.newznab.NewznabResponse;
import org.nzbhydra.mapping.newznab.OutputType;
import org.nzbhydra.mapping.newznab.json.NewznabJsonError;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlError;
import org.nzbhydra.mediainfo.Imdb;
import org.nzbhydra.searching.CategoryProvider;
import org.nzbhydra.searching.CustomQueryAndTitleMappingHandler;
import org.nzbhydra.searching.DetailsProvider;
import org.nzbhydra.searching.SearchResult;
import org.nzbhydra.searching.Searcher;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.nzbhydra.searching.searchrequests.SearchRequestFactory;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExternalApi {
    private static final int MAX_CACHE_SIZE = 5;
    private static final int MAX_CACHE_AGE_HOURS = 24;
    private static final Logger logger = LoggerFactory.getLogger(ExternalApi.class);
    @Value(value="${nzbhydra.dev.noApiKey:false}")
    private final boolean noApiKeyNeeded = false;
    @Autowired
    protected Searcher searcher;
    @Autowired
    protected SearchRequestFactory searchRequestFactory;
    @Autowired
    protected FileHandler fileHandler;
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    private NewznabXmlTransformer newznabXmlTransformer;
    @Autowired
    private NewznabJsonTransformer newznabJsonTransformer;
    @Autowired
    private CategoryProvider categoryProvider;
    @Autowired
    private CapsGenerator capsGenerator;
    @Autowired
    private MockSearch mockSearch;
    @Autowired
    private CustomQueryAndTitleMappingHandler customQueryAndTitleMappingHandler;
    protected Clock clock = Clock.systemUTC();
    private final Random random = new Random();
    private final ConcurrentMap<Integer, CacheEntryValue> cache = new ConcurrentHashMap();
    private static boolean inMockingMode;
    @Autowired
    private DetailsProvider detailsProvider;

    @RequestMapping(value={"/api", "/rss", "/torznab/api", "/torznab/api/{indexerName}", "/api/{indexerName}"}, consumes={"*/*"})
    public ResponseEntity<? extends Object> api(NewznabParameters params, @PathVariable(value="indexerName", required=false) String indexerName, @PathVariable(value="mock", required=false) String mock) throws Exception {
        int searchRequestId = this.random.nextInt(100000);
        if (params.getT() != null && params.getT().isSearch()) {
            MDC.put((String)"SEARCH", (String)String.valueOf(searchRequestId));
        }
        SessionStorage.outputType.set(params.getO());
        NewznabResponse.SearchType searchType = this.getSearchType();
        logger.info("Received external {} API call: {}", (Object)searchType.name().toLowerCase(), (Object)params);
        if (!Objects.equals(params.getApikey(), this.configProvider.getBaseConfig().getMain().getApiKey())) {
            logger.error("Received API call with wrong API key");
            throw new WrongApiKeyException("Wrong api key");
        }
        if (!params.getIndexers().isEmpty() && indexerName != null) {
            logger.error("Received call with parameters set in path and request variables");
            NewznabXmlError error = new NewznabXmlError("200", "Received call with parameters set in path and request variables");
            return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.OK);
        }
        if (indexerName != null) {
            if (indexerName.equals("api")) {
                logger.warn("The URL to access the NZBHydra API is very likely wrong. Make sure that it does not end with /api");
            } else {
                params.setIndexers((Set)Sets.newHashSet((Object[])new String[]{indexerName}));
                logger.info("Setting selected indexer {} from path variable", (Object)indexerName);
            }
        }
        if (params.getT() == ActionAttribute.CAPS) {
            return this.capsGenerator.getCaps(params.getO(), searchType);
        }
        if (params.getT() == ActionAttribute.DETAILS) {
            Object response;
            DetailsResult details = this.detailsProvider.getDetails(Long.valueOf(params.getId()).longValue());
            List<SearchResultItem> searchResultItems = Collections.singletonList(details.getSearchResultItem());
            if (details.isSuccessful()) {
                boolean isNzb;
                boolean bl = isNzb = details.getSearchResultItem().getDownloadType() == DownloadType.NZB;
                response = params.getO() == OutputType.JSON ? this.newznabJsonTransformer.transformToRoot(searchResultItems, Integer.valueOf(0), 0, isNzb) : this.newznabXmlTransformer.getRssRoot(searchResultItems, Integer.valueOf(0), 0, isNzb);
            } else {
                response = params.getO() == OutputType.JSON ? new NewznabJsonError("100", details.getErrorMessage()) : new NewznabXmlError("100", details.getErrorMessage());
            }
            return new ResponseEntity(response, null, (HttpStatusCode)HttpStatus.OK);
        }
        if (Stream.of(ActionAttribute.SEARCH, ActionAttribute.BOOK, ActionAttribute.TVSEARCH, ActionAttribute.MOVIE).anyMatch(x -> x == params.getT())) {
            if (inMockingMode) {
                logger.debug("Will mock results for this request");
                return new ResponseEntity((Object)this.mockSearch.mockSearch(params, this.getSearchType() == NewznabResponse.SearchType.NEWZNAB), (HttpStatusCode)HttpStatus.OK);
            }
            if (params.getCachetime() != null || this.configProvider.getBaseConfig().getSearching().getGlobalCacheTimeMinutes().isPresent()) {
                return this.handleCachingSearch(params, searchType, searchRequestId);
            }
            NewznabResponse searchResult = this.search(params, searchRequestId);
            HttpHeaders httpHeaders = this.setSearchTypeAndGetHeaders(params, searchResult);
            return new ResponseEntity((Object)searchResult, (MultiValueMap)httpHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        if (params.getT() == ActionAttribute.GET) {
            return this.getNzb(params);
        }
        logger.error("Incorrect API request: {}", (Object)params);
        NewznabXmlError error = new NewznabXmlError("200", "Unknown or incorrect parameter");
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.OK);
    }

    public static void setInMockingMode(boolean newValue) {
        inMockingMode = newValue;
    }

    private HttpHeaders setSearchTypeAndGetHeaders(NewznabParameters params, NewznabResponse newznabResponse) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Content-Type", newznabResponse.getContentHeader());
        if (params.getO() != OutputType.JSON && newznabResponse.getSearchType() == null) {
            newznabResponse.setSearchType(this.getSearchType());
        }
        return httpHeaders;
    }

    protected ResponseEntity<?> handleCachingSearch(NewznabParameters params, NewznabResponse.SearchType searchType, int searchRequestId) {
        this.cache.entrySet().removeIf(x -> ((CacheEntryValue)x.getValue()).getLastUpdate().isBefore(this.clock.instant().minus(24L, ChronoUnit.HOURS)));
        int cacheKey = params.cacheKey(searchType);
        if (this.cache.containsKey(cacheKey)) {
            CacheEntryValue cacheEntryValue = (CacheEntryValue)this.cache.get(cacheKey);
            int cachetime = params.getCachetime() == null ? (Integer)this.configProvider.getBaseConfig().getSearching().getGlobalCacheTimeMinutes().get() : params.getCachetime();
            if (cacheEntryValue.getLastUpdate().isAfter(this.clock.instant().minus(cachetime, ChronoUnit.MINUTES))) {
                Instant nextUpdate = cacheEntryValue.getLastUpdate().plus((long)cachetime, ChronoUnit.MINUTES);
                logger.info("Returning cached search result. Next update of search will be done at {}", (Object)LocalDateTime.ofInstant(nextUpdate, ZoneId.systemDefault()));
                NewznabResponse searchResult = cacheEntryValue.getSearchResult();
                HttpHeaders httpHeaders = this.setSearchTypeAndGetHeaders(params, searchResult);
                return new ResponseEntity((Object)searchResult, (MultiValueMap)httpHeaders, (HttpStatusCode)HttpStatus.OK);
            }
            logger.info("Updating search because cache time is exceeded");
        }
        if (this.cache.size() == 5) {
            Optional<Map.Entry> keyToEvict = this.cache.entrySet().stream().min(Comparator.comparing(o -> ((CacheEntryValue)o.getValue()).getLastUpdate()));
            logger.info("Removing oldest entry from cache because its limit of {} is reached", (Object)5);
            keyToEvict.ifPresent(newznabParametersCacheEntryValueEntry -> this.cache.remove(newznabParametersCacheEntryValueEntry.getKey()));
        }
        NewznabResponse searchResult = this.search(params, searchRequestId);
        logger.info("Putting search result into cache");
        this.cache.put(cacheKey, new CacheEntryValue(params, this.clock.instant(), searchResult));
        HttpHeaders httpHeaders = this.setSearchTypeAndGetHeaders(params, searchResult);
        return new ResponseEntity((Object)searchResult, (MultiValueMap)httpHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    protected ResponseEntity<?> getNzb(NewznabParameters params) throws MissingParameterException, UnknownErrorException {
        DownloadResult downloadResult;
        if (Strings.isNullOrEmpty((String)params.getId())) {
            throw new MissingParameterException("Missing ID/GUID");
        }
        try {
            logger.debug("Download request for GUID {}", (Object)params.getId());
            downloadResult = this.fileHandler.getFileByGuid(Long.parseLong(params.getId()), SearchSource.API);
        }
        catch (InvalidSearchResultIdException e) {
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_XML).body((Object)"<error code=\"300\" description=\"Invalid or outdated search result ID\"/>");
        }
        if (!downloadResult.isSuccessful()) {
            throw new UnknownErrorException(downloadResult.getError());
        }
        return downloadResult.getAsResponseEntity();
    }

    protected NewznabResponse search(NewznabParameters params, int searchRequestId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        SearchRequest searchRequest = this.buildBaseSearchRequest(params, searchRequestId);
        if (this.getSearchType() == NewznabResponse.SearchType.TORZNAB) {
            searchRequest.setDownloadType(DownloadType.TORRENT);
        } else {
            searchRequest.setDownloadType(DownloadType.NZB);
        }
        SearchResult searchResult = this.searcher.search(searchRequest);
        NewznabResponse transformedResults = this.transformResults(searchResult, params, searchRequest);
        logger.info("Search took {}ms. Returning {} results", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)searchResult.getSearchResultItems().size());
        return transformedResults;
    }

    private NewznabResponse.SearchType getSearchType() {
        boolean torznab = SessionStorage.requestUrl.get() != null && ((String)SessionStorage.requestUrl.get()).toLowerCase().contains("/torznab");
        return torznab ? NewznabResponse.SearchType.TORZNAB : NewznabResponse.SearchType.NEWZNAB;
    }

    @ExceptionHandler(value={ExternalApiException.class})
    public NewznabXmlError handler(ExternalApiException e) {
        NewznabXmlError error = new NewznabXmlError(e.getStatusCode(), e.getMessage());
        return error;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity handleUnexpectedError(Exception e) {
        if (e instanceof ClientAbortException || Throwables.getCausalChain((Throwable)e).stream().anyMatch(x -> x instanceof ClientAbortException)) {
            logger.warn("Calling tool closed the connection before getting the results");
            return null;
        }
        try {
            logger.error("Unexpected error while handling API request", (Throwable)e);
            if (this.configProvider.getBaseConfig().getSearching().isWrapApiErrors()) {
                logger.debug("Wrapping error in empty search result");
                return ResponseEntity.status((int)200).body((Object)this.newznabXmlTransformer.getRssRoot(Collections.emptyList(), Integer.valueOf(0), 0, false));
            }
            NewznabXmlError error = new NewznabXmlError("900", e.getMessage());
            return ResponseEntity.status((int)200).body((Object)error);
        }
        catch (Exception e1) {
            return ResponseEntity.status((int)200).body((Object)("<error code=\"900\" description=\"" + e.getMessage() + "\""));
        }
    }

    protected NewznabResponse transformResults(SearchResult searchResult, NewznabParameters params, SearchRequest searchRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int total = searchResult.getNumberOfTotalAvailableResults() - searchResult.getNumberOfRejectedResults() - searchResult.getNumberOfRemovedDuplicates();
        Object response = params.getO() == OutputType.JSON ? this.newznabJsonTransformer.transformToRoot(searchResult.getSearchResultItems(), params.getOffset(), total, searchRequest.getDownloadType() == DownloadType.NZB) : this.newznabXmlTransformer.getRssRoot(searchResult.getSearchResultItems(), params.getOffset(), total, searchRequest.getDownloadType() == DownloadType.NZB);
        logger.debug(LoggingMarkers.PERFORMANCE, "Transforming results took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return response;
    }

    private SearchRequest buildBaseSearchRequest(NewznabParameters params, int searchRequestId) {
        SearchType searchType = SearchType.valueOf((String)params.getT().name());
        SearchRequest searchRequest = this.searchRequestFactory.getSearchRequest(searchType, SearchSource.API, this.categoryProvider.fromSearchNewznabCategories(params.getCat(), CategoriesConfig.allCategory), (long)searchRequestId, params.getOffset(), params.getLimit());
        logger.info("Executing new search");
        searchRequest.setQuery(params.getQ());
        searchRequest.setLimit(params.getLimit().intValue());
        searchRequest.setOffset(params.getOffset().intValue());
        searchRequest.setMinage(params.getMinage());
        searchRequest.setMaxage(params.getMaxage());
        searchRequest.setMinsize(params.getMinsize());
        searchRequest.setMaxsize(params.getMaxsize());
        searchRequest.setAuthor(params.getAuthor());
        searchRequest.setTitle(params.getTitle());
        searchRequest.setSeason(params.getSeason());
        searchRequest.setEpisode(params.getEp());
        if (params.getIndexers() != null && !params.getIndexers().isEmpty()) {
            searchRequest.setIndexers(params.getIndexers());
        }
        if (params.getCat() != null) {
            searchRequest.getInternalData().setNewznabCategories(params.getCat());
        }
        if (!Strings.isNullOrEmpty((String)params.getTvdbid())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVDB, params.getTvdbid());
        }
        if (!Strings.isNullOrEmpty((String)params.getTvmazeid())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVMAZE, params.getTvmazeid());
        }
        if (!Strings.isNullOrEmpty((String)params.getRid())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVRAGE, params.getRid());
        }
        if (!Strings.isNullOrEmpty((String)params.getImdbid()) && searchType == SearchType.MOVIE) {
            searchRequest.getIdentifiers().put(MediaIdType.IMDB, Imdb.withTt((String)params.getImdbid()));
        }
        if (!Strings.isNullOrEmpty((String)params.getImdbid()) && searchType == SearchType.TVSEARCH) {
            searchRequest.getIdentifiers().put(MediaIdType.TVIMDB, Imdb.withTt((String)params.getImdbid()));
        }
        if (!Strings.isNullOrEmpty((String)params.getTmdbid())) {
            searchRequest.getIdentifiers().put(MediaIdType.TMDB, params.getTmdbid());
        }
        if (params.getPassword() != null && params.getPassword() == 1) {
            searchRequest.getInternalData().setIncludePasswords(true);
        }
        searchRequest = this.searchRequestFactory.extendWithSavedIdentifiers(searchRequest);
        searchRequest = this.customQueryAndTitleMappingHandler.mapSearchRequest(searchRequest);
        return searchRequest;
    }
}

