/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.coyote.AbstractProtocol;
import org.commonmark.renderer.html.HtmlRenderer;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.nzbhydra.springnative.ReflectionMarker;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public class NativeHints
implements RuntimeHintsRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(NativeHints.class);

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        logger.info("Registering native hints");
        hints.resources().registerResourceBundle("joptsimple.ExceptionMessages");
        hints.resources().registerResourceBundle("org.apache.xerces.impl.msg.XMLMessages");
        Set classes = NativeHints.getClassesToRegister();
        classes.add(HashSet.class);
        classes.add(ArrayList.class);
        classes.add(HtmlRenderer.class);
        logger.info("Registering {} classes", (Object)classes.size());
        for (Object clazz : classes) {
            hints.reflection().registerType((Class)clazz, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
            for (Method method : ((Class)clazz).getDeclaredMethods()) {
                hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
            }
        }
        Set staticResources = NativeHints.getStaticResources();
        logger.info("Loading {} static resources", (Object)staticResources.size());
        for (String staticResource : staticResources) {
            try {
                InputStream resourceAsStream = this.getClass().getResourceAsStream(staticResource);
                if (resourceAsStream == null) continue;
                resourceAsStream.close();
            }
            catch (IOException e) {
                logger.error("Error loading resource " + staticResource, (Throwable)e);
            }
        }
        try {
            hints.reflection().registerMethod(MetricsEndpoint.class.getMethod("metric", String.class, List.class), ExecutableMode.INVOKE);
            hints.reflection().registerMethod(MetricsEndpoint.MetricDescriptor.class.getMethod("getMeasurements", new Class[0]), ExecutableMode.INVOKE);
            hints.reflection().registerMethod(ThreadDumpEndpoint.class.getMethod("textThreadDump", new Class[0]), ExecutableMode.INVOKE);
            hints.reflection().registerMethod(AbstractProtocol.class.getMethod("getName", new Class[0]), ExecutableMode.INVOKE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<Class<?>> getClassesToRegister() {
        Reflections reflections = new Reflections("org.nzbhydra", new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes});
        Set classes = reflections.getTypesAnnotatedWith(ReflectionMarker.class);
        classes.addAll(reflections.getSubTypesOf(ConfigMigrationStep.class));
        return classes;
    }

    private static Set<String> getStaticResources() {
        HashSet<String> staticResources = new HashSet<String>();
        try {
            Path path = new PathMatchingResourcePatternResolver().getResource("/").getFile().toPath();
            for (Resource staticResource : new PathMatchingResourcePatternResolver().getResources("static/**")) {
                File staticResourceFile = staticResource.getFile();
                String relativePath = path.relativize(staticResourceFile.toPath()).toString();
                staticResources.add(relativePath);
            }
        }
        catch (IOException e) {
            logger.error("Error getting static resources", (Throwable)e);
        }
        return staticResources;
    }

    public static void main(String[] args) throws Exception {
        Resource[] staticResources = new PathMatchingResourcePatternResolver().getResources("static/**");
        Path path = new PathMatchingResourcePatternResolver().getResource("/").getFile().toPath();
        for (Resource staticResource : staticResources) {
            File staticResourceFile = staticResource.getFile();
            String relativePath = path.relativize(staticResourceFile.toPath()).toString();
            System.out.println();
        }
    }
}

