"""'Add label notifier CRUD bools'

Revision ID: e6bb583aac2d
Revises: d7b3ce6fa31a
Create Date: 2025-08-09 19:32:37.285172

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "e6bb583aac2d"
down_revision: str | None = "d7b3ce6fa31a"
branch_labels: str | tuple[str, ...] | None = None
depends_on: str | tuple[str, ...] | None = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("group_events_notifier_options", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "label_created", sa.Boolean(), nullable=False, default=False, server_default=sa.sql.expression.false()
            )
        )
        batch_op.add_column(
            sa.Column(
                "label_updated", sa.Boolean(), nullable=False, default=False, server_default=sa.sql.expression.false()
            )
        )
        batch_op.add_column(
            sa.Column(
                "label_deleted", sa.Boolean(), nullable=False, default=False, server_default=sa.sql.expression.false()
            )
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("group_events_notifier_options", schema=None) as batch_op:
        batch_op.drop_column("label_deleted")
        batch_op.drop_column("label_updated")
        batch_op.drop_column("label_created")

    # ### end Alembic commands ###
