"""add tags to cookbooks

Revision ID: 59eb59135381
Revises: f1a2dbee5fe9
Create Date: 2022-03-31 19:19:55.428965

"""

import sqlalchemy as sa

import mealie.db.migration_types
from alembic import op

# revision identifiers, used by Alembic.
revision = "59eb59135381"
down_revision = "f1a2dbee5fe9"
branch_labels: str | tuple[str, ...] | None = None
depends_on: str | tuple[str, ...] | None = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "cookbooks_to_tags",
        sa.Column("cookbook_id", mealie.db.migration_types.GUID(), nullable=True),
        sa.Column("tag_id", mealie.db.migration_types.GUID(), nullable=True),
        sa.ForeignKeyConstraint(
            ["cookbook_id"],
            ["cookbooks.id"],
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tags.id"],
        ),
    )
    op.create_table(
        "cookbooks_to_tools",
        sa.Column("cookbook_id", mealie.db.migration_types.GUID(), nullable=True),
        sa.Column("tool_id", mealie.db.migration_types.GUID(), nullable=True),
        sa.ForeignKeyConstraint(
            ["cookbook_id"],
            ["cookbooks.id"],
        ),
        sa.ForeignKeyConstraint(
            ["tool_id"],
            ["tools.id"],
        ),
    )
    op.add_column("cookbooks", sa.Column("public", sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("cookbooks", "public")
    op.drop_table("cookbooks_to_tools")
    op.drop_table("cookbooks_to_tags")
    # ### end Alembic commands ###
