"""convert quantity from integer to float

Revision ID: 263dd6707191
Revises: 6b0f5f32d602
Create Date: 2022-03-23 17:43:34.727829

"""

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision = "263dd6707191"
down_revision = "6b0f5f32d602"
branch_labels: str | tuple[str, ...] | None = None
depends_on: str | tuple[str, ...] | None = None


def is_postgres():
    return op.get_context().dialect.name == "postgresql"


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    # SQLite doesn't require migration as types are not enforced.
    # Postgres Specific Migration
    if is_postgres():
        op.alter_column(
            "recipes_ingredients",
            "quantity",
            type_=sa.Float(),
            existing_type=sa.Integer(),
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    # SQLite doesn't require migration as types are not enforced.
    # Postgres Specific Migration
    if is_postgres():
        op.alter_column(
            "recipes_ingredients",
            "quantity",
            type_=sa.Integer(),
            existing_type=sa.Float(),
        )

    # ### end Alembic commands ###
