/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.DurationConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.scene.control.skin.TooltipSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Window;
import javafx.util.Duration;

@IDProperty(value="id")
public class Tooltip
extends PopupControl {
    private static String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    private static int TOOLTIP_XOFFSET = 10;
    private static int TOOLTIP_YOFFSET = 7;
    private static TooltipBehavior BEHAVIOR = new TooltipBehavior(false);
    private final StringProperty text = new SimpleStringProperty(this, "text", ""){

        @Override
        protected void invalidated() {
            super.invalidated();
            String value = this.get();
            if (Tooltip.this.isShowing() && value != null && !value.equals(Tooltip.this.getText())) {
                Tooltip.this.setAnchorX(BEHAVIOR.lastMouseX);
                Tooltip.this.setAnchorY(BEHAVIOR.lastMouseY);
            }
        }
    };
    private final ObjectProperty<TextAlignment> textAlignment = new SimpleStyleableObjectProperty<TextAlignment>(TEXT_ALIGNMENT, this, "textAlignment", TextAlignment.LEFT);
    private final ObjectProperty<OverrunStyle> textOverrun = new SimpleStyleableObjectProperty<OverrunStyle>(TEXT_OVERRUN, this, "textOverrun", OverrunStyle.ELLIPSIS);
    private final BooleanProperty wrapText = new SimpleStyleableBooleanProperty(WRAP_TEXT, this, "wrapText", false);
    private final ObjectProperty<Font> font = new StyleableObjectProperty<Font>(Font.getDefault()){
        private boolean fontSetByCss;
        {
            this.fontSetByCss = false;
        }

        @Override
        public void applyStyle(StyleOrigin newOrigin, Font value) {
            try {
                this.fontSetByCss = true;
                super.applyStyle(newOrigin, value);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.fontSetByCss = false;
            }
        }

        @Override
        public void set(Font value) {
            Font oldValue = (Font)this.get();
            StyleOrigin origin = ((StyleableObjectProperty)Tooltip.this.font).getStyleOrigin();
            if (origin == null || (value != null ? !value.equals(oldValue) : oldValue != null)) {
                super.set(value);
            }
        }

        @Override
        protected void invalidated() {
            if (!this.fontSetByCss) {
                Tooltip.this.bridge.impl_reapplyCSS();
            }
        }

        @Override
        public CssMetaData<CSSBridge, Font> getCssMetaData() {
            return FONT;
        }

        @Override
        public Object getBean() {
            return Tooltip.this;
        }

        @Override
        public String getName() {
            return "font";
        }
    };
    private final ObjectProperty<Duration> showDelayProperty = new SimpleStyleableObjectProperty<Duration>(SHOW_DELAY, this, "showDelay", new Duration(1000.0));
    private final ObjectProperty<Duration> showDurationProperty = new SimpleStyleableObjectProperty<Duration>(SHOW_DURATION, this, "showDuration", new Duration(5000.0));
    private final ObjectProperty<Duration> hideDelayProperty = new SimpleStyleableObjectProperty<Duration>(HIDE_DELAY, this, "hideDelay", new Duration(200.0));
    private final ObjectProperty<Node> graphic = new StyleableObjectProperty<Node>(){

        @Override
        public CssMetaData getCssMetaData() {
            return GRAPHIC;
        }

        @Override
        public Object getBean() {
            return Tooltip.this;
        }

        @Override
        public String getName() {
            return "graphic";
        }
    };
    private StyleableStringProperty imageUrl = null;
    private final ObjectProperty<ContentDisplay> contentDisplay = new SimpleStyleableObjectProperty<ContentDisplay>(CONTENT_DISPLAY, this, "contentDisplay", ContentDisplay.LEFT);
    private final DoubleProperty graphicTextGap = new SimpleStyleableDoubleProperty(GRAPHIC_TEXT_GAP, this, "graphicTextGap", 4.0);
    private final ReadOnlyBooleanWrapper activated = new ReadOnlyBooleanWrapper(this, "activated");
    private static final CssMetaData<CSSBridge, Font> FONT = new FontCssMetaData<CSSBridge>("-fx-font", Font.getDefault()){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.fontProperty().isBound();
        }

        @Override
        public StyleableProperty<Font> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.fontProperty());
        }
    };
    private static final CssMetaData<CSSBridge, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<CSSBridge, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.textAlignmentProperty().isBound();
        }

        @Override
        public StyleableProperty<TextAlignment> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.textAlignmentProperty());
        }
    };
    private static final CssMetaData<CSSBridge, OverrunStyle> TEXT_OVERRUN = new CssMetaData<CSSBridge, OverrunStyle>("-fx-text-overrun", new EnumConverter<OverrunStyle>(OverrunStyle.class), OverrunStyle.ELLIPSIS){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.textOverrunProperty().isBound();
        }

        @Override
        public StyleableProperty<OverrunStyle> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.textOverrunProperty());
        }
    };
    private static final CssMetaData<CSSBridge, Boolean> WRAP_TEXT = new CssMetaData<CSSBridge, Boolean>("-fx-wrap-text", BooleanConverter.getInstance(), Boolean.FALSE){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.wrapTextProperty().isBound();
        }

        @Override
        public StyleableProperty<Boolean> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.wrapTextProperty());
        }
    };
    private static final CssMetaData<CSSBridge, String> GRAPHIC = new CssMetaData<CSSBridge, String>("-fx-graphic", StringConverter.getInstance()){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.graphicProperty().isBound();
        }

        @Override
        public StyleableProperty<String> getStyleableProperty(CSSBridge cssBridge) {
            return cssBridge.tooltip.imageUrlProperty();
        }
    };
    private static final CssMetaData<CSSBridge, ContentDisplay> CONTENT_DISPLAY = new CssMetaData<CSSBridge, ContentDisplay>("-fx-content-display", new EnumConverter<ContentDisplay>(ContentDisplay.class), ContentDisplay.LEFT){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.contentDisplayProperty().isBound();
        }

        @Override
        public StyleableProperty<ContentDisplay> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.contentDisplayProperty());
        }
    };
    private static final CssMetaData<CSSBridge, Number> GRAPHIC_TEXT_GAP = new CssMetaData<CSSBridge, Number>("-fx-graphic-text-gap", SizeConverter.getInstance(), (Number)4.0){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.graphicTextGapProperty().isBound();
        }

        @Override
        public StyleableProperty<Number> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.graphicTextGapProperty());
        }
    };
    private static final CssMetaData<CSSBridge, Duration> SHOW_DELAY = new CssMetaData<CSSBridge, Duration>("-fx-show-delay", DurationConverter.getInstance(), new Duration(1000.0)){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.showDelayProperty().isBound();
        }

        @Override
        public StyleableProperty<Duration> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.showDelayProperty());
        }
    };
    private static final CssMetaData<CSSBridge, Duration> SHOW_DURATION = new CssMetaData<CSSBridge, Duration>("-fx-show-duration", DurationConverter.getInstance(), new Duration(5000.0)){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.showDurationProperty().isBound();
        }

        @Override
        public StyleableProperty<Duration> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.showDurationProperty());
        }
    };
    private static final CssMetaData<CSSBridge, Duration> HIDE_DELAY = new CssMetaData<CSSBridge, Duration>("-fx-hide-delay", DurationConverter.getInstance(), new Duration(200.0)){

        @Override
        public boolean isSettable(CSSBridge cssBridge) {
            return !cssBridge.tooltip.hideDelayProperty().isBound();
        }

        @Override
        public StyleableProperty<Duration> getStyleableProperty(CSSBridge cssBridge) {
            return (StyleableProperty)((Object)cssBridge.tooltip.hideDelayProperty());
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public static void install(Node node, Tooltip t) {
        Tooltip.BEHAVIOR.install(node, t);
    }

    public static void uninstall(Node node, Tooltip t) {
        Tooltip.BEHAVIOR.uninstall(node);
    }

    public Tooltip() {
        this(null);
    }

    public Tooltip(String text) {
        if (text != null) {
            this.setText(text);
        }
        this.bridge = new CSSBridge();
        this.getContent().setAll((Node[])new Node[]{this.bridge});
        this.getStyleClass().setAll((String[])new String[]{"tooltip"});
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String value) {
        this.textProperty().setValue(value);
    }

    public final String getText() {
        return this.text.getValue() == null ? "" : this.text.getValue();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment value) {
        this.textAlignmentProperty().setValue(value);
    }

    public final TextAlignment getTextAlignment() {
        return (TextAlignment)((Object)this.textAlignmentProperty().getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle value) {
        this.textOverrunProperty().setValue(value);
    }

    public final OverrunStyle getTextOverrun() {
        return (OverrunStyle)((Object)this.textOverrunProperty().getValue());
    }

    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public final void setWrapText(boolean value) {
        this.wrapTextProperty().setValue(value);
    }

    public final boolean isWrapText() {
        return this.wrapTextProperty().getValue();
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font value) {
        this.fontProperty().setValue(value);
    }

    public final Font getFont() {
        return (Font)this.fontProperty().getValue();
    }

    public final ObjectProperty<Duration> showDelayProperty() {
        return this.showDelayProperty;
    }

    public final void setShowDelay(Duration showDelay) {
        this.showDelayProperty.set(showDelay);
    }

    public final Duration getShowDelay() {
        return (Duration)this.showDelayProperty.get();
    }

    public final ObjectProperty<Duration> showDurationProperty() {
        return this.showDurationProperty;
    }

    public final void setShowDuration(Duration showDuration) {
        this.showDurationProperty.set(showDuration);
    }

    public final Duration getShowDuration() {
        return (Duration)this.showDurationProperty.get();
    }

    public final ObjectProperty<Duration> hideDelayProperty() {
        return this.hideDelayProperty;
    }

    public final void setHideDelay(Duration hideDelay) {
        this.hideDelayProperty.set(hideDelay);
    }

    public final Duration getHideDelay() {
        return (Duration)this.hideDelayProperty.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().setValue(value);
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty().getValue();
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){
                StyleOrigin origin = StyleOrigin.USER;

                @Override
                public void applyStyle(StyleOrigin origin, String v) {
                    this.origin = origin;
                    if (Tooltip.this.graphic == null || !Tooltip.this.graphic.isBound()) {
                        super.applyStyle(origin, v);
                    }
                    this.origin = StyleOrigin.USER;
                }

                @Override
                protected void invalidated() {
                    String url = super.get();
                    if (url == null) {
                        ((StyleableProperty)((Object)Tooltip.this.graphicProperty())).applyStyle(this.origin, null);
                    } else {
                        String imageViewUrl;
                        ImageView imageView;
                        Image image;
                        Node graphicNode = Tooltip.this.getGraphic();
                        if (graphicNode instanceof ImageView && (image = (imageView = (ImageView)graphicNode).getImage()) != null && url.equals(imageViewUrl = image.impl_getUrl())) {
                            return;
                        }
                        Image img = StyleManager.getInstance().getCachedImage(url);
                        if (img != null) {
                            ((StyleableProperty)((Object)Tooltip.this.graphicProperty())).applyStyle(this.origin, new ImageView(img));
                        }
                    }
                }

                @Override
                public String get() {
                    Image image;
                    Node graphic = Tooltip.this.getGraphic();
                    if (graphic instanceof ImageView && (image = ((ImageView)graphic).getImage()) != null) {
                        return image.impl_getUrl();
                    }
                    return null;
                }

                @Override
                public StyleOrigin getStyleOrigin() {
                    return Tooltip.this.graphic != null ? ((StyleableProperty)((Object)Tooltip.this.graphic)).getStyleOrigin() : null;
                }

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "imageUrl";
                }

                @Override
                public CssMetaData<CSSBridge, String> getCssMetaData() {
                    return GRAPHIC;
                }
            };
        }
        return this.imageUrl;
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay value) {
        this.contentDisplayProperty().setValue(value);
    }

    public final ContentDisplay getContentDisplay() {
        return (ContentDisplay)((Object)this.contentDisplayProperty().getValue());
    }

    public final DoubleProperty graphicTextGapProperty() {
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double value) {
        this.graphicTextGapProperty().setValue(value);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGapProperty().getValue();
    }

    final void setActivated(boolean value) {
        this.activated.set(value);
    }

    public final boolean isActivated() {
        return this.activated.get();
    }

    public final ReadOnlyBooleanProperty activatedProperty() {
        return this.activated.getReadOnlyProperty();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TooltipSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Tooltip.getClassCssMetaData();
    }

    @Override
    public Styleable getStyleableParent() {
        if (BEHAVIOR.hoveredNode == null) {
            return super.getStyleableParent();
        }
        return BEHAVIOR.hoveredNode;
    }

    static {
        ArrayList styleables = new ArrayList(PopupControl.getClassCssMetaData());
        styleables.add(FONT);
        styleables.add(TEXT_ALIGNMENT);
        styleables.add(TEXT_OVERRUN);
        styleables.add(WRAP_TEXT);
        styleables.add(GRAPHIC);
        styleables.add(CONTENT_DISPLAY);
        styleables.add(GRAPHIC_TEXT_GAP);
        styleables.add(SHOW_DELAY);
        styleables.add(SHOW_DURATION);
        styleables.add(HIDE_DELAY);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static class TooltipBehavior {
        private Timeline activationTimer = new Timeline();
        private Timeline hideTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private Tooltip activatedTooltip;
        private Tooltip visibleTooltip;
        private double lastMouseX;
        private double lastMouseY;
        private boolean hideOnExit;
        private boolean cssForced = false;
        private EventHandler<MouseEvent> MOVE_HANDLER = event -> {
            this.lastMouseX = event.getScreenX();
            this.lastMouseY = event.getScreenY();
            if (this.hideTimer.getStatus() == Animation.Status.RUNNING) {
                return;
            }
            this.hoveredNode = (Node)event.getSource();
            Tooltip t = (Tooltip)this.hoveredNode.getProperties().get(TOOLTIP_PROP_KEY);
            if (t != null) {
                Window owner = this.getWindow(this.hoveredNode);
                boolean treeVisible = this.isWindowHierarchyVisible(this.hoveredNode);
                if (owner != null && treeVisible) {
                    if (this.leftTimer.getStatus() == Animation.Status.RUNNING) {
                        if (this.visibleTooltip != null) {
                            this.visibleTooltip.hide();
                        }
                        this.visibleTooltip = t;
                        t.show(owner, event.getScreenX() + (double)TOOLTIP_XOFFSET, event.getScreenY() + (double)TOOLTIP_YOFFSET);
                        this.leftTimer.stop();
                        if (t.getShowDuration() != null) {
                            this.hideTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(t.getShowDuration(), new KeyValue[0])});
                        }
                        this.hideTimer.playFromStart();
                    } else {
                        if (!this.cssForced) {
                            double opacity = t.getOpacity();
                            t.setOpacity(0.0);
                            t.show(owner);
                            t.hide();
                            t.setOpacity(opacity);
                            this.cssForced = true;
                        }
                        t.setActivated(true);
                        this.activatedTooltip = t;
                        this.activationTimer.stop();
                        if (t.getShowDelay() != null) {
                            this.activationTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(t.getShowDelay(), new KeyValue[0])});
                        }
                        this.activationTimer.playFromStart();
                    }
                }
            }
        };
        private EventHandler<MouseEvent> LEAVING_HANDLER = event -> {
            if (this.activationTimer.getStatus() == Animation.Status.RUNNING) {
                this.activationTimer.stop();
            } else if (this.hideTimer.getStatus() == Animation.Status.RUNNING) {
                Node source;
                Tooltip t;
                assert (this.visibleTooltip != null);
                this.hideTimer.stop();
                if (this.hideOnExit) {
                    this.visibleTooltip.hide();
                }
                if ((t = (Tooltip)(source = (Node)event.getSource()).getProperties().get(TOOLTIP_PROP_KEY)) != null) {
                    if (t.getHideDelay() != null) {
                        this.leftTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(t.getHideDelay(), new KeyValue[0])});
                    }
                    this.leftTimer.playFromStart();
                }
            }
            this.hoveredNode = null;
            this.activatedTooltip = null;
            if (this.hideOnExit) {
                this.visibleTooltip = null;
            }
        };
        private EventHandler<MouseEvent> KILL_HANDLER = event -> {
            this.activationTimer.stop();
            this.hideTimer.stop();
            this.leftTimer.stop();
            if (this.visibleTooltip != null) {
                this.visibleTooltip.hide();
            }
            this.hoveredNode = null;
            this.activatedTooltip = null;
            this.visibleTooltip = null;
        };

        TooltipBehavior(boolean hideOnExit) {
            this.hideOnExit = hideOnExit;
            this.activationTimer.setOnFinished(event -> {
                assert (this.activatedTooltip != null);
                Window owner = this.getWindow(this.hoveredNode);
                boolean treeVisible = this.isWindowHierarchyVisible(this.hoveredNode);
                if (owner != null && owner.isShowing() && treeVisible) {
                    double x = this.lastMouseX;
                    double y = this.lastMouseY;
                    NodeOrientation nodeOrientation = this.hoveredNode.getEffectiveNodeOrientation();
                    this.activatedTooltip.getScene().setNodeOrientation(nodeOrientation);
                    if (nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
                        x -= this.activatedTooltip.getWidth();
                    }
                    this.activatedTooltip.show(owner, x + (double)TOOLTIP_XOFFSET, y + (double)TOOLTIP_YOFFSET);
                    if (y + (double)TOOLTIP_YOFFSET > this.activatedTooltip.getAnchorY()) {
                        this.activatedTooltip.hide();
                        this.activatedTooltip.show(owner, x + (double)TOOLTIP_XOFFSET, y -= this.activatedTooltip.getHeight());
                    }
                    this.visibleTooltip = this.activatedTooltip;
                    this.hoveredNode = null;
                    if (this.activatedTooltip.getShowDuration() != null) {
                        this.hideTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(this.activatedTooltip.getShowDuration(), new KeyValue[0])});
                    }
                    this.hideTimer.playFromStart();
                }
                this.activatedTooltip.setActivated(false);
                this.activatedTooltip = null;
            });
            this.hideTimer.setOnFinished(event -> {
                assert (this.visibleTooltip != null);
                this.visibleTooltip.hide();
                this.visibleTooltip = null;
                this.hoveredNode = null;
            });
            this.leftTimer.setOnFinished(event -> {
                if (!hideOnExit) {
                    assert (this.visibleTooltip != null);
                    this.visibleTooltip.hide();
                    this.visibleTooltip = null;
                    this.hoveredNode = null;
                }
            });
        }

        private void install(Node node, Tooltip t) {
            if (node == null) {
                return;
            }
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            node.getProperties().put(TOOLTIP_PROP_KEY, t);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            Tooltip t = (Tooltip)node.getProperties().get(TOOLTIP_PROP_KEY);
            if (t != null) {
                node.getProperties().remove(TOOLTIP_PROP_KEY);
                if (t.equals(this.visibleTooltip) || t.equals(this.activatedTooltip)) {
                    this.KILL_HANDLER.handle(null);
                }
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }

        private boolean isWindowHierarchyVisible(Node node) {
            Parent parent;
            boolean treeVisible = node != null;
            Parent parent2 = parent = node == null ? null : node.getParent();
            while (parent != null && treeVisible) {
                treeVisible = parent.isVisible();
                parent = parent.getParent();
            }
            return treeVisible;
        }
    }

    private final class CSSBridge
    extends PopupControl.CSSBridge {
        private Tooltip tooltip;

        CSSBridge() {
            this.tooltip = Tooltip.this;
            this.setAccessibleRole(AccessibleRole.TOOLTIP);
        }
    }
}

