/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;

public class TreeCellBehavior<T>
extends CellBehaviorBase<TreeCell<T>> {
    public TreeCellBehavior(TreeCell<T> control) {
        super(control, Collections.emptyList());
    }

    @Override
    protected MultipleSelectionModel<TreeItem<T>> getSelectionModel() {
        return ((TreeView)this.getCellContainer()).getSelectionModel();
    }

    @Override
    protected FocusModel<TreeItem<T>> getFocusModel() {
        return ((TreeView)this.getCellContainer()).getFocusModel();
    }

    @Override
    protected TreeView<T> getCellContainer() {
        return ((TreeCell)this.getControl()).getTreeView();
    }

    @Override
    protected void edit(TreeCell<T> cell) {
        TreeItem<T> treeItem = cell == null ? null : cell.getTreeItem();
        ((TreeView)this.getCellContainer()).edit(treeItem);
    }

    @Override
    protected void handleClicks(MouseButton button, int clickCount, boolean isAlreadySelected) {
        TreeItem treeItem = ((TreeCell)this.getControl()).getTreeItem();
        if (button == MouseButton.PRIMARY) {
            if (clickCount == 1 && isAlreadySelected) {
                this.edit((TreeCell)this.getControl());
            } else if (clickCount == 1) {
                this.edit((TreeCell<T>)null);
            } else if (clickCount == 2 && treeItem.isLeaf()) {
                this.edit((TreeCell)this.getControl());
            } else if (clickCount % 2 == 0) {
                treeItem.setExpanded(!treeItem.isExpanded());
            }
        }
    }

    @Override
    protected boolean handleDisclosureNode(double x, double y) {
        TreeCell treeCell = (TreeCell)this.getControl();
        Node disclosureNode = treeCell.getDisclosureNode();
        if (disclosureNode != null && disclosureNode.getBoundsInParent().contains(x, y)) {
            if (treeCell.getTreeItem() != null) {
                treeCell.getTreeItem().setExpanded(!treeCell.getTreeItem().isExpanded());
            }
            return true;
        }
        return false;
    }
}

