/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCombination;

public class ControlAcceleratorSupport {
    private static Map<Object, WeakReference<ChangeListener<Scene>>> sceneChangeListenerMap = new WeakHashMap<Object, WeakReference<ChangeListener<Scene>>>();
    private static Map<MenuItem, WeakReference<ChangeListener<KeyCombination>>> changeListenerMap = new WeakHashMap<MenuItem, WeakReference<ChangeListener<KeyCombination>>>();

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> items, Tab anchor) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(items, (Object)anchor);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> items, TableColumnBase<?, ?> anchor) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(items, anchor);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> items, Node anchor) {
        WeakReference<ChangeListener<Scene>> listenerW;
        if (items == null) {
            return;
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        Scene scene = anchor.getScene();
        if (scene != null) {
            ControlAcceleratorSupport.doAcceleratorInstall(items, scene);
        }
        if ((listenerW = sceneChangeListenerMap.get(anchor)) != null) {
            ChangeListener listener = (ChangeListener)listenerW.get();
            if (listener != null) {
                anchor.sceneProperty().removeListener(listener);
            }
            sceneChangeListenerMap.remove(anchor);
        }
        anchor.sceneProperty().addListener(ControlAcceleratorSupport.getSceneChangeListener(anchor, items));
    }

    private static void addAcceleratorsIntoScene(final ObservableList<MenuItem> items, Object anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        final ReadOnlyObjectProperty<? extends Control> controlProperty = ControlAcceleratorSupport.getControlProperty(anchor);
        Control control = (Control)controlProperty.get();
        if (control == null) {
            controlProperty.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    Control control = (Control)controlProperty.get();
                    if (control != null) {
                        controlProperty.removeListener(this);
                        ControlAcceleratorSupport.addAcceleratorsIntoScene((ObservableList<MenuItem>)items, control);
                    }
                }
            });
        } else {
            ControlAcceleratorSupport.addAcceleratorsIntoScene(items, control);
        }
    }

    private static ChangeListener<Scene> getSceneChangeListener(Object anchor, ObservableList<MenuItem> items) {
        ChangeListener<Scene> sceneChangeListener;
        WeakReference<ChangeListener<Scene>> sceneChangeListenerW = sceneChangeListenerMap.get(anchor);
        ChangeListener<Scene> changeListener = sceneChangeListener = sceneChangeListenerW == null ? null : (ChangeListener<Scene>)sceneChangeListenerW.get();
        if (sceneChangeListener == null) {
            sceneChangeListener = (ov, oldScene, newScene) -> {
                if (oldScene != null) {
                    ControlAcceleratorSupport.removeAcceleratorsFromScene((List<? extends MenuItem>)items, oldScene);
                }
                if (newScene != null) {
                    ControlAcceleratorSupport.doAcceleratorInstall(items, newScene);
                }
            };
            sceneChangeListenerMap.put(anchor, new WeakReference<ChangeListener<Scene>>(sceneChangeListener));
        }
        return sceneChangeListener;
    }

    private static void doAcceleratorInstall(ObservableList<MenuItem> items, Scene scene) {
        items.addListener(c -> {
            while (c.next()) {
                if (c.wasRemoved()) {
                    ControlAcceleratorSupport.removeAcceleratorsFromScene(c.getRemoved(), scene);
                }
                if (!c.wasAdded()) continue;
                ControlAcceleratorSupport.doAcceleratorInstall(c.getAddedSubList(), scene);
            }
        });
        ControlAcceleratorSupport.doAcceleratorInstall(items, scene);
    }

    private static void doAcceleratorInstall(List<? extends MenuItem> items, Scene scene) {
        for (MenuItem menuItem : items) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.doAcceleratorInstall(((Menu)menuItem).getItems(), scene);
                continue;
            }
            if (menuItem.getAccelerator() != null) {
                ObservableMap<KeyCombination, Runnable> accelerators = scene.getAccelerators();
                Runnable acceleratorRunnable = () -> {
                    Menu target;
                    if (menuitem.getOnMenuValidation() != null) {
                        Event.fireEvent(menuitem, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if ((target = menuitem.getParentMenu()) != null && target.getOnMenuValidation() != null) {
                        Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if (!menuitem.isDisable()) {
                        if (menuitem instanceof RadioMenuItem) {
                            ((RadioMenuItem)menuitem).setSelected(!((RadioMenuItem)menuitem).isSelected());
                        } else if (menuitem instanceof CheckMenuItem) {
                            ((CheckMenuItem)menuitem).setSelected(!((CheckMenuItem)menuitem).isSelected());
                        }
                        menuitem.fire();
                    }
                };
                accelerators.put(menuItem.getAccelerator(), acceleratorRunnable);
            }
            menuItem.acceleratorProperty().addListener(ControlAcceleratorSupport.getListener(scene, menuItem));
        }
    }

    private static ChangeListener<KeyCombination> getListener(Scene scene, MenuItem menuItem) {
        ChangeListener<KeyCombination> listener;
        WeakReference<ChangeListener<KeyCombination>> listenerW = changeListenerMap.get(menuItem);
        ChangeListener<KeyCombination> changeListener = listener = listenerW == null ? null : (ChangeListener<KeyCombination>)listenerW.get();
        if (listener == null) {
            listener = (observable, oldValue, newValue) -> {
                ObservableMap<KeyCombination, Runnable> accelerators = scene.getAccelerators();
                Runnable _acceleratorRunnable = (Runnable)accelerators.remove(oldValue);
                if (newValue != null) {
                    accelerators.put((KeyCombination)newValue, _acceleratorRunnable);
                }
            };
            changeListenerMap.put(menuItem, new WeakReference<ChangeListener<KeyCombination>>(listener));
        }
        return listener;
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, Tab anchor) {
        TabPane tabPane = anchor.getTabPane();
        if (tabPane == null) {
            return;
        }
        Scene scene = tabPane.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(items, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, TableColumnBase<?, ?> anchor) {
        ReadOnlyObjectProperty<? extends Control> controlProperty = ControlAcceleratorSupport.getControlProperty(anchor);
        if (controlProperty == null) {
            return;
        }
        Control control = (Control)controlProperty.get();
        if (control == null) {
            return;
        }
        Scene scene = control.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(items, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, Node anchor) {
        WeakReference<ChangeListener<Scene>> listenerW;
        Scene scene = anchor.getScene();
        if (scene == null && (listenerW = sceneChangeListenerMap.get(anchor)) != null) {
            ChangeListener listener = (ChangeListener)listenerW.get();
            if (listener != null) {
                anchor.sceneProperty().removeListener(listener);
            }
            sceneChangeListenerMap.remove(anchor);
        }
        ControlAcceleratorSupport.removeAcceleratorsFromScene(items, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, Scene scene) {
        if (scene == null) {
            return;
        }
        for (MenuItem menuItem : items) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(((Menu)menuItem).getItems(), scene);
                continue;
            }
            ObservableMap<KeyCombination, Runnable> accelerators = scene.getAccelerators();
            accelerators.remove(menuItem.getAccelerator());
            WeakReference<ChangeListener<KeyCombination>> listenerW = changeListenerMap.get(menuItem);
            if (listenerW == null) continue;
            ChangeListener listener = (ChangeListener)listenerW.get();
            if (listener != null) {
                menuItem.acceleratorProperty().removeListener(listener);
            }
            changeListenerMap.remove(menuItem);
        }
    }

    private static ReadOnlyObjectProperty<? extends Control> getControlProperty(Object obj) {
        if (obj instanceof TableColumn) {
            return ((TableColumn)obj).tableViewProperty();
        }
        if (obj instanceof TreeTableColumn) {
            return ((TreeTableColumn)obj).treeTableViewProperty();
        }
        if (obj instanceof Tab) {
            return ((Tab)obj).tabPaneProperty();
        }
        return null;
    }
}

