/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.rpc.krpc.internal;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.rpc.krpc.internal.HandlerKey;
import kotlinx.rpc.krpc.internal.KrpcCallMessage;
import kotlinx.rpc.krpc.internal.KrpcGenericMessage;
import kotlinx.rpc.krpc.internal.KrpcMessage;
import kotlinx.rpc.krpc.internal.KrpcPluginKey;
import kotlinx.rpc.krpc.internal.KrpcProtocolMessage;
import kotlinx.rpc.krpc.internal.WindowResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\b\b\u0000\u0010\u0001*\u00020\u0000*\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkotlinx/rpc/krpc/internal/KrpcMessage;", "Message", "Lkotlinx/rpc/krpc/internal/HandlerKey;", "handlerKey", "(Lkotlinx/rpc/krpc/internal/KrpcMessage;)Lkotlinx/rpc/krpc/internal/HandlerKey;", "Lkotlinx/rpc/krpc/internal/KrpcGenericMessage;", "message", "Lkotlinx/rpc/krpc/internal/WindowResult;", "decodeWindow", "(Lkotlinx/rpc/krpc/internal/KrpcGenericMessage;)Lkotlinx/rpc/krpc/internal/WindowResult;", "krpc-core"})
public final class KrpcReceiveHandlerKt {
    @NotNull
    public static final <Message extends KrpcMessage> HandlerKey<Message> handlerKey(@NotNull Message $this$handlerKey) {
        HandlerKey handlerKey;
        Intrinsics.checkNotNullParameter($this$handlerKey, (String)"<this>");
        Message Message = $this$handlerKey;
        if (Message instanceof KrpcCallMessage) {
            handlerKey = new HandlerKey.ServiceCall(((KrpcCallMessage)$this$handlerKey).getServiceType(), ((KrpcCallMessage)$this$handlerKey).getCallId());
        } else if (Message instanceof KrpcProtocolMessage) {
            handlerKey = HandlerKey.Protocol.INSTANCE;
        } else if (Message instanceof KrpcGenericMessage) {
            handlerKey = HandlerKey.Generic.INSTANCE;
        } else {
            throw new IllegalStateException("unreachable".toString());
        }
        HandlerKey handlerKey2 = handlerKey;
        Intrinsics.checkNotNull((Object)handlerKey2, (String)"null cannot be cast to non-null type kotlinx.rpc.krpc.internal.HandlerKey<Message of kotlinx.rpc.krpc.internal.KrpcReceiveHandlerKt.handlerKey>");
        return handlerKey2;
    }

    @NotNull
    public static final WindowResult decodeWindow(@NotNull KrpcGenericMessage message) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Map<KrpcPluginKey, String> map = message.getPluginParams();
        String windowParam = map != null ? map.get(KrpcPluginKey.WINDOW_UPDATE) : null;
        CharSequence charSequence = windowParam;
        if (charSequence == null || charSequence.length() == 0) {
            return new WindowResult.Failure("Window param must be of the form <available>/<windowId>");
        }
        Integer n = StringsKt.toIntOrNull((String)windowParam);
        if (n == null) {
            return new WindowResult.Failure("Window param must be of the form <available>/<windowId> and in form of two longs");
        }
        int updateParam = n;
        String string = message.getPluginParams().get(KrpcPluginKey.WINDOW_KEY);
        if (string != null) {
            String[] stringArray = new String[]{"/"};
            list2 = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List windowKey = list;
        String serviceType = (String)CollectionsKt.getOrNull((List)windowKey, (int)0);
        String callId = (String)CollectionsKt.getOrNull((List)windowKey, (int)1);
        if (windowKey.size() != 2 || serviceType == null || callId == null) {
            return new WindowResult.Failure("Window key must be of the form <serviceType>/<callId>");
        }
        HandlerKey.ServiceCall subscriptionKey = new HandlerKey.ServiceCall(serviceType, callId);
        return new WindowResult.Success(updateParam, subscriptionKey);
    }
}

