/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.proto.SignatureDataProto;

public final class SignatureAlgorithm
extends Enum<SignatureAlgorithm> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ContentDigestAlgorithm contentDigestAlgorithm;
    @NotNull
    private final String jcaKeyAlgorithm;
    @NotNull
    private final String jcaSignatureAlgorithm;
    public static final /* enum */ SignatureAlgorithm ECDSA_WITH_SHA384;
    public static final /* enum */ SignatureAlgorithm RSA_PKCS1_V1_5_WITH_SHA256;
    public static final /* enum */ SignatureAlgorithm RSA_PKCS1_V1_5_WITH_SHA512;
    public static final /* enum */ SignatureAlgorithm DSA_WITH_SHA256;
    private static final /* synthetic */ SignatureAlgorithm[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private SignatureAlgorithm(ContentDigestAlgorithm contentDigestAlgorithm, String jcaKeyAlgorithm, String jcaSignatureAlgorithm) {
        this.contentDigestAlgorithm = contentDigestAlgorithm;
        this.jcaKeyAlgorithm = jcaKeyAlgorithm;
        this.jcaSignatureAlgorithm = jcaSignatureAlgorithm;
    }

    @NotNull
    public final ContentDigestAlgorithm getContentDigestAlgorithm() {
        return this.contentDigestAlgorithm;
    }

    @NotNull
    public final String getJcaSignatureAlgorithm() {
        return this.jcaSignatureAlgorithm;
    }

    static {
        ECDSA_WITH_SHA384 = new SignatureAlgorithm(ContentDigestAlgorithm.CHUNKED_SHA384, "ECDSA", "SHA384withECDSA");
        RSA_PKCS1_V1_5_WITH_SHA256 = new SignatureAlgorithm(ContentDigestAlgorithm.CHUNKED_SHA256, "RSA", "SHA256withRSA");
        RSA_PKCS1_V1_5_WITH_SHA512 = new SignatureAlgorithm(ContentDigestAlgorithm.CHUNKED_SHA512, "RSA", "SHA512withRSA");
        DSA_WITH_SHA256 = new SignatureAlgorithm(ContentDigestAlgorithm.CHUNKED_SHA256, "DSA", "SHA256withDSA");
        $VALUES = signatureAlgorithmArray = new SignatureAlgorithm[]{SignatureAlgorithm.ECDSA_WITH_SHA384, SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256, SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512, SignatureAlgorithm.DSA_WITH_SHA256};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignatureAlgorithm fromProtobufEnum(@NotNull SignatureDataProto.AlgorithmId protobufAlgorithmId) {
            SignatureAlgorithm signatureAlgorithm;
            Intrinsics.checkNotNullParameter((Object)protobufAlgorithmId, (String)"protobufAlgorithmId");
            switch (WhenMappings.$EnumSwitchMapping$0[protobufAlgorithmId.ordinal()]) {
                case 1: {
                    signatureAlgorithm = ECDSA_WITH_SHA384;
                    break;
                }
                case 2: {
                    signatureAlgorithm = RSA_PKCS1_V1_5_WITH_SHA256;
                    break;
                }
                case 3: {
                    signatureAlgorithm = RSA_PKCS1_V1_5_WITH_SHA512;
                    break;
                }
                case 4: {
                    signatureAlgorithm = DSA_WITH_SHA256;
                    break;
                }
                case 5: {
                    throw new IllegalArgumentException("Unknown signature type");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return signatureAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SignatureDataProto.AlgorithmId.values().length];
                try {
                    nArray[SignatureDataProto.AlgorithmId.ECDSA_WITH_SHA384.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureDataProto.AlgorithmId.RSA_WITH_SHA256.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureDataProto.AlgorithmId.RSA_WITH_SHA512.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureDataProto.AlgorithmId.DSA_WITH_SHA256.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureDataProto.AlgorithmId.UNRECOGNIZED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

