/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.ByteString;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.proto.DigestProto;

public final class Digest {
    @NotNull
    private final ContentDigestAlgorithm algorithm;
    @NotNull
    private final byte[] digestBytes;
    @NotNull
    private final DigestProto protobufRepresentation;

    private Digest(ContentDigestAlgorithm algorithm, byte[] digestBytes, DigestProto protobufRepresentation) {
        this.algorithm = algorithm;
        this.digestBytes = digestBytes;
        this.protobufRepresentation = protobufRepresentation;
    }

    @NotNull
    public final ContentDigestAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getDigestBytes() {
        return this.digestBytes;
    }

    public Digest(@NotNull DigestProto protobufRepresentation) {
        Intrinsics.checkNotNullParameter((Object)protobufRepresentation, (String)"protobufRepresentation");
        DigestProto.AlgorithmId algorithmId = protobufRepresentation.getAlgorithmId();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmId, (String)"getAlgorithmId(...)");
        ContentDigestAlgorithm contentDigestAlgorithm = ContentDigestAlgorithm.Companion.fromProtobufEnum(algorithmId);
        byte[] byArray = protobufRepresentation.getDigestBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this(contentDigestAlgorithm, byArray, protobufRepresentation);
    }

    public Digest(@NotNull ContentDigestAlgorithm algorithm, @NotNull byte[] digestBytes) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)digestBytes, (String)"digestBytes");
        DigestProto digestProto = DigestProto.newBuilder().setAlgorithmId(algorithm.toProtobufEnum()).setDigestBytes(ByteString.copyFrom(digestBytes)).build();
        Intrinsics.checkNotNullExpressionValue((Object)digestProto, (String)"build(...)");
        this(algorithm, digestBytes, digestProto);
    }
}

