/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.proto.DigestProto;

public final class ContentDigestAlgorithm
extends Enum<ContentDigestAlgorithm> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String jcaMessageDigestAlgorithm;
    private final int chunkDigestOutputSizeBytes;
    public static final /* enum */ ContentDigestAlgorithm CHUNKED_SHA256;
    public static final /* enum */ ContentDigestAlgorithm CHUNKED_SHA384;
    public static final /* enum */ ContentDigestAlgorithm CHUNKED_SHA512;
    private static final /* synthetic */ ContentDigestAlgorithm[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ContentDigestAlgorithm(String jcaMessageDigestAlgorithm, int chunkDigestOutputSizeBytes) {
        this.jcaMessageDigestAlgorithm = jcaMessageDigestAlgorithm;
        this.chunkDigestOutputSizeBytes = chunkDigestOutputSizeBytes;
    }

    @NotNull
    public final String getJcaMessageDigestAlgorithm() {
        return this.jcaMessageDigestAlgorithm;
    }

    public final int getChunkDigestOutputSizeBytes() {
        return this.chunkDigestOutputSizeBytes;
    }

    @NotNull
    public final DigestProto.AlgorithmId toProtobufEnum() {
        DigestProto.AlgorithmId algorithmId;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                algorithmId = DigestProto.AlgorithmId.SHA256;
                break;
            }
            case 2: {
                algorithmId = DigestProto.AlgorithmId.SHA384;
                break;
            }
            case 3: {
                algorithmId = DigestProto.AlgorithmId.SHA512;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return algorithmId;
    }

    public static ContentDigestAlgorithm[] values() {
        return (ContentDigestAlgorithm[])$VALUES.clone();
    }

    static {
        CHUNKED_SHA256 = new ContentDigestAlgorithm("SHA-256", 32);
        CHUNKED_SHA384 = new ContentDigestAlgorithm("SHA-384", 48);
        CHUNKED_SHA512 = new ContentDigestAlgorithm("SHA-512", 64);
        $VALUES = contentDigestAlgorithmArray = new ContentDigestAlgorithm[]{ContentDigestAlgorithm.CHUNKED_SHA256, ContentDigestAlgorithm.CHUNKED_SHA384, ContentDigestAlgorithm.CHUNKED_SHA512};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContentDigestAlgorithm fromProtobufEnum(@NotNull DigestProto.AlgorithmId protobufEnum) {
            ContentDigestAlgorithm contentDigestAlgorithm;
            Intrinsics.checkNotNullParameter((Object)protobufEnum, (String)"protobufEnum");
            switch (WhenMappings.$EnumSwitchMapping$0[protobufEnum.ordinal()]) {
                case 1: {
                    contentDigestAlgorithm = CHUNKED_SHA256;
                    break;
                }
                case 2: {
                    contentDigestAlgorithm = CHUNKED_SHA384;
                    break;
                }
                case 3: {
                    contentDigestAlgorithm = CHUNKED_SHA512;
                    break;
                }
                case 4: {
                    throw new IllegalArgumentException("Unsupported digest algorithm");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return contentDigestAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DigestProto.AlgorithmId.values().length];
                try {
                    nArray[DigestProto.AlgorithmId.SHA256.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DigestProto.AlgorithmId.SHA384.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DigestProto.AlgorithmId.SHA512.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DigestProto.AlgorithmId.UNRECOGNIZED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContentDigestAlgorithm.values().length];
            try {
                nArray[ContentDigestAlgorithm.CHUNKED_SHA256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContentDigestAlgorithm.CHUNKED_SHA384.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContentDigestAlgorithm.CHUNKED_SHA512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

