/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextMateWeigh
implements Comparable<TextMateWeigh> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int weigh;
    @NotNull
    private final Priority priority;
    @NotNull
    private static final TextMateWeigh ZERO = new TextMateWeigh(0, Priority.LOW);

    public TextMateWeigh(int weigh, @NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        this.weigh = weigh;
        this.priority = priority;
    }

    public final int getWeigh() {
        return this.weigh;
    }

    @NotNull
    public final Priority getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(@NotNull TextMateWeigh other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int priorityCompare = this.priority.compareTo((Enum)other.priority);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        return Intrinsics.compare((int)this.weigh, (int)other.weigh);
    }

    @NotNull
    public String toString() {
        return "TextMateWeigh(weigh=" + this.weigh + ", priority=" + this.priority + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.weigh);
        result2 = result2 * 31 + this.priority.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextMateWeigh)) {
            return false;
        }
        TextMateWeigh textMateWeigh = (TextMateWeigh)other;
        if (this.weigh != textMateWeigh.weigh) {
            return false;
        }
        return this.priority == textMateWeigh.priority;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextMateWeigh getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority LOW = new Priority();
        public static final /* enum */ Priority NORMAL = new Priority();
        public static final /* enum */ Priority HIGH = new Priority();
        private static final /* synthetic */ Priority[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        static {
            $VALUES = priorityArray = new Priority[]{Priority.LOW, Priority.NORMAL, Priority.HIGH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

